/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.scoping;

import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;

public class NestedTypeAwareImportNormalizer
extends ImportNormalizer {
    private final QualifiedName importedNamespacePrefix;
    private final boolean wildCard;

    public NestedTypeAwareImportNormalizer(QualifiedName importedNamespace, boolean wildCard, boolean ignoreCase) {
        super(importedNamespace, wildCard, ignoreCase);
        if (ignoreCase) {
            throw new IllegalArgumentException("ignoreCase is currently not supported");
        }
        this.importedNamespacePrefix = importedNamespace;
        this.wildCard = wildCard;
    }

    public QualifiedName deresolve(QualifiedName fullyQualifiedName) {
        if (this.wildCard) {
            if (fullyQualifiedName.startsWith(this.importedNamespacePrefix) && fullyQualifiedName.getSegmentCount() != this.importedNamespacePrefix.getSegmentCount()) {
                return fullyQualifiedName.skipFirst(this.importedNamespacePrefix.getSegmentCount());
            }
        } else {
            if (fullyQualifiedName.equals((Object)this.importedNamespacePrefix)) {
                String lastSegment = fullyQualifiedName.getLastSegment();
                int dollar = lastSegment.lastIndexOf(36);
                if (dollar >= 0) {
                    return QualifiedName.create((String[])new String[]{lastSegment.substring(dollar + 1)});
                }
                return QualifiedName.create((String[])new String[]{fullyQualifiedName.getLastSegment()});
            }
            if (fullyQualifiedName.skipLast(1).equals((Object)this.importedNamespacePrefix.skipLast(1))) {
                String lastImportedSegment = this.importedNamespacePrefix.getLastSegment();
                String lastSegment = fullyQualifiedName.getLastSegment();
                if (lastSegment.startsWith(lastImportedSegment) && lastSegment.charAt(lastImportedSegment.length()) == '$') {
                    int dollar = lastImportedSegment.lastIndexOf(36);
                    if (dollar == -1) {
                        return fullyQualifiedName.skipFirst(this.importedNamespacePrefix.getSegmentCount() - 1);
                    }
                    return QualifiedName.create((String[])new String[]{lastSegment.substring(dollar + 1)});
                }
            }
        }
        return null;
    }

    public QualifiedName resolve(QualifiedName relativeName) {
        if (this.wildCard) {
            return this.importedNamespacePrefix.append(relativeName);
        }
        if (relativeName.getSegmentCount() == 1) {
            String nestedTypeName;
            if (relativeName.getLastSegment().equals(this.importedNamespacePrefix.getLastSegment())) {
                return this.importedNamespacePrefix;
            }
            String relativeNameAsString = relativeName.getLastSegment();
            String lastImportedSegment = this.importedNamespacePrefix.getLastSegment();
            int dollar = relativeNameAsString.indexOf(36);
            if (dollar >= 0 && dollar == lastImportedSegment.length() && relativeNameAsString.startsWith(lastImportedSegment)) {
                return this.importedNamespacePrefix.skipLast(1).append(relativeNameAsString);
            }
            int importedDollar = lastImportedSegment.lastIndexOf(36);
            if (importedDollar >= 0 && relativeNameAsString.startsWith(nestedTypeName = lastImportedSegment.substring(importedDollar + 1))) {
                if (nestedTypeName.length() == relativeNameAsString.length()) {
                    return this.importedNamespacePrefix;
                }
                if (relativeNameAsString.charAt(nestedTypeName.length()) == '$') {
                    return this.importedNamespacePrefix.skipLast(1).append(String.valueOf(lastImportedSegment) + relativeNameAsString.substring(nestedTypeName.length()));
                }
            }
        }
        return null;
    }
}

