/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.validation.XbaseWithAnnotationsJavaValidator;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xtend2.dispatch.DispatchingSupport;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.richstring.RichStringProcessor;
import org.eclipse.xtext.xtend2.typing.XtendOverridesService;
import org.eclipse.xtext.xtend2.validation.ClasspathBasedChecks;
import org.eclipse.xtext.xtend2.validation.ValidatingRichStringAcceptor;
import org.eclipse.xtext.xtend2.xtend2.RichString;
import org.eclipse.xtext.xtend2.xtend2.RichStringElseIf;
import org.eclipse.xtext.xtend2.xtend2.RichStringForLoop;
import org.eclipse.xtext.xtend2.xtend2.RichStringIf;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComposedChecks(validators={ClasspathBasedChecks.class})
public class Xtend2JavaValidator
extends XbaseWithAnnotationsJavaValidator {
    @Inject
    private FeatureOverridesService featureOverridesService;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private IXtend2JvmAssociations associations;
    @Inject
    private XtendOverridesService overridesService;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private Primitives primitives;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private XAnnotationUtil annotationUtil;
    private final Set<EReference> typeConformanceCheckedReferences = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.getTypeConformanceCheckedReferences(), (Iterable)ImmutableSet.of((Object[])new EReference[]{Xtend2Package.Literals.CREATE_EXTENSION_INFO__CREATE_EXPRESSION, Xtend2Package.Literals.RICH_STRING_FOR_LOOP__AFTER, Xtend2Package.Literals.RICH_STRING_FOR_LOOP__BEFORE, Xtend2Package.Literals.RICH_STRING_FOR_LOOP__SEPARATOR, Xtend2Package.Literals.RICH_STRING_IF__IF, Xtend2Package.Literals.RICH_STRING_ELSE_IF__IF})));

    protected List<EPackage> getEPackages() {
        return Lists.newArrayList((Object[])new EPackage[]{Xtend2Package.eINSTANCE, XbasePackage.eINSTANCE, XAnnotationsPackage.eINSTANCE});
    }

    protected Set<EReference> getTypeConformanceCheckedReferences() {
        return this.typeConformanceCheckedReferences;
    }

    @Check
    public void checkNoSideffectFreeExpressionsInBlockExpression(XBlockExpression blockExpression) {
        if (blockExpression instanceof RichString) {
            return;
        }
        super.checkNoSideffectFreeExpressionsInBlockExpression(blockExpression);
    }

    @Check
    public void checkAnnotationTarget(XAnnotation annotation) {
        JvmAnnotationType annotationType = annotation.getAnnotationType();
        Set targets = this.annotationUtil.getAnnotationTargets(annotationType);
        if (targets.isEmpty()) {
            return;
        }
        EObject eContainer = this.getContainingAnnotationTarget(annotation);
        Map<Class<?>, ElementType> targetInfos = this.getTargetInfos();
        for (Map.Entry<Class<?>, ElementType> mapping : targetInfos.entrySet()) {
            if (!mapping.getKey().isInstance(eContainer) || targets.contains((Object)mapping.getValue())) continue;
            this.error("The annotation @" + annotation.getAnnotationType().getIdentifier() + " is disallowed for this location.", (EObject)annotation, null, -1, "org.eclipse.xtext.xtend2.validation.IssueCodes.wrong_annotation_target", new String[0]);
        }
    }

    protected EObject getContainingAnnotationTarget(XAnnotation annotation) {
        EObject eContainer = annotation.eContainer();
        if (eContainer.eClass() == Xtend2Package.Literals.XTEND_MEMBER) {
            return eContainer.eContainer();
        }
        return eContainer;
    }

    protected Map<Class<?>, ElementType> getTargetInfos() {
        HashMap result = Maps.newHashMap();
        result.put(XtendClass.class, ElementType.TYPE);
        result.put(XtendField.class, ElementType.FIELD);
        result.put(XtendFunction.class, ElementType.METHOD);
        result.put(XtendParameter.class, ElementType.PARAMETER);
        return result;
    }

    @Check
    public void checkAssignment(XAssignment assignment) {
        JvmIdentifiableElement assignmentFeature = assignment.getFeature();
        if (assignmentFeature instanceof XtendParameter) {
            this.error("Assignment to final parameter", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else {
            super.checkAssignment(assignment);
        }
    }

    @Check
    public void checkVariableNameShadowing(XtendFunction func) {
        for (XtendParameter p : func.getParameters()) {
            super.checkDeclaredVariableName((EObject)func, (EObject)p, Xtend2Package.Literals.XTEND_PARAMETER__NAME);
        }
    }

    @Check
    public void checkNoVoidInDependencyDeclaration(XtendField dep) {
        if (this.typeReferences.is(dep.getType(), Void.TYPE)) {
            this.error("Primitive void cannot be a dependency.", (EObject)dep.getType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkXtendParameterNotPrimitiveVoid(XtendParameter param) {
        if (this.typeReferences.is(param.getParameterType(), Void.TYPE)) {
            XtendFunction function = (XtendFunction)(param.eContainer() instanceof XtendFunction ? param.eContainer() : null);
            if (function != null) {
                this.error("void is an invalid type for the parameter " + param.getName() + " of the function " + function.getName(), (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error("void is an invalid type for the parameter " + param.getName(), (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    @Check
    public void checkClassPath(XtendClass clazz) {
        JvmGenericType listType = (JvmGenericType)this.getTypeRefs().findDeclaredType(List.class.getName(), (Notifier)clazz);
        if (listType == null || listType.getTypeParameters().isEmpty()) {
            this.error("Xtend requires Java source level 1.5.", clazz, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.xbase_lib_not_on_classpath", new String[0]);
        }
        if (this.getTypeRefs().findDeclaredType("org.eclipse.xtext.xtend2.lib.StringConcatenation", (Notifier)clazz) == null) {
            this.error("Mandatory library bundle 'org.eclipse.xtext.xtend2.lib' not found on the classpath.", clazz, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.xtend_lib_not_on_classpath", new String[0]);
        }
        if (this.getTypeRefs().findDeclaredType("org.eclipse.xtext.xbase.lib.ObjectExtensions", (Notifier)clazz) == null) {
            this.error("Mandatory library bundle 'org.eclipse.xtext.xbase.lib' not found on the classpath.", clazz, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.xbase_lib_not_on_classpath", new String[0]);
        }
        if (this.getTypeRefs().findDeclaredType(Inject.class.getName(), (Notifier)clazz) == null) {
            this.error("Mandatory library bundle 'com.google.inject' not found on the classpath.", clazz, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.xbase_lib_not_on_classpath", new String[0]);
        }
    }

    @Check
    public void checkWhitespaceInRichStrings(RichString richString) {
        Object container;
        if (richString.eContainer() instanceof RichStringIf && ((container = (RichStringIf)richString.eContainer()).getThen() == richString || container.getElse() == richString)) {
            return;
        }
        if (richString.eContainer() instanceof RichStringElseIf && (container = (RichStringElseIf)richString.eContainer()).getThen() == richString) {
            return;
        }
        if (richString.eContainer() instanceof RichStringForLoop && (container = (RichStringForLoop)richString.eContainer()).getEachExpression() == richString) {
            return;
        }
        this.doCheckWhitespaceIn(richString);
    }

    protected void doCheckWhitespaceIn(RichString richString) {
        ValidatingRichStringAcceptor helper = new ValidatingRichStringAcceptor((ValidationMessageAcceptor)this);
        this.richStringProcessor.process(richString, helper, helper);
    }

    @Check
    public void checkSuperTypes(XtendClass xtendClass) {
        JvmTypeReference superClass = xtendClass.getExtends();
        if (superClass != null && superClass.getType() != null) {
            if (!(superClass.getType() instanceof JvmGenericType) || ((JvmGenericType)superClass.getType()).isInterface()) {
                this.error("Superclass must be a class", (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__EXTENDS, "org.eclipse.xtext.xtend2.validation.IssueCodes.class_expected", new String[0]);
            } else if (((JvmGenericType)superClass.getType()).isFinal()) {
                this.error("Attempt to override final class", (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__EXTENDS, "org.eclipse.xtext.xtend2.validation.IssueCodes.overridden_final", new String[0]);
            }
        }
        int i = 0;
        while (i < xtendClass.getImplements().size()) {
            JvmTypeReference implementedType = (JvmTypeReference)xtendClass.getImplements().get(i);
            if (!(implementedType.getType() instanceof JvmGenericType) || !((JvmGenericType)implementedType.getType()).isInterface()) {
                this.error("Implemented interface must be an interface", (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__IMPLEMENTS, i, "org.eclipse.xtext.xtend2.validation.IssueCodes.interface_expected", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void checkDuplicateAndOverriddenFunctions(XtendClass xtendClass) {
        XtendFunction source;
        Pair<String, List<JvmType>> signature;
        JvmParameterizedTypeReference typeReference = this.getTypesFactory().createJvmParameterizedTypeReference();
        JvmGenericType inferredType = this.associations.getInferredType(xtendClass);
        typeReference.setType((JvmType)inferredType);
        final TypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getReceiverContext((JvmTypeReference)typeReference);
        HashMultimap operationsPerSignature = HashMultimap.create();
        for (JvmOperation operation : inferredType.getDeclaredOperations()) {
            signature = this.getSignature(operation);
            operationsPerSignature.put(signature, (Object)operation);
        }
        for (Collection operationsWithSameSignature : operationsPerSignature.asMap().values()) {
            if (operationsWithSameSignature.size() <= 1) continue;
            HashMultimap operationsPerReadableSignature = HashMultimap.create();
            for (JvmOperation operation : operationsWithSameSignature) {
                source = this.associations.getXtendFunction(operation);
                String readableSignature = this.getReadableSignature(source, (List<JvmFormalParameter>)operation.getParameters());
                operationsPerReadableSignature.put((Object)readableSignature, (Object)operation);
            }
            for (Collection operationsWithSameReadableSignature : operationsPerReadableSignature.asMap().values()) {
                XtendFunction otherSource;
                if (operationsWithSameReadableSignature.size() > 1) {
                    for (JvmOperation operation : operationsWithSameReadableSignature) {
                        otherSource = this.associations.getXtendFunction(operation);
                        this.error("Duplicate method " + this.getReadableSignature(otherSource, (List<JvmFormalParameter>)operation.getParameters()) + " in type " + inferredType.getSimpleName(), otherSource, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
                    }
                    continue;
                }
                for (JvmOperation operation : operationsWithSameReadableSignature) {
                    otherSource = this.associations.getXtendFunction(operation);
                    this.error("Method  " + this.getReadableSignature(otherSource, (List<JvmFormalParameter>)operation.getParameters()) + " has the same erasure " + this.getReadableErasure(otherSource, (List<JvmFormalParameter>)operation.getParameters()) + " as another method in type " + inferredType.getSimpleName(), otherSource, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
                }
            }
        }
        for (JvmOperation operation : Iterables.filter((Iterable)this.featureOverridesService.getAllJvmFeatures((JvmDeclaredType)inferredType, typeArgumentContext), JvmOperation.class)) {
            JvmOperation myOperation2;
            Collection myOperations;
            if (operation.getDeclaringType() == inferredType) continue;
            signature = this.getSignature(operation);
            if (operationsPerSignature.containsKey(signature) && (myOperations = operationsPerSignature.get(signature)).size() == 1 && !this.featureOverridesService.isOverridden((JvmFeature)(myOperation2 = (JvmOperation)Iterables.getOnlyElement((Iterable)myOperations)), (JvmFeature)operation, typeArgumentContext, false)) {
                source = this.associations.getXtendFunction(myOperation2);
                this.error("Name clash: The method " + this.getReadableSignature(source, (List<JvmFormalParameter>)myOperation2.getParameters()) + " of type " + inferredType.getSimpleName() + " has the same erasure as " + this.getReadableSignature(source, (List<JvmFormalParameter>)operation.getParameters()) + " of type " + operation.getDeclaringType().getSimpleName() + " but does not override it.", source, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
            }
            if (!operation.isAbstract() || inferredType.isAbstract()) continue;
            boolean overridden = false;
            if (operationsPerSignature.containsKey(signature)) {
                for (JvmOperation myOperation2 : operationsPerSignature.get(signature)) {
                    if (!this.featureOverridesService.isOverridden((JvmFeature)myOperation2, (JvmFeature)operation, typeArgumentContext, false)) continue;
                    overridden = true;
                    break;
                }
            }
            if (overridden) continue;
            this.error("The class " + inferredType.getSimpleName() + " must be defined abstract because it does not implement " + this.getReadableSignature(operation.getSimpleName(), Lists.transform((List)operation.getParameters(), (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

                public JvmTypeReference apply(JvmFormalParameter from) {
                    JvmTypeReference parameterType = from.getParameterType();
                    JvmTypeReference result = typeArgumentContext.resolve(parameterType);
                    return result;
                }
            })), xtendClass, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.class_must_be_defined_abstract", new String[0]);
        }
    }

    protected boolean isImplicitReturn(XExpression expr) {
        return (expr.eContainer() instanceof XtendFunction || expr.eContainer() instanceof XClosure) && !this.getEarlyExitComputer().isEarlyExit(expr);
    }

    @Check
    protected void checkFunctionOverride(XtendFunction function) {
        JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(function);
        if (overriddenOperation == null) {
            if (function.isOverride()) {
                this.error("Function does not override any function", function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__OVERRIDE, "org.eclipse.xtext.xtend2.validation.IssueCodes.obsolete_override", new String[0]);
            }
            return;
        }
        if (!function.isOverride()) {
            this.error("Missing 'override'. Function overrides " + this.canonicalName((JvmIdentifiableElement)overriddenOperation), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.missing_override", new String[0]);
        }
        if (overriddenOperation.isFinal()) {
            this.error("Attempt to override final method " + this.canonicalName((JvmIdentifiableElement)overriddenOperation), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.overridden_final", new String[0]);
        }
        if (function.getReturnType() == null) {
            return;
        }
        TypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getReceiverContext((JvmTypeReference)this.getTypeRefs().createTypeRef((JvmType)this.associations.getDirectlyInferredOperation(function).getDeclaringType(), new JvmTypeReference[0]));
        JvmTypeReference returnTypeUpperBound = typeArgumentContext.getUpperBound(overriddenOperation.getReturnType(), (Notifier)function);
        if (!this.isConformant(returnTypeUpperBound, function.getReturnType())) {
            this.error("The return type is incompatible with " + overriddenOperation.getIdentifier(), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__RETURN_TYPE, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
        }
    }

    protected Iterable<JvmOperation> allSuperOperations(XtendClass xtendClass) {
        Iterable result = Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.concat(Collections.singleton(xtendClass.getExtends()), xtendClass.getImplements()), (Predicate)Predicates.notNull()), (Function)new Function<JvmTypeReference, Iterable<JvmFeature>>(){

            public Iterable<JvmFeature> apply(JvmTypeReference from) {
                return Xtend2JavaValidator.this.featureOverridesService.getAllJvmFeatures(from);
            }
        })), JvmOperation.class);
        return result;
    }

    protected boolean isInterface(JvmDeclaredType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected String canonicalName(JvmIdentifiableElement element) {
        return element != null ? Strings.notNull((Object)element.getIdentifier()) : null;
    }

    protected Pair<String, List<JvmType>> getSignature(JvmOperation operation) {
        String name = operation.getSimpleName();
        ArrayList parameterTypes = Lists.newArrayListWithExpectedSize((int)operation.getParameters().size());
        for (JvmFormalParameter parameter : operation.getParameters()) {
            parameterTypes.add(parameter.getParameterType().getType());
        }
        return Tuples.create((Object)name, (Object)parameterTypes);
    }

    protected String getReadableSignature(JvmIdentifiableElement element, List<JvmFormalParameter> parameters) {
        if (element == null) {
            return "null";
        }
        return this.getReadableSignature(element.getSimpleName(), Lists.transform(parameters, (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

            public JvmTypeReference apply(JvmFormalParameter from) {
                return from.getParameterType();
            }
        }));
    }

    protected String getReadableSignature(String elementName, List<JvmTypeReference> parameters) {
        StringBuilder result = new StringBuilder(elementName);
        result.append('(');
        int i = 0;
        while (i < parameters.size()) {
            JvmTypeReference parameterType;
            if (i != 0) {
                result.append(", ");
            }
            if ((parameterType = parameters.get(i)) != null) {
                result.append(parameterType.getSimpleName());
            } else {
                result.append("null");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    protected String getReadableErasure(JvmIdentifiableElement element, List<JvmFormalParameter> parameters) {
        if (element == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder(element.getSimpleName());
        result.append('(');
        int i = 0;
        while (i < parameters.size()) {
            JvmTypeReference parameterType;
            if (i != 0) {
                result.append(", ");
            }
            if ((parameterType = parameters.get(i).getParameterType()) != null && parameterType.getType() != null) {
                result.append(parameterType.getType().getSimpleName());
            } else {
                result.append("null");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    @Check
    public void checkParameterNames(XtendFunction function) {
        int i = 0;
        while (i < function.getParameters().size()) {
            int j = i + 1;
            while (j < function.getParameters().size()) {
                if (Strings.equal((String)((XtendParameter)function.getParameters().get(i)).getName(), (String)((XtendParameter)function.getParameters().get(j)).getName())) {
                    this.error("Duplicate parameter name", (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__PARAMETERS, i, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                    this.error("Duplicate parameter name", (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__PARAMETERS, j, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void caseFuncWithoutParams(XtendFunction func) {
        if (func.isDispatch() && func.getParameters().isEmpty()) {
            this.error("A dispatch function mus at least have one parameter declared.", func, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__DISPATCH, "org.eclipse.xtext.xtend2.validation.IssueCodes.case_function_without_params", new String[0]);
        }
    }

    @Check
    public void caseFuncWithTypeParams(XtendFunction func) {
        if (func.isDispatch() && !func.getTypeParameters().isEmpty()) {
            this.error("A dispatch function must not declare any type parameters.", func, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__DISPATCH, "org.eclipse.xtext.xtend2.validation.IssueCodes.case_function_with_type_params", new String[0]);
        }
    }

    @Check
    public void checkCaseFunctions(XtendClass clazz) {
        JvmGenericType type = this.associations.getInferredType(clazz);
        Multimap<Pair<String, Integer>, JvmOperation> dispatchMethods = this.dispatchingSupport.getDispatchMethods(type);
        for (Pair key : dispatchMethods.keySet()) {
            Collection collection = dispatchMethods.get((Object)key);
            if (collection.size() == 1) {
                JvmOperation singleOp = (JvmOperation)collection.iterator().next();
                XtendFunction function = this.associations.getXtendFunction(singleOp);
                this.warning("Single dispatch function.", function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__DISPATCH, "org.eclipse.xtext.xtend2.validation.IssueCodes.single_case_function", new String[0]);
                continue;
            }
            HashMultimap signatures = HashMultimap.create();
            for (JvmOperation jvmOperation : collection) {
                JvmTypeReference functionReturnType;
                signatures.put(this.getParamTypes(jvmOperation, true), (Object)jvmOperation);
                XtendFunction function = this.associations.getXtendFunction(jvmOperation);
                if (function == null || (functionReturnType = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)function)) == null || this.isConformant(jvmOperation.getReturnType(), functionReturnType)) continue;
                this.error("Incompatible return type of dispatch method. Expected " + this.getNameOfTypes(jvmOperation.getReturnType()) + " but was " + this.canonicalName(functionReturnType), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__RETURN_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
            }
            for (final List paramTypes : signatures.keySet()) {
                Collection ops = signatures.get((Object)paramTypes);
                if (ops.size() <= 1 || !Iterables.any((Iterable)ops, (Predicate)new Predicate<JvmOperation>(){

                    public boolean apply(JvmOperation input) {
                        return !Xtend2JavaValidator.this.getParamTypes(input, false).equals(paramTypes);
                    }
                })) continue;
                for (JvmOperation jvmOperation : ops) {
                    XtendFunction function = this.associations.getXtendFunction(jvmOperation);
                    this.error("Duplicate dispatch function. Primitives cannot overload their wrapper types in dispatch functions.", function, null, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
                }
            }
        }
    }

    protected List<JvmType> getParamTypes(JvmOperation jvmOperation, boolean wrapPrimitives) {
        ArrayList types = Lists.newArrayList();
        for (JvmFormalParameter p : jvmOperation.getParameters()) {
            JvmTypeReference reference = wrapPrimitives ? this.primitives.asWrapperTypeIfPrimitive(p.getParameterType()) : p.getParameterType();
            types.add(reference.getType());
        }
        return types;
    }

    @Check
    public void checkNoReturnsInCreateExtensions(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        ArrayList found = Lists.newArrayList();
        this.collectReturnExpressions((EObject)func.getCreateExtensionInfo().getCreateExpression(), found);
        for (XReturnExpression xReturnExpression : found) {
            this.error("Return is not allowed in creation expression", (EObject)xReturnExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
        }
        found.clear();
        this.collectReturnExpressions((EObject)func.getExpression(), found);
        for (XReturnExpression ret : found) {
            if (ret.getExpression() == null) continue;
            this.error("Return with expression is not allowed within an initializer of a create function.", (EObject)ret, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
        }
    }

    @Check
    public void checkCreateFunctionIsNotTypeVoid(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        JvmTypeReference declaredType = func.getReturnType();
        if (declaredType == null) {
            declaredType = this.overridesService.getOverriddenReturnType(func);
        }
        if (declaredType == null) {
            JvmTypeReference inferredType = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)func.getCreateExtensionInfo());
            if (this.getTypeRefs().is(inferredType, Void.TYPE)) {
                this.error("void is an invalid type for the create function " + func.getName(), func, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        } else if (this.getTypeRefs().is(declaredType, Void.TYPE)) {
            if (func.getReturnType() != null) {
                this.error("Create function " + func.getName() + " may not declare return type void.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error("The inherited return type void of " + func.getName() + " is invalid for create functions.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    public void checkInnerExpressions(XBlockExpression block) {
        if (block instanceof RichString) {
            return;
        }
        super.checkInnerExpressions(block);
    }

    protected void collectReturnExpressions(EObject expr, List<XReturnExpression> found) {
        if (expr instanceof XReturnExpression) {
            found.add((XReturnExpression)expr);
        } else if (expr instanceof XClosure) {
            return;
        }
        for (EObject child : expr.eContents()) {
            this.collectReturnExpressions(child, found);
        }
    }
}

