/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.controlflow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEarlyExitComputer
implements IEarlyExitComputer {
    private PolymorphicDispatcher<Collection<IEarlyExitComputer.ExitPoint>> dispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_exitPoints", (Object)this);

    @Override
    public boolean isEarlyExit(XExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression);
        return this.isNotEmpty(exitPoints);
    }

    protected boolean isNotEmpty(Collection<IEarlyExitComputer.ExitPoint> exitPoints) {
        return exitPoints != null && !exitPoints.isEmpty();
    }

    @Override
    public Collection<IEarlyExitComputer.ExitPoint> getExitPoints(XExpression expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        return (Collection)this.dispatcher.invoke(new Object[]{expression});
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XExpression expression) {
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XReturnExpression expression) {
        return Collections.singletonList(new IEarlyExitComputer.ExitPoint(expression, false));
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XThrowExpression expression) {
        return Collections.singletonList(new IEarlyExitComputer.ExitPoint(expression, true));
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XBlockExpression expression) {
        for (XExpression child : expression.getExpressions()) {
            Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(child);
            if (!this.isNotEmpty(exitPoints)) continue;
            return exitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XForLoopExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression.getForExpression());
        if (this.isNotEmpty(exitPoints)) {
            return exitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XWhileExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression.getPredicate());
        if (this.isNotEmpty(exitPoints)) {
            return exitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XDoWhileExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> exitPoints = this.getExitPoints(expression.getBody());
        if (this.isNotEmpty(exitPoints)) {
            return exitPoints;
        }
        return this.getExitPoints(expression.getPredicate());
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XVariableDeclaration expression) {
        return this.getExitPoints(expression.getRight());
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XIfExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> ifExitPoints = this.getExitPoints(expression.getIf());
        if (this.isNotEmpty(ifExitPoints)) {
            return ifExitPoints;
        }
        Collection<IEarlyExitComputer.ExitPoint> thenExitPoints = this.getExitPoints(expression.getThen());
        Collection<IEarlyExitComputer.ExitPoint> elseExitPoints = this.getExitPoints(expression.getElse());
        if (this.isNotEmpty(thenExitPoints) && this.isNotEmpty(elseExitPoints)) {
            ArrayList result = Lists.newArrayList(thenExitPoints);
            result.addAll(elseExitPoints);
            return result;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XSwitchExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> switchExitPoints = this.getExitPoints(expression.getSwitch());
        if (this.isNotEmpty(switchExitPoints)) {
            return switchExitPoints;
        }
        ArrayList result = Lists.newArrayList();
        for (XCasePart casePart : expression.getCases()) {
            Collection<IEarlyExitComputer.ExitPoint> caseExit = this.getExitPoints(casePart.getThen());
            if (!this.isNotEmpty(caseExit)) {
                return Collections.emptyList();
            }
            result.addAll(caseExit);
        }
        Collection<IEarlyExitComputer.ExitPoint> defaultExit = this.getExitPoints(expression.getDefault());
        if (!this.isNotEmpty(defaultExit)) {
            return Collections.emptyList();
        }
        result.addAll(defaultExit);
        return result;
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XAbstractFeatureCall expression) {
        for (XExpression argument : expression.getExplicitArguments()) {
            Collection<IEarlyExitComputer.ExitPoint> argumentExitPoints = this.getExitPoints(argument);
            if (!this.isNotEmpty(argumentExitPoints)) continue;
            return argumentExitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XConstructorCall expression) {
        for (XExpression argument : expression.getArguments()) {
            Collection<IEarlyExitComputer.ExitPoint> argumentExitPoints = this.getExitPoints(argument);
            if (!this.isNotEmpty(argumentExitPoints)) continue;
            return argumentExitPoints;
        }
        return Collections.emptyList();
    }

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XTryCatchFinallyExpression expression) {
        Collection<IEarlyExitComputer.ExitPoint> tryExitPoints = this.getExitPoints(expression.getExpression());
        if (this.isNotEmpty(tryExitPoints)) {
            ArrayList result = Lists.newArrayList(tryExitPoints);
            for (XCatchClause catchClause : expression.getCatchClauses()) {
                Collection<IEarlyExitComputer.ExitPoint> catchExitPoints = this.getExitPoints(catchClause.getExpression());
                if (this.isNotEmpty(catchExitPoints)) {
                    result.addAll(catchExitPoints);
                    continue;
                }
                Collection<IEarlyExitComputer.ExitPoint> finallyExitPoints = this.getExitPoints(expression.getFinallyExpression());
                return finallyExitPoints;
            }
            return result;
        }
        Collection<IEarlyExitComputer.ExitPoint> finallyExitPoints = this.getExitPoints(expression.getFinallyExpression());
        return finallyExitPoints;
    }
}

