/*
* generated by Xtext
*/
grammar DebugInternalXbase ;

// Rule XExpression
ruleXExpression :
	ruleXAssignment
;

// Rule XAssignment
ruleXAssignment :
	ruleFeatureCallID ruleOpSingleAssign ruleXAssignment |
	ruleXOrExpression (
		( (
		ruleOpMultiAssign
		) => ruleOpMultiAssign ) ruleXAssignment
	)?
;

// Rule OpSingleAssign
ruleOpSingleAssign :
	'='
;

// Rule OpMultiAssign
ruleOpMultiAssign :
	'+=' |
	'-='
;

// Rule XOrExpression
ruleXOrExpression :
	ruleXAndExpression (
		( (
		ruleOpOr
		) => ruleOpOr ) ruleXAndExpression
	)*
;

// Rule OpOr
ruleOpOr :
	'||'
;

// Rule XAndExpression
ruleXAndExpression :
	ruleXEqualityExpression (
		( (
		ruleOpAnd
		) => ruleOpAnd ) ruleXEqualityExpression
	)*
;

// Rule OpAnd
ruleOpAnd :
	'&&'
;

// Rule XEqualityExpression
ruleXEqualityExpression :
	ruleXRelationalExpression (
		( (
		ruleOpEquality
		) => ruleOpEquality ) ruleXRelationalExpression
	)*
;

// Rule OpEquality
ruleOpEquality :
	'==' |
	'!=' |
	'===' |
	'!=='
;

// Rule XRelationalExpression
ruleXRelationalExpression :
	ruleXOtherOperatorExpression (
		( (
		'instanceof'
		) => 'instanceof' ) ruleJvmTypeReference |
		( (
		ruleOpCompare
		) => ruleOpCompare ) ruleXOtherOperatorExpression
	)*
;

// Rule OpCompare
ruleOpCompare :
	'>=' |
	'<=' |
	'>' |
	'<'
;

// Rule XOtherOperatorExpression
ruleXOtherOperatorExpression :
	ruleXAdditiveExpression (
		( (
		ruleOpOther
		) => ruleOpOther ) ruleXAdditiveExpression
	)*
;

// Rule OpOther
ruleOpOther :
	'->' |
	'..<' |
	'>' '..' |
	'..' |
	'=>' |
	'>' (
		( (
		'>' '>'
		) => (
			'>' '>'
		) ) |
		'>'
	) |
	'<' (
		( (
		'<' '<'
		) => (
			'<' '<'
		) ) |
		'<'
	) |
	'<>' |
	'?:' |
	'<=>'
;

// Rule XAdditiveExpression
ruleXAdditiveExpression :
	ruleXMultiplicativeExpression (
		( (
		ruleOpAdd
		) => ruleOpAdd ) ruleXMultiplicativeExpression
	)*
;

// Rule OpAdd
ruleOpAdd :
	'+' |
	'-'
;

// Rule XMultiplicativeExpression
ruleXMultiplicativeExpression :
	ruleXUnaryOperation (
		( (
		ruleOpMulti
		) => ruleOpMulti ) ruleXUnaryOperation
	)*
;

// Rule OpMulti
ruleOpMulti :
	'*' |
	'**' |
	'/' |
	'%'
;

// Rule XUnaryOperation
ruleXUnaryOperation :
	ruleOpUnary ruleXUnaryOperation |
	ruleXCastedExpression
;

// Rule OpUnary
ruleOpUnary :
	'!' |
	'-' |
	'+'
;

// Rule XCastedExpression
ruleXCastedExpression :
	ruleXMemberFeatureCall (
		( (
		'as'
		) => 'as' ) ruleJvmTypeReference
	)*
;

// Rule XMemberFeatureCall
ruleXMemberFeatureCall :
	ruleXPrimaryExpression (
		( (
		'.' ruleFeatureCallID ruleOpSingleAssign
		) => (
			'.' ruleFeatureCallID ruleOpSingleAssign
		) ) ruleXAssignment |
		( (
		'.' |
		'?.' |
		'*.'
		) => (
			'.' |
			'?.' |
			'*.'
		) ) (
			'<' ruleJvmArgumentTypeReference (
				',' ruleJvmArgumentTypeReference
			)* '>'
		)? ruleFeatureCallID (
			( (
			'('
			) => '(' ) (
				( (
				(
					ruleJvmFormalParameter (
						',' ruleJvmFormalParameter
					)*
				)? '|'
				) => ruleXShortClosure ) |
				ruleXExpression (
					',' ruleXExpression
				)*
			)? ')'
		)? ( (
		'['
		) => ruleXClosure )?
	)*
;

// Rule XPrimaryExpression
ruleXPrimaryExpression :
	ruleXConstructorCall |
	ruleXBlockExpression |
	ruleXSwitchExpression |
	ruleXFeatureCall |
	ruleXLiteral |
	ruleXIfExpression |
	ruleXForLoopExpression |
	ruleXWhileExpression |
	ruleXDoWhileExpression |
	ruleXThrowExpression |
	ruleXReturnExpression |
	ruleXTryCatchFinallyExpression |
	ruleXParenthesizedExpression
;

// Rule XLiteral
ruleXLiteral :
	ruleXCollectionLiteral |
	( (
	'['
	) => ruleXClosure ) |
	ruleXBooleanLiteral |
	ruleXNumberLiteral |
	ruleXNullLiteral |
	ruleXStringLiteral |
	ruleXTypeLiteral
;

// Rule XCollectionLiteral
ruleXCollectionLiteral :
	ruleXSetLiteral |
	ruleXListLiteral
;

// Rule XSetLiteral
ruleXSetLiteral :
	'#' '{' (
		ruleXExpression (
			',' ruleXExpression
		)*
	)? '}'
;

// Rule XListLiteral
ruleXListLiteral :
	'#' '[' (
		ruleXExpression (
			',' ruleXExpression
		)*
	)? ']'
;

// Rule XClosure
ruleXClosure :
	( (
	'['
	) => '[' ) ( (
	(
		ruleJvmFormalParameter (
			',' ruleJvmFormalParameter
		)*
	)? '|'
	) => (
		(
			ruleJvmFormalParameter (
				',' ruleJvmFormalParameter
			)*
		)? '|'
	) )? ruleXExpressionInClosure ']'
;

// Rule XExpressionInClosure
ruleXExpressionInClosure :
	(
		ruleXExpressionInsideBlock ';'?
	)*
;

// Rule XShortClosure
ruleXShortClosure :
	( (
	(
		ruleJvmFormalParameter (
			',' ruleJvmFormalParameter
		)*
	)? '|'
	) => (
		(
			ruleJvmFormalParameter (
				',' ruleJvmFormalParameter
			)*
		)? '|'
	) ) ruleXExpression
;

// Rule XParenthesizedExpression
ruleXParenthesizedExpression :
	'(' ruleXExpression ')'
;

// Rule XIfExpression
ruleXIfExpression :
	'if' '(' ruleXExpression ')' ruleXExpression (
		( (
		'else'
		) => 'else' ) ruleXExpression
	)?
;

// Rule XSwitchExpression
ruleXSwitchExpression :
	'switch' (
		( (
		ruleValidID ':'
		) => (
			ruleValidID ':'
		) )? ruleXExpression |
		( (
		'(' ruleValidID ':'
		) => (
			'(' ruleValidID ':'
		) ) ruleXExpression ')'
	) '{' ruleXCasePart+ (
		'default' ':' ruleXExpression
	)? '}'
;

// Rule XCasePart
ruleXCasePart :
	ruleJvmTypeReference? (
		'case' ruleXExpression
	)? ':' ruleXExpression
;

// Rule XForLoopExpression
ruleXForLoopExpression :
	'for' '(' ruleJvmFormalParameter ':' ruleXExpression ')' ruleXExpression
;

// Rule XWhileExpression
ruleXWhileExpression :
	'while' '(' ruleXExpression ')' ruleXExpression
;

// Rule XDoWhileExpression
ruleXDoWhileExpression :
	'do' ruleXExpression 'while' '(' ruleXExpression ')'
;

// Rule XBlockExpression
ruleXBlockExpression :
	'{' (
		ruleXExpressionInsideBlock ';'?
	)* '}'
;

// Rule XExpressionInsideBlock
ruleXExpressionInsideBlock :
	ruleXVariableDeclaration |
	ruleXExpression
;

// Rule XVariableDeclaration
ruleXVariableDeclaration :
	(
		'var' |
		'val'
	) (
		( (
		ruleJvmTypeReference ruleValidID
		) => (
			ruleJvmTypeReference ruleValidID
		) ) |
		ruleValidID
	) (
		'=' ruleXExpression
	)?
;

// Rule JvmFormalParameter
ruleJvmFormalParameter :
	ruleJvmTypeReference? ruleValidID
;

// Rule FullJvmFormalParameter
ruleFullJvmFormalParameter :
	ruleJvmTypeReference ruleValidID
;

// Rule XFeatureCall
ruleXFeatureCall :
	ruleStaticQualifier? (
		'<' ruleJvmArgumentTypeReference (
			',' ruleJvmArgumentTypeReference
		)* '>'
	)? ruleIdOrSuper (
		( (
		'('
		) => '(' ) (
			( (
			(
				ruleJvmFormalParameter (
					',' ruleJvmFormalParameter
				)*
			)? '|'
			) => ruleXShortClosure ) |
			ruleXExpression (
				',' ruleXExpression
			)*
		)? ')'
	)? ( (
	'['
	) => ruleXClosure )?
;

// Rule FeatureCallID
ruleFeatureCallID :
	ruleValidID |
	'extends' |
	'static' |
	'import' |
	'extension'
;

// Rule IdOrSuper
ruleIdOrSuper :
	ruleFeatureCallID |
	'super'
;

// Rule StaticQualifier
ruleStaticQualifier :
	(
		ruleValidID '::'
	)+
;

// Rule XConstructorCall
ruleXConstructorCall :
	'new' ruleQualifiedName (
		( (
		'<'
		) => '<' ) ruleJvmArgumentTypeReference (
			',' ruleJvmArgumentTypeReference
		)* '>'
	)? (
		( (
		'('
		) => '(' ) (
			( (
			(
				ruleJvmFormalParameter (
					',' ruleJvmFormalParameter
				)*
			)? '|'
			) => ruleXShortClosure ) |
			ruleXExpression (
				',' ruleXExpression
			)*
		)? ')'
	)? ( (
	'['
	) => ruleXClosure )?
;

// Rule XBooleanLiteral
ruleXBooleanLiteral :
	'false' |
	'true'
;

// Rule XNullLiteral
ruleXNullLiteral :
	'null'
;

// Rule XNumberLiteral
ruleXNumberLiteral :
	ruleNumber
;

// Rule XStringLiteral
ruleXStringLiteral :
	RULE_STRING
;

// Rule XTypeLiteral
ruleXTypeLiteral :
	'typeof' '(' ruleQualifiedName ruleArrayBrackets* ')'
;

// Rule XThrowExpression
ruleXThrowExpression :
	'throw' ruleXExpression
;

// Rule XReturnExpression
ruleXReturnExpression :
	'return' ( (
	ruleXExpression
	) => ruleXExpression )?
;

// Rule XTryCatchFinallyExpression
ruleXTryCatchFinallyExpression :
	'try' ruleXExpression (
		( (
		'catch'
		) => ruleXCatchClause )+ (
			( (
			'finally'
			) => 'finally' ) ruleXExpression
		)? |
		'finally' ruleXExpression
	)
;

// Rule XCatchClause
ruleXCatchClause :
	( (
	'catch'
	) => 'catch' ) '(' ruleFullJvmFormalParameter ')' ruleXExpression
;

// Rule QualifiedName
ruleQualifiedName :
	ruleValidID (
		( (
		'.'
		) => '.' ) ruleValidID
	)*
;

// Rule Number
ruleNumber :
	RULE_HEX |
	(
		RULE_INT |
		RULE_DECIMAL
	) (
		'.' (
			RULE_INT |
			RULE_DECIMAL
		)
	)?
;

// Rule JvmTypeReference
ruleJvmTypeReference :
	ruleJvmParameterizedTypeReference ( (
	ruleArrayBrackets
	) => ruleArrayBrackets )* |
	ruleXFunctionTypeRef
;

// Rule ArrayBrackets
ruleArrayBrackets :
	'[' ']'
;

// Rule XFunctionTypeRef
ruleXFunctionTypeRef :
	(
		'(' (
			ruleJvmTypeReference (
				',' ruleJvmTypeReference
			)*
		)? ')'
	)? '=>' ruleJvmTypeReference
;

// Rule JvmParameterizedTypeReference
ruleJvmParameterizedTypeReference :
	ruleQualifiedName (
		( (
		'<'
		) => '<' ) ruleJvmArgumentTypeReference (
			',' ruleJvmArgumentTypeReference
		)* '>'
	)?
;

// Rule JvmArgumentTypeReference
ruleJvmArgumentTypeReference :
	ruleJvmTypeReference |
	ruleJvmWildcardTypeReference
;

// Rule JvmWildcardTypeReference
ruleJvmWildcardTypeReference :
	'?' (
		ruleJvmUpperBound |
		ruleJvmLowerBound
	)?
;

// Rule JvmUpperBound
ruleJvmUpperBound :
	'extends' ruleJvmTypeReference
;

// Rule JvmUpperBoundAnded
ruleJvmUpperBoundAnded :
	'&' ruleJvmTypeReference
;

// Rule JvmLowerBound
ruleJvmLowerBound :
	'super' ruleJvmTypeReference
;

// Rule QualifiedNameWithWildcard
ruleQualifiedNameWithWildcard :
	ruleQualifiedName '.' '*'
;

// Rule ValidID
ruleValidID :
	RULE_ID
;

// Rule XImportDeclaration
ruleXImportDeclaration :
	'import' (
		'static' 'extension'? ruleQualifiedName '.' '*' |
		ruleQualifiedName |
		ruleQualifiedNameWithWildcard
	) ';'?
;

RULE_HEX :
	(
		'0x' |
		'0X'
	) (
		'0' .. '9' |
		'a' .. 'f' |
		'A' .. 'F' |
		'_'
	)+ (
		'#' (
			(
				'b' |
				'B'
			) (
				'i' |
				'I'
			) |
			(
				'l' |
				'L'
			)
		)
	)?
;

RULE_INT :
	'0' .. '9' (
		'0' .. '9' |
		'_'
	)*
;

RULE_DECIMAL :
	RULE_INT (
		(
			'e' |
			'E'
		) (
			'+' |
			'-'
		)? RULE_INT
	)? (
		(
			'b' |
			'B'
		) (
			'i' |
			'I' |
			'd' |
			'D'
		) |
		(
			'l' |
			'L' |
			'd' |
			'D' |
			'f' |
			'F'
		)
	)?
;

RULE_ID :
	'^'? (
		'a' .. 'z' |
		'A' .. 'Z' |
		'$' |
		'_'
	) (
		'a' .. 'z' |
		'A' .. 'Z' |
		'$' |
		'_' |
		'0' .. '9'
	)*
;

RULE_STRING :
	'"' (
		'\\' (
			'b' |
			't' |
			'n' |
			'f' |
			'r' |
			'u' |
			'"' |
			'\'' |
			'\\'
		) |
		~ (
			'\\' |
			'"'
		)
	)* '"' |
	'\'' (
		'\\' (
			'b' |
			't' |
			'n' |
			'f' |
			'r' |
			'u' |
			'"' |
			'\'' |
			'\\'
		) |
		~ (
			'\\' |
			'\''
		)
	)* '\''
;

RULE_ML_COMMENT :
	'/*' (
		options { greedy = false ; } : .
	)* '*/' {skip();}
;

RULE_SL_COMMENT :
	'//' ~ (
		'\n' |
		'\r'
	)* (
		'\r'? '\n'
	)? {skip();}
;

RULE_WS :
	(
		' ' |
		'\t' |
		'\r' |
		'\n'
	)+ {skip();}
;

RULE_ANY_OTHER :
	.
;