/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmModelCompleter {
    @Inject
    private TypeReferences references;
    @Inject
    private TypesFactory typesFactory;
    @Inject
    private JvmTypeExtensions typeExtensions;

    public void complete(Iterable<? extends JvmIdentifiableElement> elements) {
        for (JvmIdentifiableElement jvmIdentifiableElement : elements) {
            this.complete(jvmIdentifiableElement);
        }
    }

    public void complete(JvmIdentifiableElement element) {
        if (element instanceof JvmGenericType) {
            this.completeJvmGenericType((JvmGenericType)element);
        }
        if (element instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)element;
            this.complete((Iterable<? extends JvmIdentifiableElement>)declaredType.getMembers());
        }
        if (element instanceof JvmConstructor) {
            this.completeJvmConstructor((JvmConstructor)element);
        }
        if (element instanceof JvmEnumerationType) {
            this.completeJvmEnumerationType((JvmEnumerationType)element);
        }
        if (element instanceof JvmEnumerationLiteral) {
            this.completeJvmEnumerationLiteral((JvmEnumerationLiteral)element);
        }
        if (element instanceof JvmAnnotationType) {
            this.completeJvmAnnotationType((JvmAnnotationType)element);
        }
    }

    protected void completeJvmEnumerationType(JvmEnumerationType element) {
        JvmTypeReference objectType;
        if (element.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Enum.class, (Notifier)element, new JvmTypeReference[]{this.references.createTypeRef((JvmType)element, new JvmTypeReference[0])})) != null) {
            element.getSuperTypes().add((Object)objectType);
        }
        JvmOperation values = this.typesFactory.createJvmOperation();
        values.setVisibility(JvmVisibility.PUBLIC);
        values.setStatic(true);
        values.setSimpleName("values");
        values.setReturnType((JvmTypeReference)this.references.createArrayType((JvmTypeReference)this.references.createTypeRef((JvmType)element, new JvmTypeReference[0])));
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)values, true);
        element.getMembers().add((Object)values);
        JvmOperation valueOf = this.typesFactory.createJvmOperation();
        valueOf.setVisibility(JvmVisibility.PUBLIC);
        valueOf.setStatic(true);
        valueOf.setSimpleName("valueOf");
        valueOf.setReturnType((JvmTypeReference)this.references.createTypeRef((JvmType)element, new JvmTypeReference[0]));
        JvmFormalParameter param = this.typesFactory.createJvmFormalParameter();
        param.setName("name");
        param.setParameterType(this.references.getTypeForName(String.class, (Notifier)element, new JvmTypeReference[0]));
        valueOf.getParameters().add((Object)param);
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)valueOf, true);
        element.getMembers().add((Object)valueOf);
    }

    protected void completeJvmEnumerationLiteral(JvmEnumerationLiteral element) {
        if (element.getType() == null) {
            element.setType((JvmTypeReference)this.references.createTypeRef((JvmType)element.getDeclaringType(), new JvmTypeReference[0]));
        }
        element.setStatic(true);
    }

    protected void completeJvmAnnotationType(JvmAnnotationType element) {
        JvmTypeReference objectType;
        if (element.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Annotation.class, (Notifier)element, new JvmTypeReference[0])) != null) {
            element.getSuperTypes().add((Object)objectType);
        }
    }

    public void completeJvmConstructor(JvmConstructor constructor) {
        String simpleName;
        JvmDeclaredType declaringType = constructor.getDeclaringType();
        if (declaringType != null && (simpleName = declaringType.getSimpleName()) != null) {
            constructor.setSimpleName(simpleName);
            return;
        }
        constructor.setSimpleName("unset");
    }

    protected void completeJvmGenericType(JvmGenericType element) {
        this.ensureSuperTypeObject((JvmDeclaredType)element);
        if (!element.isInterface() && Iterables.isEmpty((Iterable)element.getDeclaredConstructors())) {
            JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
            constructor.setSimpleName(element.getSimpleName());
            constructor.setVisibility(JvmVisibility.PUBLIC);
            element.getMembers().add((Object)constructor);
        }
    }

    protected void ensureSuperTypeObject(JvmDeclaredType element) {
        JvmTypeReference objectType;
        if (element.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Object.class, (Notifier)element, new JvmTypeReference[0])) != null) {
            element.getSuperTypes().add((Object)objectType);
        }
    }
}

