/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.markers.IMarkerContributor;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.validation.IResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.MarkerEraser;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.CheckMode;

public class MarkerUpdaterImpl
implements IMarkerUpdater {
    public static final Logger LOG = Logger.getLogger(MarkerUpdaterImpl.class);
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IStorage2UriMapper mapper;

    public void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.processDelta(delta, resourceSet, monitor);
    }

    private void processDelta(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) throws OperationCanceledException {
        URI uri = delta.getUri();
        IResourceUIValidatorExtension validatorExtension = this.getResourceUIValidatorExtension(uri);
        IMarkerContributor markerContributor = this.getMarkerContributor(uri);
        CheckMode normalAndFastMode = CheckMode.NORMAL_AND_FAST;
        for (Pair pair : this.mapper.getStorages(uri)) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!(pair.getFirst() instanceof IFile)) continue;
            IFile file = (IFile)pair.getFirst();
            if (delta.getNew() != null) {
                if (resourceSet == null) {
                    throw new IllegalArgumentException("resourceSet may not be null for changed resources.");
                }
                Resource resource = resourceSet.getResource(uri, true);
                if (validatorExtension != null) {
                    validatorExtension.updateValidationMarkers(file, resource, normalAndFastMode, monitor);
                }
                if (markerContributor == null) continue;
                markerContributor.updateMarkers(file, resource, monitor);
                continue;
            }
            if (validatorExtension != null) {
                validatorExtension.deleteValidationMarkers(file, normalAndFastMode, monitor);
            } else {
                this.deleteAllValidationMarker(file, normalAndFastMode, monitor);
            }
            if (markerContributor != null) {
                markerContributor.deleteMarkers(file, monitor);
                continue;
            }
            this.deleteAllContributedMarkers(file, monitor);
        }
    }

    private void deleteAllValidationMarker(IFile file, CheckMode checkMode, IProgressMonitor monitor) {
        MarkerEraser markerEraser = new MarkerEraser();
        markerEraser.deleteValidationMarkers(file, checkMode, monitor);
    }

    private void deleteAllContributedMarkers(IFile file, IProgressMonitor monitor) {
        try {
            file.deleteMarkers("org.eclipse.xtext.ui.marker", true, 0);
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IResourceUIValidatorExtension getResourceUIValidatorExtension(URI uri) {
        IResourceServiceProvider provider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        if (provider != null) {
            return (IResourceUIValidatorExtension)provider.get(IResourceUIValidatorExtension.class);
        }
        return null;
    }

    protected IMarkerContributor getMarkerContributor(URI uri) {
        IResourceServiceProvider provider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        if (provider != null) {
            return (IMarkerContributor)provider.get(IMarkerContributor.class);
        }
        return null;
    }
}

