/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.builder.smap.XbaseBreakpointUtil;
import org.eclipse.xtext.builder.smap.XbaseLineBreakpoint;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.debug.IStratumBreakpointSupport;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.JarFileMarkerAnnotationModel;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StratumBreakpointAdapterFactory
implements IAdapterFactory,
IToggleBreakpointsTargetExtension {
    private static final Logger log = Logger.getLogger(StratumBreakpointAdapterFactory.class);
    private static final String ORG_ECLIPSE_JDT_DEBUG_CORE_SOURCE_NAME = "org.eclipse.jdt.debug.core.sourceName";
    public static final String ORG_ECLIPSE_XTEXT_XBASE_SOURCE_URI = "org.eclipse.xtext.xbase.source.uri";
    public static final String ORG_ECLIPSE_XTEXT_XBASE_CLASS_HANDLE = "org.eclipse.xtext.xbase.class.handle";
    @Inject
    private IResourceServiceProvider.Registry providerRegistry;
    @Inject
    private IStorage2UriMapper uriMapper;
    @Inject
    private XbaseBreakpointUtil breakpointUtil;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof XtextEditor) {
            return this;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IToggleBreakpointsTargetExtension.class};
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (!(part instanceof XtextEditor) || !(selection instanceof ITextSelection)) {
            return;
        }
        try {
            XtextEditor xtextEditor = (XtextEditor)part;
            final IEditorInput editorInput = xtextEditor.getEditorInput();
            IResource breakpointResource = this.breakpointUtil.getBreakpointResource(editorInput);
            URI breakpointUri = this.breakpointUtil.getBreakpointURI(editorInput);
            int offset = ((TextSelection)selection).getOffset();
            final int line = xtextEditor.getDocument().getLineOfOffset(offset) + 1;
            Data data = (Data)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Data, XtextResource>(){

                public Data exec(XtextResource state) throws Exception {
                    IResourceServiceProvider provider = state.getResourceServiceProvider();
                    IStratumBreakpointSupport breakpointSupport = (IStratumBreakpointSupport)provider.get(IStratumBreakpointSupport.class);
                    Data result = new Data();
                    result.name = state.getURI().lastSegment();
                    result.valid = breakpointSupport != null && breakpointSupport.isValidLineForBreakPoint(state, line);
                    result.types = StratumBreakpointAdapterFactory.this.getClassNamePattern(state);
                    result.lang = (LanguageInfo)provider.get(LanguageInfo.class);
                    result.sourceUri = state.getURI();
                    if (editorInput instanceof IClassFileEditorInput) {
                        IClassFile classFile = ((IClassFileEditorInput)editorInput).getClassFile();
                        result.classHandle = classFile.getHandleIdentifier();
                    }
                    return result;
                }
            });
            IJavaStratumLineBreakpoint existingBreakpoint = this.findExistingBreakpoint(breakpointResource, breakpointUri, line);
            if (existingBreakpoint != null) {
                existingBreakpoint.delete();
                return;
            }
            if (!data.valid || data.types == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Types the breakpoint listens for : " + data.types));
            }
            IRegion information = xtextEditor.getDocument().getLineInformation(line - 1);
            int charStart = information.getOffset();
            int charEnd = information.getOffset() + information.getLength();
            String shortName = data.lang.getShortName();
            HashMap attributes = Maps.newHashMap();
            if (breakpointUri != null) {
                attributes.put(JarFileMarkerAnnotationModel.MARKER_URI, breakpointUri.toString());
            }
            attributes.put(ORG_ECLIPSE_JDT_DEBUG_CORE_SOURCE_NAME, data.name);
            attributes.put(ORG_ECLIPSE_XTEXT_XBASE_SOURCE_URI, data.sourceUri.toString());
            if (data.classHandle != null) {
                attributes.put(ORG_ECLIPSE_XTEXT_XBASE_CLASS_HANDLE, data.classHandle);
            }
            XbaseLineBreakpoint breakpoint = new XbaseLineBreakpoint(breakpointResource, shortName, data.types, line, charStart, charEnd, attributes);
            final IMarker marker = breakpoint.getMarker();
            final IWorkspace ws = marker.getResource().getWorkspace();
            IResourceChangeListener listener = new IResourceChangeListener((IJavaStratumLineBreakpoint)breakpoint){
                private final /* synthetic */ IJavaStratumLineBreakpoint val$breakpoint;
                {
                    this.val$breakpoint = iJavaStratumLineBreakpoint;
                }

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta;
                    if (!marker.exists()) {
                        ws.removeResourceChangeListener((IResourceChangeListener)this);
                    }
                    if ((delta = event.getDelta()) == null) {
                        return;
                    }
                    IResourceDelta findMember = event.getDelta().findMember(marker.getResource().getFullPath());
                    if (findMember == null) {
                        return;
                    }
                    IResource res = findMember.getResource();
                    if (res == null || !res.exists()) {
                        return;
                    }
                    if (event.getType() == 4) {
                        ws.removeResourceChangeListener((IResourceChangeListener)this);
                    } else if (event.getType() == 1 && (findMember.getFlags() & 0x100) != 0) {
                        String classNamePattern = StratumBreakpointAdapterFactory.this.getClassNamePattern(event.getResource());
                        try {
                            this.val$breakpoint.getMarker().setAttribute("org.eclipse.jdt.debug.pattern", (Object)classNamePattern);
                        }
                        catch (CoreException e) {
                            log.info((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            ws.addResourceChangeListener(listener, 5);
        }
        catch (BadLocationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IJavaStratumLineBreakpoint findExistingBreakpoint(IResource res, URI uri, int line) throws CoreException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints();
        if (uri == null) {
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaStratumLineBreakpoint stratumBreakpoint;
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IMarker marker = breakpoint.getMarker();
                if (breakpoint instanceof IJavaStratumLineBreakpoint && marker.getResource().equals((Object)res) && (stratumBreakpoint = (IJavaStratumLineBreakpoint)breakpoint).getLineNumber() == line) {
                    return stratumBreakpoint;
                }
                ++n2;
            }
        } else {
            String uriStirng = uri.toString();
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n3 = 0;
            while (n3 < n) {
                IJavaStratumLineBreakpoint stratumBreakpoint;
                IBreakpoint breakpoint = iBreakpointArray[n3];
                IMarker marker = breakpoint.getMarker();
                if (breakpoint instanceof IJavaStratumLineBreakpoint && marker.getResource().equals((Object)res) && uriStirng.equals(marker.getAttribute(JarFileMarkerAnnotationModel.MARKER_URI)) && (stratumBreakpoint = (IJavaStratumLineBreakpoint)breakpoint).getLineNumber() == line) {
                    return stratumBreakpoint;
                }
                ++n3;
            }
        }
        return null;
    }

    protected String getClassNamePattern(IResource res) {
        if (!(res instanceof IStorage)) {
            return null;
        }
        URI uri = this.uriMapper.getUri((IStorage)res);
        IResourceServiceProvider provider = this.providerRegistry.getResourceServiceProvider(uri);
        if (provider == null) {
            return null;
        }
        IResourceSetProvider resourceSetProvider = (IResourceSetProvider)provider.get(IResourceSetProvider.class);
        ResourceSet set = resourceSetProvider.get(res.getProject());
        Resource resource = set.getResource(uri, true);
        if (resource instanceof XtextResource) {
            return this.getClassNamePattern((XtextResource)resource);
        }
        return null;
    }

    protected String getClassNamePattern(XtextResource state) {
        TreeIterator contents = EcoreUtil.getAllContents((Resource)state, (boolean)false);
        StringBuilder sb = new StringBuilder();
        while (contents.hasNext()) {
            Object next = contents.next();
            if (!(next instanceof JvmDeclaredType)) continue;
            JvmDeclaredType type = (JvmDeclaredType)next;
            sb.append(type.getQualifiedName()).append("*");
            sb.append(",");
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    protected static class Data {
        protected String name;
        protected String types;
        protected boolean valid;
        protected LanguageInfo lang;
        protected URI sourceUri;
        protected String classHandle;

        protected Data() {
        }
    }
}

