/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQuery;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.SimpleAttributeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceQueryExecutor {
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private ReferenceQuery referenceQuery;

    protected Iterable<URI> getTargetURIs(EObject primaryTarget) {
        return Collections.singleton(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)primaryTarget));
    }

    public String getLabel(EObject primaryTarget) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLabelPrefix());
        builder.append(this.getElementName(primaryTarget));
        String resourceName = this.getResourceName(primaryTarget);
        if (resourceName != null) {
            builder.append(Messages.FindReferencesHandler_1).append(resourceName).append(Messages.FindReferencesHandler_2);
        }
        return builder.toString();
    }

    protected String getLabelPrefix() {
        return Messages.FindReferencesHandler_labelPrefix;
    }

    protected String getElementName(EObject primaryTarget) {
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(primaryTarget);
        if (qualifiedName != null) {
            return this.qualifiedNameConverter.toString(qualifiedName);
        }
        String simpleName = (String)SimpleAttributeResolver.NAME_RESOLVER.getValue(primaryTarget);
        return simpleName != null ? simpleName : primaryTarget.eResource().getURIFragment(primaryTarget);
    }

    protected String getResourceName(EObject primaryTarget) {
        Iterator<Pair<IStorage, IProject>> storages = this.storage2UriMapper.getStorages(EcoreUtil.getURI((EObject)primaryTarget)).iterator();
        return storages.hasNext() ? ((IStorage)storages.next().getFirst()).getFullPath().toString() : null;
    }

    protected Predicate<IReferenceDescription> getFilter(EObject primaryTarget) {
        return Predicates.alwaysTrue();
    }

    public void init(EObject target) {
        this.referenceQuery.init(this.getTargetURIs(target), this.getFilter(target), this.getLabel(target));
    }

    public void execute() {
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)this.referenceQuery);
    }
}

