/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;

@NonNullByDefault
public class ClosureWithoutExpectationHelper
extends AbstractClosureTypeHelper {
    private final FunctionTypes functionTypes = this.getServices().getFunctionTypes();

    protected ClosureWithoutExpectationHelper(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        super(closure, expectation, state);
    }

    protected void computeTypes() {
        FunctionTypeReference incompleteClosureType = this.getFunctionTypeReference(true);
        ITypeAssigner typeAssigner = this.getState().withoutRootExpectation().assignTypes();
        ITypeComputationState closureBodyTypeComputationState = this.getClosureBodyTypeComputationState(typeAssigner, incompleteClosureType);
        ITypeComputationResult expressionResult = closureBodyTypeComputationState.computeTypes(this.getClosure().getExpression());
        FunctionTypeReference resultClosureType = this.processExpressionType(incompleteClosureType, expressionResult);
        this.getExpectation().acceptActualType(resultClosureType, ConformanceHint.UNCHECKED);
    }

    public FunctionTypeReference getExpectedClosureType() {
        return this.getFunctionTypeReference(true);
    }

    public JvmOperation getOperation() {
        JvmOperation result = this.functionTypes.findImplementingOperation(this.getExpectedClosureType());
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    protected FunctionTypeReference getFunctionTypeReference(boolean isProcedure) {
        FunctionTypeReference result = this.functionTypes.createRawFunctionTypeRef(this.getExpectation().getReferenceOwner(), this.getClosure(), this.getClosure().getFormalParameters().size(), isProcedure);
        this.initClosureType(result, isProcedure);
        return result;
    }

    protected void initClosureType(FunctionTypeReference result, boolean isProcedure) {
        ITypeReferenceOwner owner = result.getOwner();
        TypeParameterByUnboundSubstitutor substitutor = new TypeParameterByUnboundSubstitutor(Collections.emptyMap(), owner){

            protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                UnboundTypeReference result = ClosureWithoutExpectationHelper.this.getExpectation().createUnboundTypeReference(ClosureWithoutExpectationHelper.this.getClosure(), type);
                return result;
            }
        };
        JvmGenericType type = (JvmGenericType)result.getType();
        EList parameters = type.getTypeParameters();
        int max = type.getTypeParameters().size();
        if (!isProcedure) {
            --max;
        }
        int i = 0;
        while (i < max) {
            JvmTypeParameter parameter = (JvmTypeParameter)parameters.get(i);
            ParameterizedTypeReference parameterType = new ParameterizedTypeReference(owner, (JvmType)parameter);
            LightweightTypeReference substituted = substitutor.substitute(parameterType);
            result.addTypeArgument(substituted);
            ++i;
        }
        if (!isProcedure) {
            JvmTypeParameter parameter = (JvmTypeParameter)parameters.get(max);
            ParameterizedTypeReference parameterType = new ParameterizedTypeReference(owner, (JvmType)parameter);
            LightweightTypeReference substituted = substitutor.substitute(parameterType);
            result.addTypeArgument(substituted);
        }
    }

    protected ITypeComputationState getClosureBodyTypeComputationState(ITypeAssigner typeAssigner, FunctionTypeReference incompleteClosureType) {
        JvmFormalParameter closureParameter;
        List<LightweightTypeReference> operationParameterTypes = incompleteClosureType.getTypeArguments();
        EList<JvmFormalParameter> closureParameters = this.getClosure().getFormalParameters();
        int paramCount = Math.min(closureParameters.size(), operationParameterTypes.size());
        int i = 0;
        while (i < paramCount) {
            closureParameter = (JvmFormalParameter)closureParameters.get(i);
            LightweightTypeReference operationParameterType = operationParameterTypes.get(i);
            if (closureParameter.eContainingFeature() != XbasePackage.Literals.XCLOSURE__IMPLICIT_PARAMETER && closureParameter.getParameterType() != null) {
                LightweightTypeReference closureParameterType = typeAssigner.toLightweightTypeReference(closureParameter.getParameterType());
                new DeferredTypeParameterHintCollector(this.getExpectation().getReferenceOwner()){

                    protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                        LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
                        typeParameter.acceptHint(wrapped, BoundTypeArgumentSource.RESOLVED, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                    }
                }.processPairedReferences(operationParameterType, closureParameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, closureParameterType);
                incompleteClosureType.addParameterType(closureParameterType);
            } else {
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, operationParameterType);
                incompleteClosureType.addParameterType(operationParameterType);
            }
            ++i;
        }
        i = paramCount;
        while (i < closureParameters.size()) {
            closureParameter = (JvmFormalParameter)closureParameters.get(i);
            JvmTypeReference parameterType = closureParameter.getParameterType();
            if (parameterType != null) {
                LightweightTypeReference lightweight = typeAssigner.toLightweightTypeReference(parameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, lightweight);
            } else {
                LightweightTypeReference objectType = typeAssigner.toLightweightTypeReference(this.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)closureParameter, new JvmTypeReference[0]));
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, objectType);
            }
            ++i;
        }
        ITypeComputationState result = typeAssigner.getForkedState();
        return result;
    }

    protected FunctionTypeReference processExpressionType(FunctionTypeReference incompleteClosureType, ITypeComputationResult expressionResult) {
        LightweightTypeReference expressionResultType = expressionResult.getReturnType();
        if (expressionResultType == null || !expressionResultType.isPrimitiveVoid()) {
            FunctionTypeReference result = this.getFunctionTypeReference(false);
            LightweightTypeReference expectedReturnType = result.getTypeArguments().get(result.getTypeArguments().size() - 1);
            if (expressionResultType != null && !expressionResultType.isAny()) {
                result.setReturnType(expressionResultType);
                this.deferredBindTypeArgument(expectedReturnType, expressionResultType, BoundTypeArgumentSource.INFERRED);
            } else {
                JvmType objectType = this.getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)incompleteClosureType.getType());
                ParameterizedTypeReference objectTypeReference = new ParameterizedTypeReference(incompleteClosureType.getOwner(), objectType);
                result.setReturnType(objectTypeReference);
                this.deferredBindTypeArgument(expectedReturnType, objectTypeReference, BoundTypeArgumentSource.INFERRED);
            }
            List<LightweightTypeReference> incompleteParameterTypes = incompleteClosureType.getParameterTypes();
            int i = 0;
            while (i < incompleteParameterTypes.size()) {
                result.addParameterType(incompleteParameterTypes.get(i));
                ++i;
            }
            List<LightweightTypeReference> incompleteTypeArguments = incompleteClosureType.getTypeArguments();
            List<LightweightTypeReference> resultTypeArguments = result.getTypeArguments();
            int i2 = 0;
            while (i2 < incompleteTypeArguments.size()) {
                this.deferredBindTypeArgument(resultTypeArguments.get(i2), incompleteTypeArguments.get(i2), BoundTypeArgumentSource.INFERRED);
                ++i2;
            }
            return result;
        }
        incompleteClosureType.setReturnType(expressionResultType);
        return incompleteClosureType;
    }
}

