/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.ui.editor.model.edit.ReconcilingUnitOfWork;
import org.eclipse.xtext.util.concurrent.AbstractReadWriteAcces;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextDocument
extends Document
implements IXtextDocument {
    private DocumentTokenSource tokenSource;
    private ITextEditComposer composer;
    private XtextResource resource = null;
    private final List<IXtextModelListener> modelListeners = new ArrayList<IXtextModelListener>();
    private final ListenerList xtextDocumentObservers = new ListenerList(1);
    private final XtextDocumentLocker stateAccess = this.createDocumentLocker();
    private static final IUnitOfWork.Void<XtextResource> noWork = new IUnitOfWork.Void<XtextResource>(){

        public void process(XtextResource state) throws Exception {
        }
    };
    private static final Logger log = Logger.getLogger(XtextDocument.class);
    private transient Job validationJob;
    private ReadWriteLock positionsLock = new ReentrantReadWriteLock();
    private Lock positionsReadLock = this.positionsLock.readLock();
    private Lock positionsWriteLock = this.positionsLock.writeLock();

    @Inject
    public XtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        this.tokenSource = tokenSource;
        tokenSource.computeDamageRegion(new DocumentEvent((IDocument)this, 0, this.getLength(), this.get()));
        this.composer = composer;
    }

    public void setInput(XtextResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    public void disposeInput() {
        this.resource = null;
        if (this.validationJob != null) {
            this.validationJob.cancel();
        }
    }

    protected XtextDocumentLocker createDocumentLocker() {
        return new XtextDocumentLocker();
    }

    public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
        return this.stateAccess.readOnly(work);
    }

    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        this.readOnly((IUnitOfWork<T, XtextResource>)noWork);
        ReconcilingUnitOfWork<T> reconcilingUnitOfWork = new ReconcilingUnitOfWork<T>(work, this, this.composer);
        return this.internalModify(reconcilingUnitOfWork);
    }

    public <T> T internalModify(IUnitOfWork<T, XtextResource> work) {
        return this.stateAccess.modify(work);
    }

    protected void ensureThatStateIsNotReturned(Object exec, IUnitOfWork<?, XtextResource> uow) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        List<IXtextModelListener> list = this.modelListeners;
        synchronized (list) {
            if (this.modelListeners.contains(listener)) {
                return;
            }
            if (listener instanceof DirtyStateEditorSupport) {
                this.modelListeners.add(0, listener);
            } else {
                this.modelListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        List<IXtextModelListener> list = this.modelListeners;
        synchronized (list) {
            this.modelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyModelListeners(XtextResource res) {
        ArrayList modelListenersCopy;
        if (res == null || res != this.resource) {
            return;
        }
        List<IXtextModelListener> list = this.modelListeners;
        synchronized (list) {
            modelListenersCopy = Lists.newArrayList(this.modelListeners);
        }
        for (IXtextModelListener listener : modelListenersCopy) {
            try {
                if (res != this.resource) {
                    return;
                }
                listener.modelChanged(res);
            }
            catch (Exception exc) {
                log.error((Object)"Error in IXtextModelListener", (Throwable)exc);
            }
        }
    }

    @Override
    public void addXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.addDocumentListener(observer);
        this.xtextDocumentObservers.add((Object)observer);
    }

    @Override
    public void removeXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.xtextDocumentObservers.remove((Object)observer);
        this.removeDocumentListener(observer);
    }

    protected <T> void updateContentBeforeRead() {
        Object[] listeners = this.xtextDocumentObservers.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IXtextDocumentContentObserver)listeners[i]).performNecessaryUpdates(this.stateAccess);
            ++i;
        }
    }

    public void setValidationJob(Job validationJob) {
        this.validationJob = validationJob;
    }

    public Job getValidationJob() {
        return this.validationJob;
    }

    public void checkAndUpdateAnnotations() {
        if (this.validationJob != null) {
            this.validationJob.cancel();
            if (this.resource != null) {
                this.validationJob.schedule();
            }
        }
    }

    public URI getResourceURI() {
        XtextResource resource = this.resource;
        if (resource != null) {
            return resource.getURI();
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        XtextResource resource = this.resource;
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if ((adapterType == IFile.class || adapterType == IResource.class) && uri.isPlatformResource()) {
            return (T)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }

    public Position[] getPositions(String category, int offset, int length, boolean canStartBefore, boolean canEndAfter) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category, offset, length, canStartBefore, canEndAfter);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public void addPosition(Position position) throws BadLocationException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(Position position) {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        this.tokenSource.updateStructure(event);
        super.fireDocumentChanged(event);
    }

    public IRegion getLastDamage() {
        return this.tokenSource.getLastDamagedRegion();
    }

    public Iterable<ILexerTokenRegion> getTokens() {
        return this.tokenSource.getTokenInfos();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XtextDocumentLocker
    extends AbstractReadWriteAcces<XtextResource>
    implements IXtextDocumentContentObserver.Processor {
        protected XtextDocumentLocker() {
        }

        protected XtextResource getState() {
            return XtextDocument.this.resource;
        }

        protected void beforeReadOnly(XtextResource res, IUnitOfWork<?, XtextResource> work) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("read - " + Thread.currentThread().getName()));
            }
            if (this.getReadHoldCount() == 1 && this.getWriteHoldCount() == 0) {
                XtextDocument.this.updateContentBeforeRead();
            }
        }

        protected void beforeModify(XtextResource state, IUnitOfWork<?, XtextResource> work) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("write - " + Thread.currentThread().getName()));
            }
        }

        protected void afterReadOnly(XtextResource res, Object result, IUnitOfWork<?, XtextResource> work) {
            XtextDocument.this.ensureThatStateIsNotReturned(result, work);
        }

        protected void afterModify(XtextResource res, Object result, IUnitOfWork<?, XtextResource> work) {
            XtextDocument.this.ensureThatStateIsNotReturned(result, work);
            if (!(work instanceof ReconcilingUnitOfWork)) {
                XtextDocument.this.notifyModelListeners(res);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T modify(IUnitOfWork<T, XtextResource> work) {
            Object object;
            try {
                XtextResource state;
                if (XtextDocument.this.validationJob != null) {
                    XtextDocument.this.validationJob.cancel();
                }
                if ((state = this.getState()) instanceof ISynchronizable) {
                    Object object2 = ((ISynchronizable)state).getLock();
                    synchronized (object2) {
                        Object object3 = super.modify(work);
                        return (T)object3;
                    }
                }
                object = super.modify(work);
            }
            catch (RuntimeException e) {
                try {
                    XtextResource state = this.getState();
                    if (state != null) {
                        state.reparse(XtextDocument.this.get());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                if (!(work instanceof ReconcilingUnitOfWork)) {
                    XtextDocument.this.checkAndUpdateAnnotations();
                }
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
            XtextResource state = this.getState();
            if (state instanceof ISynchronizable) {
                Object object = ((ISynchronizable)state).getLock();
                synchronized (object) {
                    return (T)super.readOnly(work);
                }
            }
            return (T)super.readOnly(work);
        }
    }
}

