/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tests;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.wikitext.tests.HeadRequired;

@HeadRequired
public abstract class AbstractTestInWorkspace
extends TestCase {
    private static boolean init = false;
    private final List<IProject> temporaryProjects = new ArrayList<IProject>();

    public AbstractTestInWorkspace() {
        if (!init) {
            try {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new IllegalStateException(e);
            }
            init = true;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (!this.temporaryProjects.isEmpty()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            monitor.beginTask("Removing " + this.temporaryProjects.size() + " temporary projects", 100 * this.temporaryProjects.size());
            try {
                for (IProject project : this.temporaryProjects) {
                    project.delete(true, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 100));
                }
            }
            finally {
                monitor.done();
                this.temporaryProjects.clear();
            }
        }
    }

    public IProject createSimpleProject() throws CoreException {
        long seed = System.currentTimeMillis();
        String projectName = "test" + seed;
        String tmpDir = System.getProperty("java.io.tmpdir");
        URI location = new File(tmpDir, projectName).toURI();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocationURI(location);
        IProject project = workspace.getRoot().getProject(projectName);
        project.create(description, (IProgressMonitor)new NullProgressMonitor());
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        this.temporaryProjects.add(project);
        return project;
    }
}

