/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.v1_1;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwtjsonrpc.client.JsonUtil;
import com.google.gwtjsonrpc.client.RemoteJsonException;
import com.google.gwtjsonrpc.client.event.RpcCompleteEvent;
import com.google.gwtjsonrpc.client.impl.AbstractJsonProxy;
import com.google.gwtjsonrpc.client.impl.JsonCall;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;

public class JsonCall11HttpPost<T>
extends JsonCall<T> {
    public JsonCall11HttpPost(AbstractJsonProxy abstractJsonProxy, String methodName, String requestParams, ResultDeserializer<T> resultDeserializer, AsyncCallback<T> callback) {
        super(abstractJsonProxy, methodName, requestParams, resultDeserializer, callback);
    }

    @Override
    protected void send() {
        StringBuilder body = new StringBuilder();
        body.append("{\"version\":\"1.1\",\"method\":\"");
        body.append(this.methodName);
        body.append("\",\"params\":");
        body.append(this.requestParams);
        String xsrfKey = this.proxy.getXsrfManager().getToken(this.proxy);
        if (xsrfKey != null) {
            body.append(",\"xsrfKey\":");
            body.append(JsonUtils.escapeValue((String)xsrfKey));
        }
        body.append("}");
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, this.proxy.getServiceEntryPoint());
        rb.setHeader("Content-Type", "application/json; charset=utf-8");
        rb.setHeader("Accept", "application/json");
        rb.setCallback((RequestCallback)this);
        rb.setRequestData(body.toString());
        this.send(rb);
    }

    public void onResponseReceived(Request req, Response rsp) {
        int sc = rsp.getStatusCode();
        if (JsonCall11HttpPost.isJsonBody(rsp)) {
            RpcResult r;
            try {
                r = JsonCall11HttpPost.parse(jsonParser, rsp.getText());
            }
            catch (RuntimeException e) {
                RpcCompleteEvent.fire(this);
                this.callback.onFailure((Throwable)new InvocationException("Bad JSON response: " + e));
                return;
            }
            if (r.xsrfKey() != null) {
                this.proxy.getXsrfManager().setToken(this.proxy, r.xsrfKey());
            }
            if (r.error() != null) {
                String errmsg = r.error().message();
                if ("Invalid xsrfKey in request".equals(errmsg)) {
                    if (this.attempts < 2) {
                        this.send();
                    } else {
                        RpcCompleteEvent.fire(this);
                        this.callback.onFailure((Throwable)new InvocationException(errmsg));
                    }
                } else {
                    RpcCompleteEvent.fire(this);
                    this.callback.onFailure((Throwable)new RemoteJsonException(errmsg, r.error().code(), new JSONObject((JavaScriptObject)r.error()).get("error")));
                }
                return;
            }
            if (sc == 200) {
                RpcCompleteEvent.fire(this);
                JsonUtil.invoke(this.resultDeserializer, this.callback, r);
                return;
            }
        }
        if (sc == 200) {
            RpcCompleteEvent.fire(this);
            this.callback.onFailure((Throwable)new InvocationException("No JSON response"));
        } else {
            RpcCompleteEvent.fire(this);
            this.callback.onFailure((Throwable)new StatusCodeException(sc, rsp.getStatusText()));
        }
    }

    private static boolean isJsonBody(Response rsp) {
        String type = rsp.getHeader("Content-Type");
        if (type == null) {
            return false;
        }
        int semi = type.indexOf(59);
        if (semi >= 0) {
            type = type.substring(0, semi).trim();
        }
        return "application/json".equals(type);
    }

    private static final native RpcResult parse(JavaScriptObject var0, String var1);

    private static class RpcError
    extends JavaScriptObject {
        protected RpcError() {
        }

        final native String message();

        final native int code();
    }

    private static class RpcResult
    extends JavaScriptObject {
        protected RpcResult() {
        }

        final native RpcError error();

        final native String xsrfKey();
    }
}

