/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class BugzillaRepositoryConnectorConfigurationTest
extends TestCase {
    private TaskRepository repository;
    private BugzillaRepositoryConnector connector;
    public static final BugzillaVersion BUGZILLA_3_5 = new BugzillaVersion("3.5");

    public void setUp() throws Exception {
        BugzillaFixture.current().client(CommonTestUtil.PrivilegeLevel.USER);
        this.repository = BugzillaFixture.current().repository();
        this.connector = BugzillaFixture.current().connector();
    }

    public void testGetRepositoryConfiguration() throws Exception {
        RepositoryConfiguration config = this.connector.getRepositoryConfiguration(this.repository, true, null);
        BugzillaRepositoryConnectorConfigurationTest.assertNotNull((Object)config);
        String eTag = config.getETagValue();
        if (config.getInstallVersion().compareTo(BUGZILLA_3_5) < 0) {
            BugzillaRepositoryConnectorConfigurationTest.assertNull((Object)eTag);
            config.setETagValue("wrongETag");
            config = this.connector.getRepositoryConfiguration(this.repository, true, null);
            BugzillaRepositoryConnectorConfigurationTest.assertNotNull((Object)config);
            String eTagNew = config.getETagValue();
            BugzillaRepositoryConnectorConfigurationTest.assertNull((Object)eTagNew);
        } else {
            BugzillaRepositoryConnectorConfigurationTest.assertNotNull((Object)eTag);
            config.setETagValue("wrongETag");
            config = this.connector.getRepositoryConfiguration(this.repository, true, null);
            BugzillaRepositoryConnectorConfigurationTest.assertNotNull((Object)config);
            BugzillaRepositoryConnectorConfigurationTest.assertNotNull((Object)config.getETagValue());
            String eTagNew = config.getETagValue();
            BugzillaRepositoryConnectorConfigurationTest.assertNotNull((Object)eTagNew);
            BugzillaRepositoryConnectorConfigurationTest.assertEquals((String)eTag, (String)eTagNew);
        }
    }
}

