/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.tasks.ui.ConnectorBrand;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewRepositoryWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.SelectRepositoryConnectorPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositorySettingsPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewRepositoryWizardTest {
    private NewRepositoryWizard wizard;

    @Before
    public void setUp() {
        this.wizard = new NewRepositoryWizard();
        this.wizard.addPages();
    }

    @Test
    public void testGetNextPageIWizardPage() {
        SelectRepositoryConnectorPage page = (SelectRepositoryConnectorPage)this.wizard.getPage(Messages.SelectRepositoryConnectorPage_Select_a_task_repository_type);
        page.setConnectorBrand(new ConnectorBrand((AbstractRepositoryConnector)new MockRepositoryConnector(), "org.mylyn"));
        this.wizard.getNextPage(null);
        Assert.assertNull((Object)this.wizard.getBrand());
        this.wizard.getNextPage((IWizardPage)page);
        Assert.assertEquals((Object)"org.mylyn", (Object)this.wizard.getBrand());
    }

    @Test
    public void testSetsBrandOnSettingsPage() {
        MockRepositorySettingsPage settingsPage = this.navigateWithBrands("org.mylyn");
        Assert.assertEquals((Object)"org.mylyn", (Object)settingsPage.getBrand());
    }

    public void testSetsBrandOnSettingsPageNoBrand() {
        MockRepositorySettingsPage settingsPage = this.navigateWithBrands(new String[]{null});
        Assert.assertEquals((Object)"", (Object)settingsPage.getBrand());
    }

    @Test
    public void testSetsBrandOnSettingsPageBrandChangeToNull() {
        MockRepositorySettingsPage settingsPage = this.navigateWithBrands("org.mylyn", null);
        Assert.assertEquals((Object)"", (Object)settingsPage.getBrand());
    }

    @Test
    public void testSetsBrandOnSettingsPageBrandChangeFromNull() {
        MockRepositorySettingsPage settingsPage = this.navigateWithBrands(null, "org.mylyn");
        Assert.assertEquals((Object)"org.mylyn", (Object)settingsPage.getBrand());
    }

    @Test
    public void testSetsBrandOnSettingsPageBrandChange() {
        MockRepositorySettingsPage settingsPage = this.navigateWithBrands("org.eclipse", "org.mylyn");
        Assert.assertEquals((Object)"org.mylyn", (Object)settingsPage.getBrand());
    }

    private MockRepositorySettingsPage navigateWithBrands(String ... brands) {
        SelectRepositoryConnectorPage selectionPage = (SelectRepositoryConnectorPage)this.wizard.getPage(Messages.SelectRepositoryConnectorPage_Select_a_task_repository_type);
        String[] stringArray = brands;
        int n = brands.length;
        int n2 = 0;
        while (n2 < n) {
            String brand = stringArray[n2];
            selectionPage.setConnectorBrand(new ConnectorBrand((AbstractRepositoryConnector)new MockRepositoryConnector(), brand));
            this.wizard.getNextPage((IWizardPage)selectionPage);
            ++n2;
        }
        return (MockRepositorySettingsPage)this.wizard.getNextPage((IWizardPage)selectionPage);
    }
}

