/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.internal.tasks.ui.OptionsProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.LabelsAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.MultiSelectionAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.SingleSelectionAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AttributeEditorToolkitTest {
    private TestAttributeEditorToolkit toolkit;
    private TaskAttribute taskAttribute;
    private final FormToolkit formToolkit = new FormToolkit(Display.getCurrent());
    private final TaskDataModel taskDataModel = (TaskDataModel)Mockito.mock(TaskDataModel.class);

    @Before
    public void setUp() {
        CommonTextSupport textSupport = (CommonTextSupport)Mockito.mock(CommonTextSupport.class);
        this.toolkit = (TestAttributeEditorToolkit)((Object)Mockito.spy((Object)((Object)new TestAttributeEditorToolkit(textSupport))));
        TaskData taskData = TaskTestUtil.createMockTaskData((String)"1");
        this.taskAttribute = taskData.getRoot();
        Mockito.when((Object)this.taskDataModel.getTaskData()).thenReturn((Object)taskData);
    }

    @After
    public void tearDown() {
        this.formToolkit.dispose();
    }

    @Test
    public void testAdaptSingleSelectionAttributeEditor() {
        SingleSelectionAttributeEditor editor = new SingleSelectionAttributeEditor(this.taskDataModel, this.taskAttribute);
        this.assertNoOptionsProposalProvider((AbstractAttributeEditor)editor);
    }

    @Test
    public void testAdaptMultiSelectionAttributeEditor() {
        MultiSelectionAttributeEditor editor = new MultiSelectionAttributeEditor(this.taskDataModel, this.taskAttribute);
        this.assertNoOptionsProposalProvider((AbstractAttributeEditor)editor);
    }

    private void assertNoOptionsProposalProvider(AbstractAttributeEditor editor) {
        editor.createControl((Composite)WorkbenchUtil.getShell(), this.formToolkit);
        this.toolkit.adapt(editor);
        ((TestAttributeEditorToolkit)((Object)Mockito.verify((Object)((Object)this.toolkit), (VerificationMode)Mockito.never()))).createContentProposalProvider((AbstractAttributeEditor)Matchers.any(AbstractAttributeEditor.class));
        ((TestAttributeEditorToolkit)((Object)Mockito.verify((Object)((Object)this.toolkit), (VerificationMode)Mockito.never()))).createContentAssistCommandAdapter((Control)Matchers.any(Control.class), (IContentProposalProvider)Matchers.any(IContentProposalProvider.class));
    }

    @Test
    public void testAdaptLabelsAttributeEditor() {
        this.assertOptionsProposalProvider(true, false);
        this.assertOptionsProposalProvider(false, false);
        this.assertOptionsProposalProvider(true, true);
    }

    private void assertOptionsProposalProvider(boolean isMultiSelect, boolean isPerson) {
        this.taskAttribute.getMetaData().setKind(isPerson ? "task.common.kind.people" : "task.common.kind.default");
        this.taskAttribute.getMetaData().setType(isMultiSelect ? "multiSelect" : "singleSelect");
        LabelsAttributeEditor editor = new LabelsAttributeEditor(this.taskDataModel, this.taskAttribute);
        editor.createControl((Composite)WorkbenchUtil.getShell(), this.formToolkit);
        this.toolkit.adapt((AbstractAttributeEditor)editor);
        ((TestAttributeEditorToolkit)((Object)Mockito.verify((Object)((Object)this.toolkit)))).createContentProposalProvider((AbstractAttributeEditor)editor);
        ArgumentCaptor providerCaptor = ArgumentCaptor.forClass(IContentProposalProvider.class);
        ((TestAttributeEditorToolkit)((Object)Mockito.verify((Object)((Object)this.toolkit)))).createContentAssistCommandAdapter((Control)Matchers.eq((Object)editor.getControl()), (IContentProposalProvider)providerCaptor.capture());
        IContentProposalProvider proposalProvider = (IContentProposalProvider)providerCaptor.getValue();
        if (isPerson) {
            Assert.assertTrue((boolean)(proposalProvider instanceof PersonProposalProvider));
        } else {
            Assert.assertTrue((boolean)(proposalProvider instanceof OptionsProposalProvider));
            Assert.assertEquals((Object)isMultiSelect, (Object)((OptionsProposalProvider)proposalProvider).isMultiSelect());
        }
        Assert.assertNull((Object)this.toolkit.commandAdapter.getAutoActivationCharacters());
    }

    public class TestAttributeEditorToolkit
    extends AttributeEditorToolkit {
        private ContentAssistCommandAdapter commandAdapter;

        TestAttributeEditorToolkit(CommonTextSupport textSupport) {
            super(textSupport);
        }

        public ContentAssistCommandAdapter createContentAssistCommandAdapter(Control control, IContentProposalProvider proposalProvider) {
            this.commandAdapter = super.createContentAssistCommandAdapter(control, proposalProvider);
            return this.commandAdapter;
        }

        public IContentProposalProvider createContentProposalProvider(AbstractAttributeEditor editor) {
            return super.createContentProposalProvider(editor);
        }
    }
}

