/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage2;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;
import org.eclipse.swt.widgets.Composite;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractRepositoryQueryPage2Test {
    private TestRepositoryQueryPage page;
    private IRepositoryQuery savedQuery;

    @Before
    public void setUp() {
        TaskRepository repository = new TaskRepository("mock", "http://mock");
        this.savedQuery = (IRepositoryQuery)Mockito.mock(IRepositoryQuery.class);
        this.page = new TestRepositoryQueryPage("page", repository, this.savedQuery);
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(repository);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        wizard.setContainer((IWizardContainer)dialog);
        wizard.addPage((IWizardPage)this.page);
        this.page.createControl((Composite)WorkbenchUtil.getShell());
        dialog.create();
        this.page.setSuggestedTitle("suggested title");
    }

    @Test
    public void suggestsTitleWhenTitleEmpty() {
        Assert.assertEquals((Object)"", (Object)this.page.getQueryTitle());
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
    }

    @Test
    public void doesNotSuggestTitleWhenTitleEdited() {
        this.page.setQueryTitle("test");
        Assert.assertEquals((Object)"test", (Object)this.page.getQueryTitle());
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"test", (Object)this.page.getQueryTitle());
        this.page.setQueryTitle("testing");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"testing", (Object)this.page.getQueryTitle());
    }

    @Test
    public void suggestsTitleWhenTitleCleared() {
        this.page.setQueryTitle("test");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"test", (Object)this.page.getQueryTitle());
        this.page.setQueryTitle("");
        Assert.assertEquals((Object)"", (Object)this.page.getQueryTitle());
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
    }

    @Test
    public void suggestsTitleWhenSuggestionChanges() {
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
        this.page.setSuggestedTitle("another suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"another suggested title", (Object)this.page.getQueryTitle());
    }

    @Test
    public void suggestsTitleWhenSuggestionEmpty() {
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
        this.page.setSuggestedTitle("");
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"", (Object)this.page.getQueryTitle());
    }

    @Test
    public void doesNotSuggestTitleWhenEditedTitleEqualsSuggestion() {
        Mockito.when((Object)this.savedQuery.getSummary()).thenReturn((Object)"saved title");
        this.page.setQueryTitle("suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
        this.page.setSuggestedTitle("another suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
    }

    @Test
    public void doesNotSuggestTitleWhenSavedTitleEqualsSuggestion() {
        Mockito.when((Object)this.savedQuery.getSummary()).thenReturn((Object)"suggested title");
        this.page.setQueryTitle("edited title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"edited title", (Object)this.page.getQueryTitle());
        this.page.setSuggestedTitle("another suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"edited title", (Object)this.page.getQueryTitle());
    }

    @Test
    public void doesNotSuggestTitleWhenEditedTitleEqualsSavedTitle() {
        Mockito.when((Object)this.savedQuery.getSummary()).thenReturn((Object)"saved title");
        this.page.setQueryTitle("saved title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"saved title", (Object)this.page.getQueryTitle());
        this.page.setSuggestedTitle("another suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"saved title", (Object)this.page.getQueryTitle());
    }

    @Test
    public void suggestsTitleWhenEditingQueryWithSuggestedTitle() {
        Mockito.when((Object)this.savedQuery.getSummary()).thenReturn((Object)"suggested title");
        this.page.setQueryTitle("suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
        this.page.setSuggestedTitle("another suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"another suggested title", (Object)this.page.getQueryTitle());
    }

    @Test
    public void suggestTitleUpdatesCompletion() {
        this.page.getContainer().updateButtons();
        Assert.assertEquals((Object)"suggested title", (Object)this.page.getQueryTitle());
        Assert.assertTrue((boolean)this.page.isPageComplete());
        this.page.setSuggestedTitle("");
        this.page.getContainer().updateButtons();
        Assert.assertFalse((boolean)this.page.isPageComplete());
        Assert.assertEquals((Object)"", (Object)this.page.getQueryTitle());
        this.page.getContainer().updateButtons();
        Assert.assertFalse((boolean)this.page.isPageComplete());
        Assert.assertEquals((Object)"", (Object)this.page.getQueryTitle());
        this.page.setSuggestedTitle("another suggested title");
        this.page.getContainer().updateButtons();
        Assert.assertTrue((boolean)this.page.isPageComplete());
        Assert.assertEquals((Object)"another suggested title", (Object)this.page.getQueryTitle());
    }

    private final class TestRepositoryQueryPage
    extends AbstractRepositoryQueryPage2 {
        private String suggestedTitle;

        private TestRepositoryQueryPage(String pageName, TaskRepository repository, IRepositoryQuery query) {
            super(pageName, repository, query);
            this.suggestedTitle = "";
        }

        protected String suggestQueryTitle() {
            return this.suggestedTitle;
        }

        protected IWizardContainer getContainer() {
            return super.getContainer();
        }

        protected void createPageContent(SectionComposite parent) {
        }

        protected void doRefreshControls() {
        }

        protected boolean hasRepositoryConfiguration() {
            return false;
        }

        protected boolean restoreState(IRepositoryQuery query) {
            return false;
        }

        public void applyTo(IRepositoryQuery query) {
        }

        public void setSuggestedTitle(String suggestedTitle) {
            this.suggestedTitle = suggestedTitle;
        }
    }
}

