/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaHarness;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.FixtureConfiguration;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tests.util.TestFixture;

public class BugzillaFixture
extends TestFixture {
    public static final String CUSTOM_WF = "Custom Workflow";
    public static final String CUSTOM_WF_AND_STATUS = "Custom Workflow and Status";
    private static BugzillaFixture current;
    private final String version;
    private final BugzillaVersion bugzillaVersion;
    private final Map<String, String> properties;
    private final Map<String, String> defaultproperties = new HashMap<String, String>(){
        private static final long serialVersionUID = 6995247925138693239L;
        {
            this.put("xmlrpc_enabled", "true");
        }
    };
    private BugzillaRepositoryConnector connector;

    public BugzillaFixture(FixtureConfiguration config) {
        super("bugzilla", config.getUrl());
        this.version = config.getVersion();
        this.bugzillaVersion = new BugzillaVersion(this.version);
        this.setInfo("Bugzilla", this.version, config.getInfo());
        this.properties = config.getProperties();
    }

    public BugzillaFixture(String url, String version, String info) {
        super("bugzilla", url);
        this.version = version;
        this.bugzillaVersion = new BugzillaVersion(version);
        this.setInfo("Bugzilla", version, info);
        this.properties = null;
    }

    public BugzillaVersion getBugzillaVersion() {
        return this.bugzillaVersion;
    }

    public static void cleanup010() throws Exception {
    }

    public static BugzillaFixture current() {
        if (current == null) {
            current = (BugzillaFixture)((Object)TestConfiguration.getDefault().discoverDefault(BugzillaFixture.class, "bugzilla"));
            current.activate();
        }
        return current;
    }

    public BugzillaFixture activate() {
        current = this;
        this.setUpFramework();
        return this;
    }

    protected TestFixture getDefault() {
        return (TestFixture)TestConfiguration.getDefault().discoverDefault(BugzillaFixture.class, "bugzilla");
    }

    public String getVersion() {
        return this.version;
    }

    public BugzillaClient client() throws CoreException, IOException {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        return this.client(this.getRepositoryUrl(), credentials.getUserName(), credentials.getPassword(), "", "", "UTF-8");
    }

    public BugzillaClient client(String hostUrl, String username, String password, String htAuthUser, String htAuthPass, String encoding) throws CoreException, IOException {
        WebLocation location = new WebLocation(hostUrl);
        location.setCredentials(AuthenticationType.REPOSITORY, username, password);
        location.setCredentials(AuthenticationType.HTTP, htAuthUser, htAuthPass);
        return this.client((AbstractWebLocation)location, encoding);
    }

    public BugzillaClient client(AbstractWebLocation location, String encoding) throws CoreException {
        TaskRepository taskRepository = new TaskRepository("bugzilla", location.getUrl());
        if (this.getDsciptorfile() != null) {
            String filepath = "testdata/repository/" + this.getDsciptorfile();
            try {
                File file = BugzillaFixture.getFile(filepath);
                if (file != null) {
                    taskRepository.setProperty("bugzilla.desciptorFile", file.getCanonicalPath());
                }
            }
            catch (AssertionFailedError file) {
            }
            catch (IOException file) {
                // empty catch block
            }
        }
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, location.getCredentials(AuthenticationType.REPOSITORY), false);
        taskRepository.setCredentials(AuthenticationType.HTTP, location.getCredentials(AuthenticationType.HTTP), false);
        taskRepository.setCharacterEncoding(encoding);
        taskRepository.setProperty("bugzilla.xmlrpc.status.transition", this.getProperty("xmlrpc_enabled"));
        this.connector = new BugzillaRepositoryConnector();
        BugzillaClientManager bugzillaClientManager = this.connector.getClientManager();
        BugzillaClient client = bugzillaClientManager.getClient(taskRepository, null);
        this.connector.getRepositoryConfiguration(taskRepository, false, (IProgressMonitor)new NullProgressMonitor());
        this.connector.writeRepositoryConfigFile();
        return client;
    }

    public BugzillaClient client(CommonTestUtil.PrivilegeLevel level) throws Exception {
        AbstractWebLocation location = this.location(level);
        return this.client(location, "UTF-8");
    }

    public static File getFile(String filename) throws IOException {
        return CommonTestUtil.getFile(BugzillaFixture.class, (String)filename);
    }

    public static InputStream getResource(String filename) throws IOException {
        return CommonTestUtil.getResource(BugzillaFixture.class, (String)filename);
    }

    public TaskData createTask(CommonTestUtil.PrivilegeLevel level, String summary, String description) throws Exception {
        String summaryNotNull = summary != null ? summary : "summary";
        String descriptionNotNull = description != null ? description : "description";
        return this.createTask(level, (Map<String, String>)new HashMap<String, String>(summaryNotNull, descriptionNotNull){
            private static final long serialVersionUID = 1L;
            {
                this.put("task.common.summary", string);
                this.put("task.common.description", string2);
                this.put(BugzillaAttribute.OP_SYS.getKey(), "All");
                this.put(BugzillaAttribute.REP_PLATFORM.getKey(), "All");
                this.put(BugzillaAttribute.VERSION.getKey(), "unspecified");
            }
        });
    }

    public TaskData createTask(CommonTestUtil.PrivilegeLevel level, Map<String, String> additionalAttributeValues) throws Exception {
        Assert.isLegal((boolean)additionalAttributeValues.containsKey("task.common.summary"), (String)"need value for Summary");
        Assert.isLegal((boolean)additionalAttributeValues.containsKey("task.common.description"), (String)"need value for Description");
        TaskMapping initializationData = new TaskMapping(){

            public String getProduct() {
                return "ManualTest";
            }

            public String getComponent() {
                return "ManualC1";
            }
        };
        BugzillaClient client = this.client(level);
        AbstractTaskDataHandler taskDataHandler = this.connector().getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository());
        TaskData taskData = new TaskData(mapper, this.repository().getConnectorKind(), this.repository().getRepositoryUrl(), "");
        taskDataHandler.initializeTaskData(this.repository(), taskData, (ITaskMapping)initializationData, null);
        for (String attributeKey : additionalAttributeValues.keySet()) {
            taskData.getRoot().createMappedAttribute(attributeKey).setValue(additionalAttributeValues.get(attributeKey));
        }
        RepositoryResponse response = this.submitTask(taskData, client);
        String bugId = response.getTaskId();
        return this.getTask(bugId, client);
    }

    public TaskData getTask(String id, BugzillaClient client) throws Exception {
        AbstractTaskDataHandler taskDataHandler = this.connector().getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository());
        final TaskData[] newData = new TaskData[1];
        client.getTaskData(Collections.singleton(id), new TaskDataCollector(){

            public void accept(TaskData data) {
                newData[0] = data;
            }
        }, mapper, null);
        taskDataHandler.initializeTaskData(this.repository(), newData[0], null, null);
        return newData[0];
    }

    public RepositoryResponse submitTask(TaskData taskData, BugzillaClient client) throws IOException, CoreException {
        RepositoryResponse result = client.postTaskData(taskData, null);
        return result;
    }

    public BugzillaRepositoryConnector connector() {
        return this.connector;
    }

    public String getProperty(String key) {
        String result = null;
        if (this.properties != null) {
            result = this.properties.get(key);
            if (result == null) {
                result = this.defaultproperties.get(key);
            }
        } else {
            result = this.defaultproperties.get(key);
        }
        return result;
    }

    public boolean isCustomWorkflowAndStatus() {
        return Boolean.parseBoolean(this.getProperty("custom_wf_and_status"));
    }

    public boolean isCustomWorkflow() {
        return Boolean.parseBoolean(this.getProperty("custom_wf"));
    }

    public boolean isXmlRpcEnabled() {
        return Boolean.parseBoolean(this.getProperty("xmlrpc_enabled"));
    }

    public String getDsciptorfile() {
        return this.getProperty("desciptorfile");
    }

    public BugzillaHarness createHarness() {
        return new BugzillaHarness(this);
    }

    public boolean isBugzilla51OrGreater() {
        return this.bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_5_1) < 0;
    }
}

