/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class TracTestCleanupUtil
extends TestCase {
    private TracFixture fixture = TracFixture.current();

    public TracTestCleanupUtil(String name) {
        super(name);
    }

    protected void setFixture(TracFixture fixture) {
        this.fixture = fixture;
    }

    @Test
    public void testCleanUpTasks() throws Exception {
        System.err.println("Connected to " + this.fixture.getRepositoryUrl());
        ITracClient client = this.fixture.connectXmlRpc(CommonTestUtil.PrivilegeLevel.ADMIN);
        this.deleteOldTickets(client);
    }

    public void deleteOldTickets(ITracClient client) throws TracException {
        TracSearch query = new TracSearch();
        query.setMax(10000);
        ArrayList result = new ArrayList();
        client.searchForTicketIds(query, result, null);
        System.err.println("Found " + result.size() + " tickets");
        System.err.print("Deleting ticket: ");
        for (Integer i : result) {
            if (i <= 10) continue;
            System.err.print(i + ", ");
            client.deleteTicket(i.intValue(), null);
            if (i % 20 != 0) continue;
            System.err.println();
            System.err.print(" ");
        }
        System.err.println();
    }

    @RunWith(value=Parameterized.class)
    public static class TracTestCleanupUtil4
    extends TracTestCleanupUtil {
        public TracTestCleanupUtil4(TracFixture fixture, String name) {
            super(name);
            this.setFixture(fixture);
        }

        @Parameterized.Parameters
        public static Iterable<Object[]> data() {
            List fixtures = TestConfiguration.getDefault().discover(TracFixture.class, "trac");
            ArrayList<Object[]> data = new ArrayList<Object[]>(fixtures.size());
            for (TracFixture fixture : fixtures) {
                data.add(new Object[]{fixture, fixture.getInfo()});
            }
            return data;
        }
    }
}

