/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class FlagAttributeEditor
extends AbstractAttributeEditor {
    private String[] values;
    private CCombo combo;
    private Text requesteeText;
    private ImageHyperlink selfLink;
    private Text flagText;
    private Text requesteeROText;
    private boolean suppressRefresh;
    private Composite flagComposite;

    public FlagAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
        if (taskAttribute.getAttribute("state") != null) {
            this.setReadOnly(taskAttribute.getAttribute("state").getMetaData().isReadOnly());
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.flagComposite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 10;
        this.flagComposite.setLayout((Layout)layout);
        if (this.isReadOnly()) {
            this.flagText = new Text(this.flagComposite, 0x800008);
            toolkit.adapt((Control)this.flagText, false, false);
            this.flagText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.flagText.setText(this.getValueLabel());
            this.flagText.setBackground(parent.getBackground());
            this.flagText.setEditable(false);
            String tooltip = this.getTaskAttribute().getMetaData().getLabel();
            if (tooltip == null) {
                tooltip = this.getDescription();
            }
            if (tooltip != null) {
                this.flagText.setToolTipText(tooltip);
            }
            TaskAttribute requestee = this.getTaskAttribute().getAttribute("requestee");
            this.requesteeROText = new Text(this.flagComposite, 0x800008);
            toolkit.adapt((Control)this.requesteeROText, false, false);
            this.requesteeROText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.requesteeROText.setText(requestee.getValue());
            this.requesteeROText.setBackground(parent.getBackground());
            this.requesteeROText.setEditable(false);
            this.requesteeROText.setToolTipText(requestee.getMetaData().getValue("task.meta.description"));
        } else {
            TaskAttribute requestee;
            this.combo = new CCombo(this.flagComposite, 0x800008);
            toolkit.adapt((Control)this.combo, false, false);
            this.combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            String tooltip = this.getTaskAttribute().getMetaData().getLabel();
            if (tooltip == null) {
                tooltip = this.getDescription();
            }
            if (tooltip != null) {
                this.combo.setToolTipText(tooltip);
            }
            EditorUtil.addScrollListener((CCombo)this.combo);
            this.updateComboWithOptions();
            this.select(this.getValue(), this.getValueLabel());
            if (this.values != null) {
                this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int index = FlagAttributeEditor.this.combo.getSelectionIndex();
                        if (index > -1) {
                            Assert.isNotNull((Object)FlagAttributeEditor.this.values);
                            Assert.isLegal((index >= 0 && index <= FlagAttributeEditor.this.values.length - 1 ? 1 : 0) != 0);
                            try {
                                FlagAttributeEditor.this.suppressRefresh = true;
                                FlagAttributeEditor.this.setValue(FlagAttributeEditor.this.values[index]);
                                FlagAttributeEditor.this.selectionChanged(index);
                            }
                            finally {
                                FlagAttributeEditor.this.suppressRefresh = false;
                            }
                        }
                    }
                });
            }
            if ((requestee = this.getTaskAttribute().getAttribute("requestee")) != null && !requestee.getMetaData().isReadOnly()) {
                final Composite requesteeComposite = new Composite(this.flagComposite, 0);
                GridLayout requesteeLayout = new GridLayout(2, false);
                requesteeLayout.marginHeight = 0;
                requesteeLayout.marginWidth = 0;
                requesteeLayout.horizontalSpacing = 0;
                requesteeComposite.setLayout((Layout)requesteeLayout);
                requesteeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                requesteeComposite.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
                this.requesteeText = toolkit.createText(requesteeComposite, requestee.getValue());
                boolean enabled = "?".equals(this.getValueLabel());
                this.requesteeText.setEnabled(enabled);
                this.requesteeText.setToolTipText(requestee.getMetaData().getValue("task.meta.description"));
                PersonProposalProvider contentProposalProvider = new PersonProposalProvider(null, requestee.getTaskData());
                PersonProposalLabelProvider labelPropsalProvider = new PersonProposalLabelProvider();
                if (contentProposalProvider != null && labelPropsalProvider != null) {
                    ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.requesteeText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)contentProposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
                    adapter.setLabelProvider((ILabelProvider)labelPropsalProvider);
                    adapter.setProposalAcceptanceStyle(2);
                }
                this.selfLink = new ImageHyperlink(requesteeComposite, 524288);
                this.selfLink.setToolTipText(Messages.PersonAttributeEditor_Insert_My_User_Id_Tooltip);
                this.selfLink.setActiveImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_SMALL));
                this.selfLink.setHoverImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_SMALL));
                this.selfLink.setEnabled(enabled);
                this.selfLink.setBackground(this.requesteeText.getBackground());
                this.selfLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        String userName = FlagAttributeEditor.this.getModel().getTaskRepository().getUserName();
                        if (userName != null && userName.length() > 0) {
                            FlagAttributeEditor.this.requesteeText.setText(userName);
                            FlagAttributeEditor.this.setValue(userName);
                        }
                    }
                });
                GridDataFactory.fillDefaults().align(1, 0x1000000).exclude(true).applyTo((Control)this.selfLink);
                MouseTrackAdapter mouseListener = new MouseTrackAdapter(){
                    int version = 0;

                    public void mouseEnter(MouseEvent e) {
                        ((GridData)((FlagAttributeEditor)FlagAttributeEditor.this).selfLink.getLayoutData()).exclude = false;
                        requesteeComposite.layout();
                        FlagAttributeEditor.this.selfLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_SMALL));
                        FlagAttributeEditor.this.selfLink.redraw();
                        ++this.version;
                    }

                    public void mouseExit(MouseEvent e) {
                        final int lastVersion = this.version;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (version != lastVersion || FlagAttributeEditor.this.selfLink.isDisposed()) {
                                    return;
                                }
                                FlagAttributeEditor.this.selfLink.setImage(null);
                                FlagAttributeEditor.this.selfLink.redraw();
                                ((GridData)((FlagAttributeEditor)(this).FlagAttributeEditor.this).selfLink.getLayoutData()).exclude = true;
                                requesteeComposite.layout();
                            }
                        });
                    }
                };
                this.requesteeText.addMouseTrackListener((MouseTrackListener)mouseListener);
                this.selfLink.addMouseTrackListener((MouseTrackListener)mouseListener);
                GridData requesteeData = new GridData(4, 0x1000000, true, false);
                this.requesteeText.setLayoutData((Object)requesteeData);
                this.requesteeText.setFont(EditorUtil.TEXT_FONT);
                this.requesteeText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
                this.requesteeText.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        try {
                            FlagAttributeEditor.this.suppressRefresh = true;
                            FlagAttributeEditor.this.setRequestee(FlagAttributeEditor.this.requesteeText.getText());
                        }
                        finally {
                            FlagAttributeEditor.this.suppressRefresh = false;
                        }
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                this.requesteeText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        try {
                            FlagAttributeEditor.this.suppressRefresh = true;
                            FlagAttributeEditor.this.setRequestee(FlagAttributeEditor.this.requesteeText.getText());
                        }
                        finally {
                            FlagAttributeEditor.this.suppressRefresh = false;
                        }
                    }
                });
                toolkit.adapt((Control)this.requesteeText, false, false);
            }
        }
        toolkit.paintBordersFor(this.flagComposite);
        this.setControl((Control)this.flagComposite);
    }

    private void updateComboWithOptions() {
        Map labelByValue = this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()).getOptions();
        if (labelByValue != null) {
            this.combo.removeAll();
            String[] stringArray = this.values = labelByValue.keySet().toArray(new String[0]);
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.combo.add((String)labelByValue.get(value));
                ++n2;
            }
        }
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()));
    }

    public String getValueLabel() {
        return this.getAttributeMapper().getValueLabel(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()));
    }

    private void select(String value, String label) {
        if (this.values != null) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.combo.setText(label);
        }
    }

    public void setRequestee(String value) {
        TaskAttribute requestee = this.getTaskAttribute().getAttribute("requestee");
        if (requestee != null && !requestee.getValue().equals(value)) {
            this.getAttributeMapper().setValue(requestee, value);
            this.attributeChanged();
        }
    }

    public void setValue(String value) {
        this.getAttributeMapper().setValue(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()), value);
        this.attributeChanged();
    }

    public String getLabel() {
        String setterValue;
        String label = this.getAttributeMapper().getLabel(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()));
        if (label != null) {
            label.replace("&", "&&");
        } else {
            label = "";
        }
        TaskAttribute setter = this.getTaskAttribute().getAttribute("setter");
        if (setter != null && (setterValue = setter.getValue()) != null && !setterValue.equals("")) {
            if (setterValue.indexOf("@") > -1) {
                setterValue = setterValue.substring(0, setterValue.indexOf("@"));
            }
            label = String.valueOf(setterValue) + ": " + label;
        }
        return label;
    }

    public void refresh() {
        TaskAttribute requestee;
        if (this.flagText != null && !this.flagText.isDisposed()) {
            this.flagText.setText(this.getValueLabel());
        }
        if (this.combo != null && !this.combo.isDisposed()) {
            this.updateComboWithOptions();
            this.select(this.getValue(), this.getValueLabel());
            if (this.combo.getSelectionIndex() >= 0) {
                this.selectionChanged(this.combo.getSelectionIndex());
            }
        }
        if ((requestee = this.getTaskAttribute().getAttribute("requestee")) != null) {
            if (this.requesteeROText != null && !this.requesteeROText.isDisposed()) {
                this.requesteeROText.setText(requestee.getValue());
            }
            if (this.requesteeText != null && !this.requesteeText.isDisposed()) {
                this.requesteeText.setText(requestee.getValue());
            }
        }
        this.updateLabel();
        if (this.flagComposite != null && !this.flagComposite.isDisposed()) {
            this.flagComposite.layout();
        }
    }

    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }

    private void selectionChanged(int index) {
        if (this.requesteeText != null) {
            this.requesteeText.setEnabled(this.values[index].equals("?"));
            this.selfLink.setEnabled(this.values[index].equals("?"));
        }
    }
}

