/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrationUi;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrationWizard;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrator;
import org.eclipse.mylyn.internal.tasks.ui.migrator.DefaultTasksState;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TasksState;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ConnectorMigrationWizardTest {
    private ConnectorMigrationWizard wizard;
    private final ConnectorMigrationUi migrationUi = (ConnectorMigrationUi)Mockito.spy((Object)new ConnectorMigrationUi(TaskListView.getFromActivePerspective(), TasksUiPlugin.getBackupManager(), (TasksState)new DefaultTasksState()));
    private ConnectorMigrator migrator;

    @Before
    public void setUp() {
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).warnOfValidationFailure((List)Matchers.any(List.class));
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).notifyMigrationComplete();
        this.createMigrator((Map<String, String>)ImmutableMap.of((Object)"mock", (Object)"mock.new"));
    }

    @Test
    public void addPages() {
        this.createWizard(new ConnectorMigrationWizard(this.migrator));
        Assert.assertEquals((long)2L, (long)this.wizard.getPageCount());
    }

    @Test
    public void firstPage() {
        IWizardContainer container = this.createWizard(new ConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        Assert.assertEquals((Object)"End of Connector Support", (Object)firstPage.getTitle());
        Assert.assertEquals((Object)"Support is ending for some connectors, but replacement connectors are installed. This wizard will help you migrate your configuration and data to the new connectors.", (Object)firstPage.getMessage());
        Assert.assertTrue((boolean)(firstPage.getControl() instanceof Composite));
        Composite control = (Composite)firstPage.getControl();
        Assert.assertEquals((long)1L, (long)control.getChildren().length);
        Assert.assertTrue((boolean)(control.getChildren()[0] instanceof Link));
    }

    @Test
    public void secondPage() {
        IWizardContainer container = this.createWizard(new ConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        IWizardPage secondPage = firstPage.getNextPage();
        Assert.assertEquals((Object)"Select Connectors", (Object)secondPage.getTitle());
        Assert.assertEquals((Object)"Select the connectors to migrate. Your task list and repositories will be backed up before migration; you can undo the migration by selecting \"Restore Tasks from History\" in the Task List view menu and choosing the connector-migration-*.zip file stored in <workspace>/.metadata/.mylyn/backup.", (Object)secondPage.getDescription());
        Assert.assertTrue((boolean)(secondPage.getControl() instanceof Composite));
        Composite control = (Composite)secondPage.getControl();
        Assert.assertEquals((long)1L, (long)control.getChildren().length);
        Assert.assertTrue((boolean)(control.getChildren()[0] instanceof Tree));
    }

    @Test
    public void performFinishAfterConnectorsSelected() throws InvocationTargetException, InterruptedException, IOException {
        this.createMigrator((Map<String, String>)ImmutableMap.of((Object)"foo", (Object)"foo.new", (Object)"bar", (Object)"bar.new", (Object)"baz", (Object)"baz.new"));
        IWizardContainer container = this.createWizard(new TestConnectorMigrationWizard(this.migrator));
        this.spinEventLoop();
        this.wizard.performFinish();
        ((IWizardContainer)Mockito.verify((Object)container)).run(Matchers.eq((boolean)true), Matchers.eq((boolean)true), (IRunnableWithProgress)Matchers.any(IRunnableWithProgress.class));
        ((ConnectorMigrator)Mockito.verify((Object)this.migrator)).setConnectorsToMigrate((List)Matchers.eq((Object)ImmutableList.of((Object)"foo", (Object)"bar")));
        ((ConnectorMigrator)Mockito.verify((Object)this.migrator)).migrateConnectors((IProgressMonitor)Matchers.any(IProgressMonitor.class));
    }

    protected void createMigrator(Map<String, String> connectors) {
        TaskRepositoryManager manager = (TaskRepositoryManager)Mockito.spy((Object)new TaskRepositoryManager());
        this.createMigrator(connectors, manager);
    }

    private void createMigrator(Map<String, String> connectors, TaskRepositoryManager manager) {
        DefaultTasksState tasksState = (DefaultTasksState)Mockito.spy((Object)new DefaultTasksState());
        Mockito.when((Object)tasksState.getRepositoryManager()).thenReturn((Object)manager);
        this.migrator = (ConnectorMigrator)Mockito.spy((Object)new ConnectorMigrator(connectors, "", (TasksState)tasksState, this.migrationUi));
    }

    @Test
    public void performFinishNoConnectorsSelectedByDefault() throws InvocationTargetException, InterruptedException, IOException {
        this.createMigrator((Map<String, String>)ImmutableMap.of((Object)"foo", (Object)"foo.new", (Object)"bar", (Object)"bar.new", (Object)"baz", (Object)"baz.new"));
        IWizardContainer container = this.createWizard(new ConnectorMigrationWizard(this.migrator));
        this.wizard.performFinish();
        ((IWizardContainer)Mockito.verify((Object)container)).run(Matchers.eq((boolean)true), Matchers.eq((boolean)true), (IRunnableWithProgress)Matchers.any(IRunnableWithProgress.class));
        ((ConnectorMigrator)Mockito.verify((Object)this.migrator)).setConnectorsToMigrate((List)Matchers.eq((Object)ImmutableList.of()));
        ((ConnectorMigrator)Mockito.verify((Object)this.migrator)).migrateConnectors((IProgressMonitor)Matchers.any(IProgressMonitor.class));
    }

    @Test
    public void performFinishSelectsRelevantConnectors() throws InvocationTargetException, InterruptedException, IOException {
        TaskRepositoryManager manager = (TaskRepositoryManager)Mockito.spy((Object)new TaskRepositoryManager());
        this.createAndAddConnector(manager, "mock", "Mock Connector");
        this.createAndAddConnector(manager, "foo", "Foo Connector");
        this.createAndAddConnector(manager, "bar", "Bar Connector");
        manager.addRepository(new TaskRepository("mock", "http://mock"));
        manager.addRepository(new TaskRepository("bar", "http://bar"));
        this.createMigrator((Map<String, String>)ImmutableMap.of((Object)"foo", (Object)"foo.new", (Object)"bar", (Object)"bar.new", (Object)"mock", (Object)"mock.new"), manager);
        IWizardContainer container = this.createWizard(new ConnectorMigrationWizard(this.migrator));
        this.wizard.performFinish();
        ((IWizardContainer)Mockito.verify((Object)container)).run(Matchers.eq((boolean)true), Matchers.eq((boolean)true), (IRunnableWithProgress)Matchers.any(IRunnableWithProgress.class));
        ((ConnectorMigrator)Mockito.verify((Object)this.migrator)).setConnectorsToMigrate((List)Matchers.eq((Object)ImmutableList.of((Object)"bar", (Object)"mock")));
        ((ConnectorMigrator)Mockito.verify((Object)this.migrator)).migrateConnectors((IProgressMonitor)Matchers.any(IProgressMonitor.class));
    }

    private void createAndAddConnector(TaskRepositoryManager manager, String kind, String label) {
        AbstractRepositoryConnector mockConnector = (AbstractRepositoryConnector)Mockito.mock(AbstractRepositoryConnector.class);
        Mockito.when((Object)mockConnector.getLabel()).thenReturn((Object)label);
        Mockito.when((Object)manager.getRepositoryConnector(kind)).thenReturn((Object)mockConnector);
    }

    @Test
    public void performFinishSetsErrorMessage() throws InvocationTargetException, InterruptedException, IOException {
        IWizardContainer container = this.createWizard(new ConnectorMigrationWizard(this.migrator));
        ((IWizardContainer)Mockito.doThrow((Throwable)new InvocationTargetException(new IOException("Backup failed"))).when((Object)container)).run(((Boolean)Matchers.any(Boolean.class)).booleanValue(), ((Boolean)Matchers.any(Boolean.class)).booleanValue(), (IRunnableWithProgress)Matchers.any(IRunnableWithProgress.class));
        this.wizard.performFinish();
        Assert.assertEquals((Object)"Backup failed", (Object)container.getCurrentPage().getErrorMessage());
    }

    @Test
    public void isPageComplete() throws Exception {
        IWizardContainer container = this.createWizard(new ConnectorMigrationWizard(this.migrator));
        IWizardPage firstPage = container.getCurrentPage();
        IWizardPage secondPage = firstPage.getNextPage();
        Assert.assertTrue((boolean)firstPage.isPageComplete());
        Assert.assertFalse((boolean)secondPage.isPageComplete());
        container.showPage(secondPage);
        Assert.assertTrue((boolean)firstPage.isPageComplete());
        Assert.assertTrue((boolean)secondPage.isPageComplete());
    }

    @Test
    public void createConnectorList() throws Exception {
        CheckboxTreeViewer viewer = new ConnectorMigrationWizard(this.migrator).createConnectorList((Composite)WorkbenchUtil.getShell(), (List)ImmutableList.of((Object)"mock"));
        IRepositoryManager manager = this.migrator.getRepositoryManager();
        Assert.assertEquals((Object)ImmutableList.of((Object)"mock"), (Object)viewer.getInput());
        Assert.assertTrue((boolean)(viewer.getLabelProvider() instanceof LabelProvider));
        Assert.assertEquals((Object)"mock", (Object)((LabelProvider)viewer.getLabelProvider()).getText((Object)"mock"));
        AbstractRepositoryConnector connector = (AbstractRepositoryConnector)Mockito.mock(AbstractRepositoryConnector.class);
        Mockito.when((Object)connector.getLabel()).thenReturn((Object)"My Connector");
        Mockito.when((Object)manager.getRepositoryConnector("mock")).thenReturn((Object)connector);
        manager.addRepository(new TaskRepository("mock", "http://mock"));
        manager.addRepository(new TaskRepository("mock", "http://mock2"));
        Assert.assertEquals((Object)"My Connector (used by 2 repositories)", (Object)((LabelProvider)viewer.getLabelProvider()).getText((Object)"mock"));
    }

    private IWizardContainer createWizard(ConnectorMigrationWizard wiz) {
        this.wizard = (ConnectorMigrationWizard)Mockito.spy((Object)wiz);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)this.wizard);
        dialog.create();
        IWizardContainer container = (IWizardContainer)Mockito.spy((Object)this.wizard.getContainer());
        Mockito.when((Object)this.wizard.getContainer()).thenReturn((Object)container);
        return container;
    }

    private void spinEventLoop() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public class TestConnectorMigrationWizard
    extends ConnectorMigrationWizard {
        private TestConnectorMigrationWizard(ConnectorMigrator migrator) {
            super(migrator);
        }

        protected CheckboxTreeViewer createConnectorList(Composite parent, List<String> kinds) {
            return new CheckboxTreeViewer(parent){
                {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            this.fireCheckStateChanged(null);
                        }
                    });
                }

                public Object[] getCheckedElements() {
                    return new String[]{"foo", "bar"};
                }
            };
        }
    }
}

