/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.context.tasks.ui.ActivityExternalizationParticipant;
import org.eclipse.mylyn.internal.context.tasks.ui.Messages;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.activity.AbstractTaskActivityMonitor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TaskActivityMonitor
extends AbstractTaskActivityMonitor {
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case INTEREST_CHANGED: {
                    List events = TaskActivityMonitor.this.contextManager.getActivityMetaContext().getInteractionHistory();
                    if (events.size() <= 0) break;
                    InteractionEvent interactionEvent = (InteractionEvent)events.get(events.size() - 1);
                    TaskActivityMonitor.this.parseInteractionEvent(interactionEvent, false);
                }
            }
        }
    };
    private static ITaskActivationListener CONTEXT_TASK_ACTIVATION_LISTENER = new ContextTaskActivationListener();
    private final InteractionContextManager contextManager = ContextCorePlugin.getContextManager();
    private TaskActivityManager taskActivityManager;
    private final TaskList taskList = TasksUiPlugin.getTaskList();
    private final List<ITask> activationHistory = new ArrayList<ITask>();
    private ActivityExternalizationParticipant externalizationParticipant;

    public void start(ITaskActivityManager taskActivityManager) {
        this.taskActivityManager = (TaskActivityManager)taskActivityManager;
        taskActivityManager.addActivationListener(CONTEXT_TASK_ACTIVATION_LISTENER);
        this.contextManager.addActivityMetaContextListener(this.CONTEXT_LISTENER);
        ExternalizationManager externalizationManager = TasksUiPlugin.getExternalizationManager();
        ActivityExternalizationParticipant ACTIVITY_EXTERNALIZTAION_PARTICIPANT = new ActivityExternalizationParticipant(externalizationManager);
        externalizationManager.addParticipant((IExternalizationParticipant)ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
        taskActivityManager.addActivityListener((ITaskActivityListener)ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
        this.setExternalizationParticipant(ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
    }

    public boolean parseInteractionEvent(InteractionEvent event, boolean isReloading) {
        block13: {
            AbstractTask activatedTask;
            if (!event.getKind().equals((Object)InteractionEvent.Kind.COMMAND)) break block13;
            if (event.getDelta().equals("activated") && (activatedTask = this.taskList.getTask(event.getStructureHandle())) != null) {
                this.activationHistory.add((ITask)activatedTask);
                return true;
            }
        }
        try {
            if (event.getKind().equals((Object)InteractionEvent.Kind.ATTENTION)) {
                AbstractTask task;
                if (event.getDelta().equals("added") || event.getDelta().equals("add")) {
                    if (event.getDate().getTime() > 0L && event.getEndDate().getTime() > 0L) {
                        if (event.getStructureKind().equals("workingset")) {
                            this.taskActivityManager.addWorkingSetElapsedTime(event.getStructureHandle(), event.getDate(), event.getEndDate());
                            if (!isReloading) {
                                this.externalizationParticipant.setDirty(true);
                                this.externalizationParticipant.elapsedTimeUpdated(null, 0L);
                            }
                        } else {
                            AbstractTask activatedTask = this.taskList.getTask(event.getStructureHandle());
                            if (activatedTask != null) {
                                this.taskActivityManager.addElapsedTime(activatedTask, event.getDate(), event.getEndDate());
                            }
                        }
                    }
                } else if (event.getDelta().equals("removed") && (task = this.taskList.getTask(event.getStructureHandle())) != null) {
                    this.taskActivityManager.removeElapsedTime((ITask)task, event.getDate(), event.getEndDate());
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error parsing interaction event", t));
        }
        return false;
    }

    public void stop() {
        this.contextManager.removeActivityMetaContextListener(this.CONTEXT_LISTENER);
    }

    public void reloadActivityTime() {
        this.activationHistory.clear();
        this.taskActivityManager.clearActivity();
        List events = this.contextManager.getActivityMetaContext().getInteractionHistory();
        for (InteractionEvent event : events) {
            this.parseInteractionEvent(event, true);
        }
    }

    public void setExternalizationParticipant(ActivityExternalizationParticipant participant) {
        this.externalizationParticipant = participant;
    }

    public List<ITask> getActivationHistory() {
        return new ArrayList<ITask>(this.activationHistory);
    }

    public void loadActivityTime() {
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        this.reloadActivityTime();
    }

    public boolean isEnabled() {
        return true;
    }

    public static class ContextTaskActivationListener
    extends TaskActivationAdapter {
        public boolean canDeactivateTask(ITask task) {
            TaskEditor editor;
            TaskEditorInput input;
            IWorkbenchPart part;
            List<IEditorReference> dirtyRefs = this.findDirtyEditors();
            if (dirtyRefs.size() == 1 && (part = dirtyRefs.get(0).getPart(false)) instanceof TaskEditor && (input = (editor = (TaskEditor)part).getTaskEditorInput()) != null && task.equals(input.getTask()) && editor.equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor())) {
                return true;
            }
            if (!dirtyRefs.isEmpty()) {
                int returnCode = this.openTaskDeactivationDialog(dirtyRefs);
                if (returnCode == 0) {
                    this.saveEditors(dirtyRefs);
                } else if (returnCode == 2) {
                    this.activateEditors(dirtyRefs);
                    return false;
                }
            }
            return true;
        }

        private void saveEditors(List<IEditorReference> refs) {
            for (IEditorReference ref : refs) {
                IEditorPart editor = ref.getEditor(false);
                if (editor == null) continue;
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }

        private void activateEditors(List<IEditorReference> refs) {
            for (IEditorReference ref : refs) {
                IWorkbenchPart part = ref.getPart(true);
                if (part == null) continue;
                ref.getPage().activate(part);
            }
        }

        public int openTaskDeactivationDialog(List<IEditorReference> dirtyRefs) {
            String editors = Joiner.on((char)'\n').join(Iterables.transform(dirtyRefs, (Function)new Function<IEditorReference, String>(){

                public String apply(IEditorReference ref) {
                    return ref.getTitle();
                }
            }));
            return new MessageDialog(WorkbenchUtil.getShell(), Messages.TaskActivityMonitor_Task_Deactivation, null, NLS.bind((String)Messages.TaskActivityMonitor_Task_Deactivation_Message, (Object)editors), 3, new String[]{Messages.TaskActivityMonitor_Deactivate_Task_and_Save_All, Messages.TaskActivityMonitor_Deactivate_and_Save_Some, IDialogConstants.CANCEL_LABEL}, 1).open();
        }

        public List<IEditorReference> findDirtyEditors() {
            ArrayList<IEditorReference> dirtyRefs = new ArrayList<IEditorReference>();
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
                int n3 = iEditorReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference ref = iEditorReferenceArray[n4];
                    if (ref.isDirty()) {
                        dirtyRefs.add(ref);
                    }
                    ++n4;
                }
                ++n2;
            }
            return dirtyRefs;
        }

        public void preTaskActivated(ITask task) {
            ContextUiPlugin.getDefault();
        }

        public void taskActivated(ITask task) {
            ContextCore.getContextManager().activateContext(task.getHandleIdentifier());
        }

        public void taskDeactivated(ITask task) {
            ContextCore.getContextManager().deactivateContext(task.getHandleIdentifier());
        }
    }
}

