/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApprovalDetail {
    public static final Comparator<ApprovalDetail> SORT = new Comparator<ApprovalDetail>(){

        @Override
        public int compare(ApprovalDetail o1, ApprovalDetail o2) {
            int cmp = o2.hasNonZero - o1.hasNonZero;
            if (cmp != 0) {
                return cmp;
            }
            return o1.sortOrder.compareTo(o2.sortOrder);
        }
    };
    static final Timestamp EG_0 = new Timestamp(0L);
    static final Timestamp EG_D = new Timestamp(Long.MAX_VALUE);
    protected Account.Id account;
    protected List<PatchSetApproval> approvals;
    protected boolean canRemove;
    private transient int hasNonZero;
    private transient Timestamp sortOrder = EG_D;

    protected ApprovalDetail() {
    }

    public ApprovalDetail(Account.Id id) {
        this.account = id;
        this.approvals = new ArrayList<PatchSetApproval>();
    }

    public Account.Id getAccount() {
        return this.account;
    }

    public boolean canRemove() {
        return this.canRemove;
    }

    public void setCanRemove(boolean removeable) {
        this.canRemove = removeable;
    }

    public Map<ApprovalCategory.Id, PatchSetApproval> getApprovalMap() {
        HashMap<ApprovalCategory.Id, PatchSetApproval> r = new HashMap<ApprovalCategory.Id, PatchSetApproval>();
        for (PatchSetApproval ca : this.approvals) {
            r.put(ca.getCategoryId(), ca);
        }
        return r;
    }

    public void sortFirst() {
        this.hasNonZero = 1;
        this.sortOrder = EG_0;
    }

    public void add(PatchSetApproval ca) {
        this.approvals.add(ca);
        Timestamp g = ca.getGranted();
        if (g != null && g.compareTo(this.sortOrder) < 0) {
            this.sortOrder = g;
        }
        if (ca.getValue() != 0) {
            this.hasNonZero = 1;
        }
    }
}

