/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client.impl.messages;

import com.google.gwt.requestfactory.client.impl.EntityCodex;
import com.google.gwt.requestfactory.shared.ValueCodex;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestData {
    private final String operation;
    private final Object[] parameters;
    private final Set<String> propertyRefs;

    public RequestData(String operation, Object[] parameters, Set<String> propertyRefs) {
        this.operation = operation;
        this.parameters = parameters;
        this.propertyRefs = propertyRefs;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Map<String, String> getRequestMap(String contentData) {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("operation", ValueCodex.encodeForJsonPayload(this.operation));
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                Object value = this.parameters[i];
                requestMap.put("param" + i, EntityCodex.encodeForJsonPayload(value));
            }
        }
        if (contentData != null) {
            requestMap.put("contentData", ValueCodex.encodeForJsonPayload(contentData));
        }
        if (this.propertyRefs != null && !this.propertyRefs.isEmpty()) {
            StringBuffer props = new StringBuffer();
            Iterator<String> propIt = this.propertyRefs.iterator();
            while (propIt.hasNext()) {
                props.append(propIt.next());
                if (!propIt.hasNext()) continue;
                props.append(",");
            }
            requestMap.put("propertyRefs", ValueCodex.encodeForJsonPayload(props.toString()));
        }
        return requestMap;
    }
}

