/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.notifications.tests.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.notifications.core.IFilterable;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedEntry;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class NotificationEnvironmentTest
extends TestCase {
    private NotificationEnvironment environment;
    Set<String> installedFeatures;

    protected void setUp() throws Exception {
        this.installedFeatures = new HashSet<String>();
        System.setProperty("EnvironmentTest", "2");
        this.environment = new NotificationEnvironment(){

            public Set<String> getInstalledFeatures(IProgressMonitor monitor) {
                return NotificationEnvironmentTest.this.installedFeatures;
            }
        };
    }

    public void testGetRuntimeVersion() {
        Version runtimeVersion = this.environment.getRuntimeVersion();
        NotificationEnvironmentTest.assertTrue((String)("Expected value between 11.0-18.0, got " + runtimeVersion), (boolean)new VersionRange("[11.0.0,18.0.0)").isIncluded(runtimeVersion));
    }

    public void testGetPlatformVersion() {
        Version platformVersion = this.environment.getPlatformVersion();
        if (Platform.isRunning()) {
            NotificationEnvironmentTest.assertTrue((String)("Expected value between 3.3-5.0, got " + platformVersion), (boolean)new VersionRange("[3.3.0,5.0.0)").isIncluded(platformVersion));
        } else {
            NotificationEnvironmentTest.assertEquals((Object)Version.emptyVersion, (Object)platformVersion);
        }
    }

    public void testGetFrameworkVersion() {
        Version frameworkVersion = this.environment.getFrameworkVersion();
        if (Platform.isRunning()) {
            NotificationEnvironmentTest.assertTrue((String)("Expected value > 3.6, got " + frameworkVersion), (boolean)new VersionRange("3.6.0").isIncluded(frameworkVersion));
        } else {
            NotificationEnvironmentTest.assertEquals((Object)CoreUtil.getFrameworkVersion(), (Object)frameworkVersion);
        }
    }

    public void testMatchesFrameworkVersion() {
        HashMap<String, String> values = new HashMap<String, String>();
        NotificationEnvironmentTest.assertTrue((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
        values.put("frameworkVersion", "[1.0.0,2.0.0)");
        NotificationEnvironmentTest.assertFalse((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
        values.put("frameworkVersion", "[0.0.0,10.0.0)");
        NotificationEnvironmentTest.assertTrue((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
    }

    public void testMatchesRequires() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("requires", "org.eclipse.mylyn");
        NotificationEnvironmentTest.assertFalse((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
        this.installedFeatures.add("org.eclipse.mylyn");
        NotificationEnvironmentTest.assertTrue((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
    }

    public void testMatchesConflicts() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("conflicts", "org.eclipse.mylyn");
        NotificationEnvironmentTest.assertTrue((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
        this.installedFeatures.add("org.eclipse.mylyn");
        NotificationEnvironmentTest.assertFalse((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
    }

    public void testMatchesRequiresConflicts() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("requires", "org.eclipse.mylyn");
        values.put("conflicts", "org.eclipse.cdt");
        NotificationEnvironmentTest.assertFalse((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
        this.installedFeatures.add("org.eclipse.mylyn");
        NotificationEnvironmentTest.assertTrue((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
        this.installedFeatures.add("org.eclipse.cdt");
        NotificationEnvironmentTest.assertFalse((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
    }

    public void testMatchesFilter() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("filter", "(EnvironmentTest<=1)");
        NotificationEnvironmentTest.assertFalse((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
        values.put("filter", "(EnvironmentTest=2)");
        NotificationEnvironmentTest.assertTrue((boolean)this.environment.matches((IAdaptable)new StubEntry(values), null));
    }

    private class StubEntry
    extends FeedEntry
    implements IAdaptable,
    IFilterable {
        private final Map<String, String> map;

        public StubEntry(Map<String, String> map) {
            super("eventId");
            this.map = map;
        }

        public List<String> getFilters(String key) {
            String value = this.getFilter(key);
            if (value != null) {
                return Collections.singletonList(value);
            }
            return Collections.emptyList();
        }

        public String getFilter(String key) {
            return this.map.get(key);
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IFilterable.class) {
                return this;
            }
            return null;
        }
    }
}

