/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.notifications.tests.feed;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedEntry;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedReader;

public class FeedReaderTest
extends TestCase {
    private FeedReader reader;
    private NotificationEnvironment environment;

    protected void setUp() throws Exception {
        this.environment = new NotificationEnvironment(){

            public Set<String> getInstalledFeatures(IProgressMonitor monitor) {
                return Collections.singleton("org.eclipse.mylyn");
            }
        };
        this.reader = new FeedReader("eventId", this.environment);
    }

    public void testParse() throws Exception {
        FeedReaderTest.assertEquals((Object)Status.OK_STATUS, (Object)this.reader.parse(CommonTestUtil.getResource(FeedReaderTest.class, (String)"testdata/FeedReaderTest/update1.xml"), null));
        FeedReaderTest.assertEquals((int)2, (int)this.reader.getEntries().size());
        Collections.sort(this.reader.getEntries());
        FeedEntry entry = (FeedEntry)this.reader.getEntries().get(0);
        FeedReaderTest.assertEquals((String)"New Connectors", (String)entry.getTitle());
        FeedReaderTest.assertEquals((String)"[0.0.0,4.0.0)", (String)entry.getFilter("frameworkVersion"));
        FeedReaderTest.assertEquals((String)"New connectors are now available. <a href=\"#discovery\">Show connectors</a>.", (String)entry.getDescription());
        entry = (FeedEntry)this.reader.getEntries().get(1);
        FeedReaderTest.assertEquals((String)"Mylyn 3.6 is now available", (String)entry.getTitle());
        FeedReaderTest.assertEquals((String)"1.5.0", (String)entry.getFilter("runtimeVersion"));
        FeedReaderTest.assertEquals((String)"Mylyn 3.7 is now available. <a href=\"http://eclipse.org/mylyn/new/\">See New and Noteworthy</a> for details.", (String)entry.getDescription());
    }

    public void testParseWithGermanLocale() throws Exception {
        Locale locale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.GERMAN);
            FeedReaderTest.assertEquals((Object)Status.OK_STATUS, (Object)this.reader.parse(CommonTestUtil.getResource(FeedReaderTest.class, (String)"testdata/FeedReaderTest/update2.xml"), null));
            FeedReaderTest.assertEquals((int)1, (int)this.reader.getEntries().size());
            Collections.sort(this.reader.getEntries());
            FeedEntry entry = (FeedEntry)this.reader.getEntries().get(0);
            FeedReaderTest.assertEquals((String)"Mylyn Update", (String)entry.getTitle());
            FeedReaderTest.assertEquals((long)1380758400000L, (long)entry.getDate().getTime());
        }
        finally {
            Locale.setDefault(locale);
        }
    }
}

