/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.notifications.tests.feed;

import java.io.PrintStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.notifications.feed.ServiceMessageManager;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;
import org.junit.Before;

public class ServiceMessageManagerTest
extends TestCase {
    private static final String MESSAGE_XML_URL = "http://mylyn.org/message.xml";

    @Before
    public void setUp() {
        if (CommonTestUtil.fixProxyConfiguration()) {
            CommonTestUtil.dumpSystemInfo((PrintStream)System.err);
        }
    }

    public void testRetrievingMessage() throws Exception {
        ServiceMessageManager manager = new ServiceMessageManager(MESSAGE_XML_URL, "", "", 0L);
        int status = manager.refresh((IProgressMonitor)new NullProgressMonitor());
        ServiceMessageManagerTest.assertEquals((int)200, (int)status);
        ServiceMessageManagerTest.assertEquals((int)2, (int)manager.getServiceMessages().size());
        ServiceMessage message = (ServiceMessage)manager.getServiceMessages().get(1);
        ServiceMessageManagerTest.assertEquals((String)"1", (String)message.getId());
        ServiceMessageManagerTest.assertEquals((String)"140 character description here....", (String)message.getDescription());
        ServiceMessageManagerTest.assertEquals((String)"Mylyn 3.4 now available!", (String)message.getTitle());
        ServiceMessageManagerTest.assertEquals((String)"http://eclipse.org/mylyn/downloads", (String)message.getUrl());
        ServiceMessageManagerTest.assertEquals((String)"dialog_messasge_info_image", (String)message.getImage());
    }

    public void testETag() throws Exception {
        ServiceMessageManager manager = new ServiceMessageManager(MESSAGE_XML_URL, "", "", 0L);
        int status = manager.refresh((IProgressMonitor)new NullProgressMonitor());
        ServiceMessageManagerTest.assertEquals((int)200, (int)status);
        ServiceMessage message = (ServiceMessage)manager.getServiceMessages().get(0);
        ServiceMessageManagerTest.assertNotNull((Object)message.getLastModified());
        ServiceMessageManagerTest.assertNotNull((Object)message.getETag());
        status = manager.refresh((IProgressMonitor)new NullProgressMonitor());
        ServiceMessageManagerTest.assertEquals((int)304, (int)status);
    }
}

