/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.commons.core.storage.ICommonStorable;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.tasks.ui.ContextMementoMigrator;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskContextStore;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.state.ContextState;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.ui.IMemento;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ContextMementoMigratorTest
extends TestCase {
    private static final String ID_PLANNING_PERSPECTIVE = "org.eclipse.mylyn.tasks.ui.perspectives.planning";
    private TaskTask task;
    private ICommonStorable storable;

    @Before
    public void setUp() throws Exception {
        this.task = TaskTestUtil.createMockTask((String)"1");
        TasksUiPlugin.getTaskList().addTask((ITask)this.task);
        this.storable = ((TaskContextStore)TasksUiPlugin.getContextStore()).getStorable((ITask)this.task);
        this.storable.delete("context-state.xml");
    }

    @After
    public void tearDown() {
        if (this.storable != null) {
            this.storable.release();
        }
    }

    @Test
    public void testMigratePreferencesDelete() throws Exception {
        ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ui.perspectives.task." + this.task.getHandleIdentifier(), ID_PLANNING_PERSPECTIVE);
        ContextMementoMigrator migrator = new ContextMementoMigrator(ContextUiPlugin.getDefault().getStateManager());
        migrator.setDeleteOldDataEnabled(true);
        IStatus status = migrator.migrateContextMementos(SubMonitor.convert(null));
        ContextMementoMigratorTest.assertEquals((int)0, (int)status.getSeverity());
        ContextMementoMigratorTest.assertEquals((String)"", (String)ContextUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.ui.perspectives.task." + this.task.getHandleIdentifier()));
    }

    @Test
    public void testMigratePreferences() throws Exception {
        ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ui.perspectives.task." + this.task.getHandleIdentifier(), ID_PLANNING_PERSPECTIVE);
        IStatus status = new ContextMementoMigrator(ContextUiPlugin.getDefault().getStateManager()).migrateContextMementos(SubMonitor.convert(null));
        ContextMementoMigratorTest.assertEquals((int)0, (int)status.getSeverity());
        InteractionContext context = new InteractionContext(this.task.getHandleIdentifier(), ContextCore.getCommonContextScaling());
        ContextState state = ContextUiPlugin.getDefault().getStateManager().read((IInteractionContext)context, this.storable.read("context-state.xml", null));
        IMemento memento = state.getMemento("org.eclipse.mylyn.context.ui.perspectives");
        ContextMementoMigratorTest.assertNotNull((Object)memento);
        ContextMementoMigratorTest.assertEquals((String)ID_PLANNING_PERSPECTIVE, (String)memento.getString("activeId"));
        ContextMementoMigratorTest.assertEquals((String)ID_PLANNING_PERSPECTIVE, (String)ContextUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.ui.perspectives.task." + this.task.getHandleIdentifier()));
    }
}

