/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tasks.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.mylyn.commons.sdk.util.ResourceTestUtil;
import org.eclipse.mylyn.commons.sdk.util.TestProject;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.ui.ContextAwareEditorInput;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EditorRestoreTest
extends TestCase {
    private IEditorDescriptor editor;
    private IFile fileA;
    private IFile fileB;
    private IFile fileC;
    private IWorkbenchPage page;
    Comparator<IEditorReference> comparator = new Comparator<IEditorReference>(){

        @Override
        public int compare(IEditorReference o1, IEditorReference o2) {
            try {
                return o1.getEditorInput().getName().compareTo(o2.getEditorInput().getName());
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private TestProject project;
    private LocalTask task;

    @Test
    public void testCloseAllOnDeactivate() throws Exception {
        IEditorInput[] inputs = new IEditorInput[]{new FileEditorInput(this.fileA)};
        IEditorReference[] refs = this.openEditors(inputs);
        EditorRestoreTest.assertEquals(this.asInputList(refs), this.asInputList(this.page.getEditorReferences()));
        ContextCore.getContextManager().deactivateContext(this.task.getHandleIdentifier());
        EditorRestoreTest.assertEquals(Collections.emptyList(), this.asList(this.page.getEditorReferences()));
    }

    @Test
    public void testActivationPreservesActiveTaskEditor() throws Exception {
        ContextCore.getContextManager().deleteContext(this.task.getHandleIdentifier());
        ContextCore.getContextManager().deactivateContext(this.task.getHandleIdentifier());
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
        TaskEditorInput input = new TaskEditorInput(repository, (ITask)this.task);
        TasksUiUtil.openTask((ITask)this.task);
        EditorRestoreTest.assertEquals(Arrays.asList(input), this.asInputList(this.page.getEditorReferences()));
        ContextCore.getContextManager().activateContext(this.task.getHandleIdentifier());
        EditorRestoreTest.assertEquals(Arrays.asList(input), this.asInputList(this.page.getEditorReferences()));
    }

    @Test
    public void testCloseAllRestore() throws Exception {
        IEditorInput[] inputs = new IEditorInput[]{new FileEditorInput(this.fileA), new FileEditorInput(this.fileB), new FileEditorInput(this.fileC)};
        IEditorReference[] refs = this.openEditors(inputs);
        EditorRestoreTest.assertEquals(this.asInputList(refs), this.asInputList(this.page.getEditorReferences()));
        ContextCore.getContextManager().deactivateContext(this.task.getHandleIdentifier());
        EditorRestoreTest.assertEquals(Collections.emptyList(), this.asList(this.page.getEditorReferences()));
        ContextCore.getContextManager().activateContext(this.task.getHandleIdentifier());
        EditorRestoreTest.assertEquals(Arrays.asList(inputs), this.asInputList(this.page.getEditorReferences()));
    }

    @Test
    public void testCloseAllRestoreContextAwareEditor() throws Exception {
        FileEditorInput input = new FileEditorInput(this.fileA);
        IEditorInput[] inputs = new IEditorInput[]{input, new FileEditorInput(this.fileB){

            public Object getAdapter(Class adapter) {
                if (adapter == ContextAwareEditorInput.class) {
                    return new ContextAwareEditorInput(){

                        public boolean forceClose(String contextHandle) {
                            return true;
                        }
                    };
                }
                return super.getAdapter(adapter);
            }
        }};
        IEditorReference[] refs = this.openEditors(inputs);
        EditorRestoreTest.assertEquals(this.asInputList(refs), this.asInputList(this.page.getEditorReferences()));
        ContextCore.getContextManager().deactivateContext(this.task.getHandleIdentifier());
        EditorRestoreTest.assertEquals(Collections.emptyList(), this.asList(this.page.getEditorReferences()));
        ContextCore.getContextManager().activateContext(this.task.getHandleIdentifier());
        EditorRestoreTest.assertEquals((Object)input, (Object)this.page.getEditorReferences()[0].getEditorInput());
    }

    private List<IEditorInput> asInputList(IEditorReference[] input) throws Exception {
        List<IEditorReference> refs = this.asList(input);
        ArrayList<IEditorInput> list = new ArrayList<IEditorInput>();
        for (IEditorReference ref : refs) {
            list.add(ref.getEditorInput());
        }
        return list;
    }

    private List<IEditorReference> asList(IEditorReference[] refs) {
        ArrayList<IEditorReference> list = new ArrayList<IEditorReference>(Arrays.asList(refs));
        Collections.sort(list, this.comparator);
        return list;
    }

    private IEditorReference[] openEditors(IEditorInput[] inputs) throws Exception {
        IEditorReference[] refs;
        Object[] ids = new String[inputs.length];
        Arrays.fill(ids, this.editor.getId());
        IEditorReference[] iEditorReferenceArray = refs = this.page.openEditors(inputs, (String[])ids, 0);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            ref.getEditor(true);
            ++n2;
        }
        return refs;
    }

    @Before
    public void setUp() throws Exception {
        this.task = new LocalTask(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getName());
        TasksUiPlugin.getTaskList().addTask((ITask)this.task);
        ContextCore.getContextManager().activateContext(this.task.getHandleIdentifier());
        this.project = new TestProject(((Object)((Object)this)).getClass().getName());
        this.fileA = this.project.getProject().getFile("a.txt");
        this.fileA.create((InputStream)new ByteArrayInputStream("abc".getBytes()), false, null);
        this.fileB = this.project.getProject().getFile("b.txt");
        this.fileB.create((InputStream)new ByteArrayInputStream("abc".getBytes()), false, null);
        this.fileC = this.project.getProject().getFile("c.txt");
        this.fileC.create((InputStream)new ByteArrayInputStream("abc".getBytes()), false, null);
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)this.fileB);
        InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.EDIT, bridge.getContentType(), bridge.getHandleIdentifier((Object)this.fileB), "part");
        ContextCore.getContextManager().processInteractionEvent(selectionEvent);
        selectionEvent = new InteractionEvent(InteractionEvent.Kind.EDIT, bridge.getContentType(), bridge.getHandleIdentifier((Object)this.fileC), "part");
        ContextCore.getContextManager().processInteractionEvent(selectionEvent);
        this.editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(this.fileA.getName());
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.page.closeAllEditors(false);
        EditorRestoreTest.assertTrue((boolean)ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage"));
        EditorRestoreTest.assertTrue((boolean)ContextUiPlugin.getEditorStateParticipant().isEnabled());
    }

    @After
    public void tearDown() throws Exception {
        ContextCore.getContextManager().deactivateContext(this.task.getHandleIdentifier());
        TasksUiPlugin.getTaskList().deleteTask((ITask)this.task);
        this.page.closeAllEditors(false);
        ResourceTestUtil.deleteProject((IProject)this.project.getProject());
    }
}

