/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskContextStore;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TaskContextStoreTest
extends TestCase {
    private TaskContextStore store;
    private TaskList taskList;
    private TaskActivityManager activityManager;

    @Before
    public void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        TasksUiPlugin.getTaskActivityManager().clear();
        ContextCorePlugin.getContextManager().resetActivityMetaContext();
        this.store = (TaskContextStore)TasksUiPlugin.getContextStore();
        this.taskList = TasksUiPlugin.getTaskList();
        this.activityManager = TasksUiPlugin.getTaskActivityManager();
    }

    @After
    public void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        TasksUiPlugin.getTaskActivityManager().clear();
    }

    @Test
    public void testClearContextActivity() {
        LocalTask task = new LocalTask("clearContext", "clearContext");
        this.taskList.addTask((ITask)task);
        TaskContextStoreTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task));
        this.addTime((ITask)task, 60000L);
        TaskContextStoreTest.assertEquals((long)60000L, (long)this.activityManager.getElapsedTime((ITask)task));
        this.store.clearContext((ITask)task);
        TaskContextStoreTest.assertEquals((String)"Expected activity to remain", (long)60000L, (long)this.activityManager.getElapsedTime((ITask)task));
    }

    @Test
    public void testCopyContextActivity() {
        LocalTask sourceTask = new LocalTask("sourceTask", "sourceTask");
        this.taskList.addTask((ITask)sourceTask);
        LocalTask targetTask = new LocalTask("targetTask", "targetTask");
        this.taskList.addTask((ITask)targetTask);
        this.addTime((ITask)sourceTask, 60000L);
        TaskContextStoreTest.assertEquals((long)60000L, (long)this.activityManager.getElapsedTime((ITask)sourceTask));
        this.store.copyContext((ITask)sourceTask, (ITask)targetTask);
        TaskContextStoreTest.assertEquals((String)"Expected activity to remain", (long)60000L, (long)this.activityManager.getElapsedTime((ITask)sourceTask));
        TaskContextStoreTest.assertEquals((String)"Expected activity not be copied", (long)0L, (long)this.activityManager.getElapsedTime((ITask)targetTask));
    }

    @Test
    public void testDeleteContextActivity() {
        LocalTask task = new LocalTask("clearContext", "clearContext");
        this.taskList.addTask((ITask)task);
        TaskContextStoreTest.assertEquals((long)0L, (long)this.activityManager.getElapsedTime((ITask)task));
        this.addTime((ITask)task, 60000L);
        TaskContextStoreTest.assertEquals((long)60000L, (long)this.activityManager.getElapsedTime((ITask)task));
        this.store.deleteContext((ITask)task);
        TaskContextStoreTest.assertEquals((long)60000L, (long)this.activityManager.getElapsedTime((ITask)task));
    }

    @Test
    public void testMergeContextActivity() {
        LocalTask sourceTask = new LocalTask("sourceTask", "sourceTask");
        this.taskList.addTask((ITask)sourceTask);
        LocalTask targetTask = new LocalTask("targetTask", "targetTask");
        this.taskList.addTask((ITask)targetTask);
        this.addTime((ITask)sourceTask, 60000L);
        TaskContextStoreTest.assertEquals((long)60000L, (long)this.activityManager.getElapsedTime((ITask)sourceTask));
        this.store.mergeContext((ITask)sourceTask, (ITask)targetTask);
        TaskContextStoreTest.assertEquals((String)"Expected activity to remain", (long)60000L, (long)this.activityManager.getElapsedTime((ITask)sourceTask));
        TaskContextStoreTest.assertEquals((String)"Expected activity not be copied", (long)0L, (long)this.activityManager.getElapsedTime((ITask)targetTask));
    }

    @Test
    public void testMoveContextActivity() {
        LocalTask sourceTask = new LocalTask("sourceTask", "sourceTask");
        this.taskList.addTask((ITask)sourceTask);
        LocalTask targetTask = new LocalTask("targetTask", "targetTask");
        this.taskList.addTask((ITask)targetTask);
        this.addTime((ITask)sourceTask, 60000L);
        TaskContextStoreTest.assertEquals((long)60000L, (long)this.activityManager.getElapsedTime((ITask)sourceTask));
        this.store.moveContext((ITask)sourceTask, (ITask)targetTask);
        TaskContextStoreTest.assertEquals((String)"Expected activity to be moved", (long)0L, (long)this.activityManager.getElapsedTime((ITask)sourceTask));
        TaskContextStoreTest.assertEquals((String)"Expected activity to be moved", (long)60000L, (long)this.activityManager.getElapsedTime((ITask)targetTask));
    }

    private void addTime(ITask task, long time) {
        MonitorUiPlugin.getDefault().getActivityContextManager().addActivityTime(task.getHandleIdentifier(), 1L, 1L + time);
    }
}

