/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tasks.tests;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.junit.Before;

public class TaskEditorRestoreTest
extends TestCase {
    private IWorkbenchPage page;
    private TaskActivityManager taskActivityManager;
    private TaskList taskList;
    private IProject project;
    private AbstractTask task1;
    private AbstractTask task2;
    private IFile fileA;
    private IFile fileB;

    @Before
    public void setUp() throws Exception {
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.taskActivityManager = TasksUiPlugin.getTaskActivityManager();
        this.taskActivityManager.deactivateActiveTask();
        this.taskList = TasksUiPlugin.getTaskList();
        TaskTestUtil.resetTaskListAndRepositories();
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(((Object)((Object)this)).getClass().getName());
        this.project.create(null);
        this.project.open(null);
        this.fileA = this.project.getProject().getFile("a.txt");
        this.fileA.create((InputStream)new ByteArrayInputStream("abc".getBytes()), false, null);
        this.fileB = this.project.getProject().getFile("b.txt");
        this.fileB.create((InputStream)new ByteArrayInputStream("abc".getBytes()), false, null);
    }

    protected void tearDown() throws Exception {
        this.taskActivityManager.deactivateActiveTask();
        if (this.project != null) {
            this.project.delete(true, null);
        }
        UiTestUtil.closeAllEditors();
    }

    public void testDeactivateDoesNotRestoreForNoOpenTasks() {
        this.createTasks("testDeactivateDoesNotRestoreForNoOpenTasks");
        this.taskActivityManager.activateTask((ITask)this.task1);
        this.taskActivityManager.deactivateTask((ITask)this.task1);
        this.assertNoTaskOrTextEditorsOpen();
        this.taskActivityManager.activateTask((ITask)this.task1);
        this.assertNoTaskOrTextEditorsOpen();
    }

    public void testDeactivateRestoresActiveTaskEditor() {
        this.createTasks("testDeactivateRestoresActiveTaskEditor");
        this.taskActivityManager.activateTask((ITask)this.task1);
        TasksUiUtil.openTask((ITask)this.task1);
        this.taskActivityManager.deactivateTask((ITask)this.task1);
        this.assertNoTaskOrTextEditorsOpen();
        this.taskActivityManager.activateTask((ITask)this.task1);
        this.assertOnlyTask1IsOpen();
        TaskEditorRestoreTest.assertEquals(Collections.emptySet(), this.getOpenEditorsByType(TextEditor.class, Functions.identity()));
    }

    public void testDeactivateRestoresActiveTaskEditorAndFiles() throws Exception {
        this.createTasks("testDeactivateRestoresActiveTaskEditorAndFiles");
        this.taskActivityManager.activateTask((ITask)this.task1);
        IDE.openEditor((IWorkbenchPage)this.page, (IFile)this.fileA, (boolean)true);
        IDE.openEditor((IWorkbenchPage)this.page, (IFile)this.fileB, (boolean)true);
        TasksUiUtil.openTask((ITask)this.task1);
        TasksUiUtil.openTask((ITask)this.task2);
        this.taskActivityManager.deactivateTask((ITask)this.task1);
        this.assertNoTaskOrTextEditorsOpen();
        this.taskActivityManager.activateTask((ITask)this.task1);
        this.assertOnlyTask1IsOpen();
        this.assertFilesAreOpen();
    }

    private void createTasks(String name) {
        this.task1 = new LocalTask(String.valueOf(name) + 1, "summary1");
        this.task2 = new LocalTask(String.valueOf(name) + 2, "summary2");
        this.taskList.addTask((ITask)this.task1);
        this.taskList.addTask((ITask)this.task2);
    }

    private void assertNoTaskOrTextEditorsOpen() {
        TaskEditorRestoreTest.assertEquals(Collections.emptySet(), this.getOpenEditorsByType(TextEditor.class, Functions.identity()));
        TaskEditorRestoreTest.assertEquals(Collections.emptySet(), this.getOpenEditorsByType(TaskEditor.class, Functions.identity()));
    }

    private void assertOnlyTask1IsOpen() {
        Set<String> editorSummaries = this.getOpenEditorsByType(TaskEditor.class, new Function<TaskEditor, String>(){

            public String apply(TaskEditor editor) {
                return editor.getTaskEditorInput().getTask().getSummary();
            }
        });
        TaskEditorRestoreTest.assertEquals((Object)ImmutableSet.of((Object)this.task1.getSummary()), editorSummaries);
    }

    private void assertFilesAreOpen() {
        Set<String> editorTitles = this.getOpenEditorsByType(TextEditor.class, new Function<TextEditor, String>(){

            public String apply(TextEditor editor) {
                return editor.getTitle();
            }
        });
        TaskEditorRestoreTest.assertEquals((Object)ImmutableSet.of((Object)this.fileA.getName(), (Object)this.fileB.getName()), editorTitles);
    }

    private <T extends IEditorPart, S> Set<S> getOpenEditorsByType(Class<T> clazz, Function<T, S> propertyFunction) {
        return FluentIterable.from(Arrays.asList(this.page.getEditorReferences())).transform((Function)new Function<IEditorReference, IEditorPart>(){

            public IEditorPart apply(IEditorReference ref) {
                return ref.getEditor(true);
            }
        }).filter(clazz).transform(propertyFunction).toSet();
    }
}

