/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.context.core.AbstractContextContributor;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.context.tests.AbstractContextTest;
import org.eclipse.mylyn.context.tests.support.DomContextReader;
import org.eclipse.mylyn.context.tests.support.DomContextWriter;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.IInteractionContextReader;
import org.eclipse.mylyn.internal.context.core.IInteractionContextWriter;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextExternalizer;
import org.eclipse.mylyn.internal.context.core.SaxContextReader;
import org.eclipse.mylyn.internal.context.core.SaxContextWriter;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.mockito.Mockito;

public class ContextExternalizerTest
extends AbstractContextTest {
    private static final String CONTEXT_HANDLE = "context-externalization";
    private InteractionContext context;
    private IInteractionContextScaling scaling;
    private File contextFile;
    private AbstractContextContributor contributor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.scaling = ContextCore.getCommonContextScaling();
        this.context = new InteractionContext(CONTEXT_HANDLE, ContextCore.getCommonContextScaling());
        ContextExternalizerTest.assertNotNull((Object)ContextCore.getContextManager());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.contextFile != null && this.contextFile.exists()) {
            this.contextFile.delete();
        }
        if (this.contributor != null) {
            ContextCorePlugin.getDefault().removeContextContributor(this.contributor);
        }
        super.tearDown();
    }

    public void testContentAttributeExternalization() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        this.context.parseEvent(this.mockSelection("1"));
        this.context.setContentLimitedTo("foobar");
        IInteractionContext loaded = this.writeAndReadContext(this.context, externalizer);
        ContextExternalizerTest.assertEquals((String)"foobar", (String)loaded.getContentLimitedTo());
    }

    public void testSaxExternalizationAgainstDom() throws Exception {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/externalizer/testcontext.xml.zip");
        ContextExternalizerTest.assertTrue((String)file.getAbsolutePath(), (boolean)file.exists());
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        IInteractionContext domReadContext = externalizer.readContextFromXml(CONTEXT_HANDLE, file, (IInteractionContextReader)new DomContextReader(), this.scaling);
        IInteractionContext saxReadContext = externalizer.readContextFromXml(CONTEXT_HANDLE, file, (IInteractionContextReader)new SaxContextReader(), this.scaling);
        ContextExternalizerTest.assertEquals((int)284, (int)saxReadContext.getInteractionHistory().size());
        ContextExternalizerTest.assertEquals((Object)domReadContext, (Object)saxReadContext);
        File domOut = new File("dom-out.xml");
        domOut.deleteOnExit();
        externalizer.writeContextToXml(saxReadContext, domOut, (IInteractionContextWriter)new DomContextWriter());
        File saxOut = new File("sax-out.xml");
        saxOut.deleteOnExit();
        externalizer.writeContextToXml(domReadContext, saxOut, (IInteractionContextWriter)new SaxContextWriter());
        IInteractionContext domReadAfterWrite = externalizer.readContextFromXml(CONTEXT_HANDLE, saxOut, (IInteractionContextReader)new DomContextReader(), this.scaling);
        IInteractionContext saxReadAfterWrite = externalizer.readContextFromXml(CONTEXT_HANDLE, domOut, (IInteractionContextReader)new SaxContextReader(), this.scaling);
        ContextExternalizerTest.assertEquals((Object)domReadAfterWrite, (Object)saxReadAfterWrite);
    }

    public void testContextSize() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        String path = "extern.xml";
        File file = new File(path);
        file.deleteOnExit();
        int ORIGINAL = 100;
        int i = 0;
        while (i < ORIGINAL) {
            this.context.parseEvent(this.mockSelection("1"));
            this.context.parseEvent(this.mockPreferenceChange("2"));
            ++i;
        }
        this.context.collapse();
        externalizer.writeContextToXml((IInteractionContext)this.context, file);
        long size = file.length();
        this.context.reset();
        int i2 = 0;
        while (i2 < ORIGINAL * ORIGINAL) {
            this.context.parseEvent(this.mockSelection("1"));
            this.context.parseEvent(this.mockPreferenceChange("2"));
            ++i2;
        }
        this.context.collapse();
        externalizer.writeContextToXml((IInteractionContext)this.context, file);
        long size2 = file.length();
        ContextExternalizerTest.assertTrue((size <= size2 * 2L ? 1 : 0) != 0);
    }

    public void testExternalization() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        IInteractionElement node = this.context.parseEvent(this.mockSelection("1"));
        this.context.parseEvent(this.mockNavigation("2"));
        IInteractionRelation edge = node.getRelation("2");
        ContextExternalizerTest.assertNotNull((Object)edge);
        ContextExternalizerTest.assertEquals((int)1, (int)node.getRelations().size());
        this.context.parseEvent(this.mockInterestContribution("3", this.scaling.getLandmark() + this.scaling.getDecay() * 3.0f));
        ContextExternalizerTest.assertTrue((String)("interest: " + this.context.get("3").getInterest().getValue()), (boolean)this.context.get("3").getInterest().isLandmark());
        float doi = node.getInterest().getValue();
        ContextExternalizerTest.assertNotNull((Object)this.context.getLandmarks());
        ContextExternalizerTest.assertEquals((String)"2", (String)this.context.getActiveNode().getHandleIdentifier());
        IInteractionContext loaded = this.writeAndReadContext(this.context, externalizer);
        ContextExternalizerTest.assertEquals((int)3, (int)loaded.getInteractionHistory().size());
        IInteractionElement loadedNode = loaded.get("1");
        IInteractionRelation edgeNode = loadedNode.getRelation("2");
        ContextExternalizerTest.assertNotNull((Object)edgeNode);
        ContextExternalizerTest.assertEquals((int)1, (int)loadedNode.getRelations().size());
        IInteractionElement landmark = loaded.get("3");
        ContextExternalizerTest.assertNotNull((Object)loadedNode);
        ContextExternalizerTest.assertEquals((Object)Float.valueOf(doi), (Object)Float.valueOf(loadedNode.getInterest().getValue()));
        ContextExternalizerTest.assertTrue((boolean)landmark.getInterest().isLandmark());
        ContextExternalizerTest.assertNotNull((Object)loaded.getLandmarks());
        ContextExternalizerTest.assertEquals((String)"2", (String)loaded.getActiveNode().getHandleIdentifier());
    }

    public void testExternalizationWithCollapse() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        IInteractionElement node1 = this.context.parseEvent(this.mockSelection("1"));
        IInteractionElement node2 = this.context.parseEvent(this.mockSelection("2"));
        this.context.parseEvent(this.mockSelection("2"));
        this.context.parseEvent(this.mockSelection("2"));
        float doi1 = node1.getInterest().getValue();
        float doi2 = node2.getInterest().getValue();
        int numEvents = this.context.getUserEventCount();
        this.context.collapse();
        InteractionContext loadedContext = (InteractionContext)this.writeAndReadContext(this.context, externalizer);
        ContextExternalizerTest.assertEquals((int)numEvents, (int)loadedContext.getUserEventCount());
        IInteractionElement loadedNode1 = loadedContext.get("1");
        IInteractionElement loadedNode2 = loadedContext.get("2");
        ContextExternalizerTest.assertEquals((Object)Float.valueOf(doi1), (Object)Float.valueOf(loadedNode1.getInterest().getValue()));
        ContextExternalizerTest.assertEquals((Object)Float.valueOf(doi2), (Object)Float.valueOf(loadedNode2.getInterest().getValue()));
        loadedContext.collapse();
        InteractionContext loadedContext2 = (InteractionContext)this.writeAndReadContext(loadedContext, externalizer);
        ContextExternalizerTest.assertEquals((int)numEvents, (int)loadedContext2.getUserEventCount());
        loadedNode1 = loadedContext2.get("1");
        loadedNode2 = loadedContext2.get("2");
        ContextExternalizerTest.assertEquals((Object)Float.valueOf(doi1), (Object)Float.valueOf(loadedNode1.getInterest().getValue()));
        ContextExternalizerTest.assertEquals((Object)Float.valueOf(doi2), (Object)Float.valueOf(loadedNode2.getInterest().getValue()));
        node1 = loadedContext2.parseEvent(this.mockSelection("1"));
        node2 = loadedContext2.parseEvent(this.mockSelection("2"));
        loadedContext2.parseEvent(this.mockSelection("2"));
        loadedContext2.parseEvent(this.mockSelection("1"));
        doi1 = node1.getInterest().getValue();
        doi2 = node2.getInterest().getValue();
        numEvents = loadedContext2.getUserEventCount();
        loadedContext2.collapse();
        InteractionContext loadedContext3 = (InteractionContext)this.writeAndReadContext(loadedContext2, externalizer);
        ContextExternalizerTest.assertEquals((int)numEvents, (int)loadedContext3.getUserEventCount());
        loadedNode1 = loadedContext3.get("1");
        loadedNode2 = loadedContext3.get("2");
        ContextExternalizerTest.assertEquals((Object)Float.valueOf(doi1), (Object)Float.valueOf(loadedNode1.getInterest().getValue()));
        ContextExternalizerTest.assertEquals((Object)Float.valueOf(doi2), (Object)Float.valueOf(loadedNode2.getInterest().getValue()));
    }

    private IInteractionContext writeAndReadContext(InteractionContext contextToWrite, InteractionContextExternalizer externalizer) throws Exception {
        File file = ContextCorePlugin.getContextStore().getFileForContext(contextToWrite.getHandleIdentifier());
        file.deleteOnExit();
        externalizer.writeContextToXml((IInteractionContext)contextToWrite, file);
        File dataDirectory = ContextCorePlugin.getContextStore().getContextDirectory().getParentFile();
        File contextsDirectory = new File(dataDirectory, "contexts");
        File zippedContextFile = new File(contextsDirectory, String.valueOf(contextToWrite.getHandleIdentifier()) + ".xml.zip");
        ContextExternalizerTest.assertTrue((boolean)zippedContextFile.exists());
        IInteractionContext loaded = externalizer.readContextFromXml(CONTEXT_HANDLE, zippedContextFile, this.scaling);
        ContextExternalizerTest.assertNotNull((Object)loaded);
        return loaded;
    }

    public void testReadOtherContextHandle() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        this.context.setHandleIdentifier("handle-1");
        this.context.parseEvent(this.mockSelection("1"));
        File file1 = File.createTempFile("context", null);
        file1.deleteOnExit();
        externalizer.writeContextToXml((IInteractionContext)this.context, file1);
        this.context.setHandleIdentifier("handle-2");
        this.context.parseEvent(this.mockSelection("2"));
        File file2 = File.createTempFile("context", null);
        file2.deleteOnExit();
        externalizer.writeContextToXml((IInteractionContext)this.context, file2);
        this.context = (InteractionContext)externalizer.readContextFromXml("handle-1", file1, this.scaling);
        ContextExternalizerTest.assertNotNull((Object)this.context);
        ContextExternalizerTest.assertEquals((int)1, (int)this.context.getAllElements().size());
        this.context = (InteractionContext)externalizer.readContextFromXml("handle-1", file2, this.scaling);
        ContextExternalizerTest.assertNotNull((Object)this.context);
        ContextExternalizerTest.assertEquals((int)2, (int)this.context.getAllElements().size());
        this.context = (InteractionContext)externalizer.readContextFromXml("abc", file1, this.scaling);
        ContextExternalizerTest.assertNotNull((Object)this.context);
        ContextExternalizerTest.assertEquals((int)1, (int)this.context.getAllElements().size());
    }

    public void testReadInvalidContextHandle() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        File file = File.createTempFile("context", null);
        file.deleteOnExit();
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));){
            ZipEntry entry = new ZipEntry("name");
            out.putNextEntry(entry);
        }
        this.context = (InteractionContext)externalizer.readContextFromXml("abc", file, this.scaling);
        ContextExternalizerTest.assertNull((Object)this.context);
    }

    public void testAddContextContributor() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        ContextCorePlugin contextCorePlugin = ContextCorePlugin.getDefault();
        this.contributor = (AbstractContextContributor)Mockito.mock(AbstractContextContributor.class);
        Mockito.when((Object)this.contributor.getDataAsStream((IInteractionContext)this.context)).thenReturn(null);
        int initialContributor = contextCorePlugin.getContextContributor().size();
        contextCorePlugin.addContextContributor(this.contributor);
        ContextExternalizerTest.assertEquals((int)(initialContributor + 1), (int)contextCorePlugin.getContextContributor().size());
        ContextExternalizerTest.assertEquals((Object)this.contributor, contextCorePlugin.getContextContributor().get(initialContributor));
        externalizer.writeContext((IInteractionContext)this.context, (ZipOutputStream)Mockito.mock(ZipOutputStream.class));
        ((AbstractContextContributor)Mockito.verify((Object)this.contributor)).getDataAsStream((IInteractionContext)this.context);
        contextCorePlugin.removeContextContributor(this.contributor);
        ContextExternalizerTest.assertEquals((int)initialContributor, (int)contextCorePlugin.getContextContributor().size());
    }

    public void testWriteAdditionalContextData() throws Exception {
        InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
        this.contributor = (AbstractContextContributor)Mockito.mock(AbstractContextContributor.class);
        InteractionEvent event = this.mockNavigation("InteractionEvent");
        this.context.parseEvent(event);
        String testContributorId = "myContributor";
        String testData = "important context information";
        ByteArrayInputStream testStream = new ByteArrayInputStream(testData.getBytes());
        Mockito.when((Object)this.contributor.getIdentifier()).thenReturn((Object)testContributorId);
        Mockito.when((Object)this.contributor.getDataAsStream((IInteractionContext)this.context)).thenReturn((Object)testStream);
        ContextCorePlugin.getDefault().addContextContributor(this.contributor);
        this.contextFile = ContextCorePlugin.getContextStore().getFileForContext(this.context.getHandleIdentifier());
        externalizer.writeContextToXml((IInteractionContext)this.context, this.contextFile);
        InputStream resultStream = externalizer.getAdditionalInformation(this.contextFile, testContributorId);
        ContextExternalizerTest.assertNotNull((Object)resultStream);
        ContextExternalizerTest.assertNull((Object)externalizer.getAdditionalInformation(this.contextFile, "nonExistingContributor"));
        ContextExternalizerTest.assertEquals((String)testData, (String)new Scanner(resultStream).useDelimiter("\\A").next());
        resultStream = ContextCore.getContextManager().getAdditionalContextData((IInteractionContext)this.context, testContributorId);
        ContextExternalizerTest.assertNotNull((Object)resultStream);
        ContextExternalizerTest.assertNull((Object)externalizer.getAdditionalInformation(this.contextFile, "nonExistingContributor"));
    }
}

