/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.DegreeOfInterest;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class DegreeOfInterestTest
extends TestCase {
    private final InteractionContext mockContext = new InteractionContext("doitest", (IInteractionContextScaling)new InteractionContextScaling());

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPredictedInterest() {
        DegreeOfInterest doi = new DegreeOfInterest(this.mockContext, ContextCore.getCommonContextScaling());
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.PREDICTION, "kind", "handle", "source-id", "id", null, 1.0f);
        doi.addEvent(event);
        DegreeOfInterestTest.assertTrue((boolean)doi.isInteresting());
        DegreeOfInterestTest.assertFalse((boolean)doi.isLandmark());
        DegreeOfInterestTest.assertFalse((boolean)doi.isPropagated());
        DegreeOfInterestTest.assertTrue((boolean)doi.isPredicted());
    }

    public void testPredictedInterestWithPropagated() {
        DegreeOfInterest doi = new DegreeOfInterest(this.mockContext, ContextCore.getCommonContextScaling());
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.SELECTION, "kind", "handle", "source-id", "id", null, 20.0f);
        doi.addEvent(event);
        InteractionEvent event2 = new InteractionEvent(InteractionEvent.Kind.PREDICTION, "kind", "handle", "source-id", "id", null, 2.0f);
        doi.addEvent(event2);
        InteractionEvent event3 = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, "kind", "handle", "source-id", "id", null, 750.0f);
        doi.addEvent(event3);
        InteractionEvent event4 = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, "kind", "handle", "source-id", "id", null, -684.0f);
        doi.addEvent(event4);
        DegreeOfInterestTest.assertTrue((boolean)doi.isInteresting());
        DegreeOfInterestTest.assertTrue((boolean)doi.isLandmark());
        DegreeOfInterestTest.assertFalse((boolean)doi.isPropagated());
        DegreeOfInterestTest.assertFalse((boolean)doi.isPredicted());
    }

    public void testPropagatedInterest() {
        DegreeOfInterest doi = new DegreeOfInterest(this.mockContext, ContextCore.getCommonContextScaling());
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, "kind", "handle", "source-id", "id", null, 1.0f);
        doi.addEvent(event);
        DegreeOfInterestTest.assertTrue((boolean)doi.isInteresting());
        DegreeOfInterestTest.assertFalse((boolean)doi.isLandmark());
        DegreeOfInterestTest.assertTrue((boolean)doi.isPropagated());
        DegreeOfInterestTest.assertFalse((boolean)doi.isPredicted());
    }

    public void testCreation() {
        DegreeOfInterest doi = new DegreeOfInterest(this.mockContext, ContextCore.getCommonContextScaling());
        DegreeOfInterestTest.assertFalse((boolean)doi.isInteresting());
        DegreeOfInterestTest.assertFalse((boolean)doi.isLandmark());
        DegreeOfInterestTest.assertFalse((boolean)doi.isPropagated());
        DegreeOfInterestTest.assertFalse((boolean)doi.isPredicted());
    }
}

