/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.ui.state.ContextState;
import org.eclipse.mylyn.internal.context.ui.state.EditorStateParticipant;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class EditorStateParticipantTest
extends TestCase {
    private final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    private IProject project;
    private IFile fileA;
    private IFile fileB;
    private MyEditorStateParticipant participant;
    private Exception exceptionOnSave;

    protected void setUp() throws Exception {
        this.participant = new MyEditorStateParticipant();
        EditorStateParticipantTest.assertTrue((boolean)this.participant.isEnabled());
    }

    protected void tearDown() throws Exception {
        UiTestUtil.closeAllEditors();
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    public void testSaveState() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"State");
        InteractionContext context = new InteractionContext("id", (IInteractionContextScaling)new InteractionContextScaling());
        ContextState state = new ContextState((IInteractionContext)context, context.getHandleIdentifier(), memento);
        this.participant.saveState(state, true);
        EditorStateParticipantTest.assertNotNull((Object)memento.getChild("org.eclipse.mylyn.context.ui.editors"));
    }

    public void testSaveRestore() throws Exception {
        this.createFilesAndOpenEditors();
        XMLMemento memento = XMLMemento.createWriteRoot((String)"State");
        InteractionContext context = new InteractionContext("id", (IInteractionContextScaling)new InteractionContextScaling());
        ContextState state = new ContextState((IInteractionContext)context, context.getHandleIdentifier(), memento);
        this.participant.saveState(state, true);
        System.err.println(this.toString((XMLMemento)state.getMemento("org.eclipse.mylyn.context.ui.editors")));
        this.participant.closeAllEditors();
        this.participant.restoreState(state);
        EditorStateParticipantTest.assertEquals((String)("Expected 2 editors, got: " + Arrays.asList(this.page.getEditorReferences())), (int)2, (int)this.page.getEditorReferences().length);
        EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileB), (Object)this.page.getEditorReferences()[0].getEditorInput());
        EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileA), (Object)this.page.getEditorReferences()[1].getEditorInput());
    }

    public void testRestoreState_3_7() throws Exception {
        this.createFiles();
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new InputStreamReader(CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/EditorStateParticipantTest/state-3.7.xml")));
        InteractionContext context = new InteractionContext("id", (IInteractionContextScaling)new InteractionContextScaling());
        ContextState state = new ContextState((IInteractionContext)context, context.getHandleIdentifier(), memento);
        this.participant.restoreState(state);
        EditorStateParticipantTest.assertEquals((String)("Expected 2 editors, got: " + Arrays.asList(this.page.getEditorReferences())), (int)2, (int)this.page.getEditorReferences().length);
        EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileB), (Object)this.page.getEditorReferences()[0].getEditorInput());
        EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileA), (Object)this.page.getEditorReferences()[1].getEditorInput());
        EditorStateParticipantTest.assertNotNull((Object)memento.getChild("org.eclipse.mylyn.context.ui.editors"));
    }

    public void testRestoreState_4_1() throws Exception {
        this.createFiles();
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new InputStreamReader(CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/EditorStateParticipantTest/state-4.1.xml")));
        InteractionContext context = new InteractionContext("id", (IInteractionContextScaling)new InteractionContextScaling());
        ContextState state = new ContextState((IInteractionContext)context, context.getHandleIdentifier(), memento);
        this.participant.restoreState(state);
        if (this.participant.is_3_x()) {
            EditorStateParticipantTest.assertEquals((String)("Expected 0 editors, got: " + Arrays.asList(this.page.getEditorReferences())), (int)0, (int)this.page.getEditorReferences().length);
        } else {
            EditorStateParticipantTest.assertEquals((String)("Expected 2 editors, got: " + Arrays.asList(this.page.getEditorReferences())), (int)2, (int)this.page.getEditorReferences().length);
            EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileB), (Object)this.page.getEditorReferences()[0].getEditorInput());
            EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileA), (Object)this.page.getEditorReferences()[1].getEditorInput());
        }
        EditorStateParticipantTest.assertNotNull((Object)memento.getChild("org.eclipse.mylyn.context.ui.editors"));
    }

    public void testRestoreStateRetainState() throws Exception {
        this.waitForMylynMonitorToStart();
        this.createFiles();
        this.exceptionOnSave = new RuntimeException("Injected error to cause editor save to fail");
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new InputStreamReader(CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/EditorStateParticipantTest/state-3.7.xml")), (String)"UTF-8");
        InteractionContext context = new InteractionContext("id", (IInteractionContextScaling)new InteractionContextScaling());
        ContextState state = new ContextState((IInteractionContext)context, context.getHandleIdentifier(), memento);
        this.participant.restoreState(state);
        XMLMemento memento2 = XMLMemento.createWriteRoot((String)"State");
        ContextState state2 = new ContextState((IInteractionContext)context, context.getHandleIdentifier(), memento2);
        this.participant.saveState(state2, true);
        EditorStateParticipantTest.assertEquals((String)this.toString(memento), (String)this.toString(memento2));
    }

    private void waitForMylynMonitorToStart() {
        MonitorUiPlugin.getDefault();
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testNoEditorsState() throws Exception {
        this.createFiles();
        PrintStream prevErr = System.err;
        try {
            IsEmptyOutputStream os = new IsEmptyOutputStream();
            System.setErr(new PrintStream(os));
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new InputStreamReader(CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/EditorStateParticipantTest/state-noEditors.xml")));
            InteractionContext context = new InteractionContext("id", (IInteractionContextScaling)new InteractionContextScaling());
            ContextState state = new ContextState((IInteractionContext)context, context.getHandleIdentifier(), memento);
            this.participant.restoreState(state);
            EditorStateParticipantTest.assertTrue((boolean)os.isEmpty());
            EditorStateParticipantTest.assertEquals((int)0, (int)this.page.getEditorReferences().length);
            EditorStateParticipantTest.assertNotNull((Object)memento.getChild("org.eclipse.mylyn.context.ui.editors"));
        }
        finally {
            System.setErr(prevErr);
        }
    }

    private String toString(XMLMemento memento) throws IOException {
        File workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        memento.save((Writer)writer);
        String s = ((Object)out).toString();
        s = s.replaceAll("&#x0D;", "\r");
        s = s.replaceAll("&#x0A;", "\n");
        s = s.replaceAll("\r\n", "\n");
        s = s.replaceAll("WORKSPACE", workspace.getAbsolutePath());
        return s;
    }

    private IEditorReference[] createFilesAndOpenEditors() throws Exception {
        IEditorReference[] refs;
        this.createFiles();
        IEditorInput[] inputs = CommonTestUtil.isEclipse4() ? new IEditorInput[]{new FileEditorInput(this.fileB), new FileEditorInput(this.fileA)} : new IEditorInput[]{new FileEditorInput(this.fileA), new FileEditorInput(this.fileB)};
        IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(this.fileA.getName());
        Object[] ids = new String[inputs.length];
        Arrays.fill(ids, editor.getId());
        IEditorReference[] iEditorReferenceArray = refs = this.page.openEditors(inputs, (String[])ids, 0);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            ref.getEditor(true);
            ++n2;
        }
        EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileB), (Object)this.page.getEditorReferences()[0].getEditorInput());
        EditorStateParticipantTest.assertEquals((Object)new FileEditorInput(this.fileA), (Object)this.page.getEditorReferences()[1].getEditorInput());
        return refs;
    }

    private void createFiles() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(((Object)((Object)this)).getClass().getName());
        this.project.create(null);
        this.project.open(null);
        this.fileA = this.project.getProject().getFile("a.txt");
        this.fileA.create((InputStream)new ByteArrayInputStream("abc".getBytes()), false, null);
        this.fileB = this.project.getProject().getFile("b.txt");
        this.fileB.create((InputStream)new ByteArrayInputStream("abc".getBytes()), false, null);
    }

    private static class IsEmptyOutputStream
    extends OutputStream {
        private boolean empty = true;

        private IsEmptyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.empty = false;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    private final class MyEditorStateParticipant
    extends EditorStateParticipant {
        private MyEditorStateParticipant() {
        }

        protected boolean is_3_x() {
            return super.is_3_x();
        }

        protected void saveEditors_e_3_x(WorkbenchPage page, IMemento memento) throws Exception {
            if (EditorStateParticipantTest.this.exceptionOnSave != null) {
                throw EditorStateParticipantTest.this.exceptionOnSave;
            }
            super.saveEditors_e_3_x(page, memento);
        }

        protected void saveEditors_e_8_2(IWorkbenchPage page, IMemento memento) throws Exception {
            if (EditorStateParticipantTest.this.exceptionOnSave != null) {
                throw EditorStateParticipantTest.this.exceptionOnSave;
            }
            super.saveEditors_e_8_2(page, memento);
        }

        protected void saveEditors_e_4_legacy(WorkbenchPage page, IMemento memento) throws Exception {
            if (EditorStateParticipantTest.this.exceptionOnSave != null) {
                throw EditorStateParticipantTest.this.exceptionOnSave;
            }
            super.saveEditors_e_4_legacy(page, memento);
        }
    }
}

