/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests.support;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.context.core.AggregateInteractionEvent;
import org.eclipse.mylyn.internal.context.core.IInteractionContextReader;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomContextReader
implements IInteractionContextReader {
    public InteractionContext readContext(String handle, File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            Document doc = this.openAsDOM(file);
            Element root = doc.getDocumentElement();
            InteractionContext t = new InteractionContext(handle, ContextCore.getCommonContextScaling());
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                InteractionEvent ie = this.readInteractionEvent(child);
                if (ie != null) {
                    t.parseEvent(ie);
                }
                ++i;
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Document openAsDOM(File inputFile) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document document = null;
        ZipInputStream zipInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(inputFile);
                zipInputStream = new ZipInputStream(fileInputStream);
                zipInputStream.getNextEntry();
                builder = factory.newDocumentBuilder();
                document = builder.parse(zipInputStream);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            DomContextReader.closeStream(zipInputStream);
            DomContextReader.closeStream(fileInputStream);
            throw throwable;
        }
        DomContextReader.closeStream(zipInputStream);
        DomContextReader.closeStream(fileInputStream);
        return document;
    }

    public InteractionEvent readInteractionEvent(Node n) {
        try {
            Element e = (Element)n;
            String kind = e.getAttribute("Kind");
            String startDate = e.getAttribute("StartDate");
            String endDate = e.getAttribute("EndDate");
            String originId = XmlStringConverter.convertXmlToString((String)e.getAttribute("OriginId"));
            String structureKind = XmlStringConverter.convertXmlToString((String)e.getAttribute("StructureKind"));
            String structureHandle = XmlStringConverter.convertXmlToString((String)e.getAttribute("StructureHandle"));
            String navigation = XmlStringConverter.convertXmlToString((String)e.getAttribute("Navigation"));
            String delta = XmlStringConverter.convertXmlToString((String)e.getAttribute("Delta"));
            String interest = e.getAttribute("Interest");
            String numEventsString = e.getAttribute("NumEvents");
            int numEvents = 1;
            if (numEventsString != null && numEventsString.length() != 0) {
                try {
                    numEvents = Integer.parseInt(numEventsString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String eventCountOnCreationString = e.getAttribute("CreationCount");
            int eventCountOnCreation = -1;
            if (eventCountOnCreationString != null && eventCountOnCreationString.length() != 0) {
                try {
                    eventCountOnCreation = Integer.parseInt(eventCountOnCreationString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String formatString = "yyyy-MM-dd HH:mm:ss.S z";
            SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.ENGLISH);
            Object ie = null;
            ie = numEventsString == null || eventCountOnCreationString == null ? new InteractionEvent(InteractionEvent.Kind.fromString((String)kind), structureKind, structureHandle, originId, navigation, delta, Float.parseFloat(interest), format.parse(startDate), format.parse(endDate)) : new AggregateInteractionEvent(InteractionEvent.Kind.fromString((String)kind), structureKind, structureHandle, originId, navigation, delta, Float.parseFloat(interest), format.parse(startDate), format.parse(endDate), numEvents, eventCountOnCreation);
            return ie;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static final void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

