/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.tests.support;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class TestUtil {
    public static final String KEY_CREDENTIALS_FILE = "mylyn.credentials";

    public static Credentials readCredentials() {
        return TestUtil.readCredentials(PrivilegeLevel.USER, null);
    }

    public static Credentials readCredentials(PrivilegeLevel level) {
        return TestUtil.readCredentials(level, null);
    }

    public static Credentials readCredentials(PrivilegeLevel level, String realm) {
        Properties properties = new Properties();
        try {
            String filename = System.getProperty(KEY_CREDENTIALS_FILE);
            if (filename == null) {
                if (Platform.isRunning()) {
                    URL localURL = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.mylyn.context.tests").getEntry("credentials.properties"));
                    filename = localURL.getFile();
                } else {
                    URL localURL = TestUtil.class.getResource("");
                    filename = String.valueOf(localURL.getFile()) + "../../../../../../../credentials.properties";
                }
            }
            properties.load(new FileInputStream(new File(filename)));
        }
        catch (Exception e) {
            throw new AssertionFailedError("must define credentials in <plug-in dir>/credentials.properties");
        }
        String defaultPassword = properties.getProperty("pass");
        realm = realm != null ? String.valueOf(realm) + "." : "";
        switch (level) {
            case ANONYMOUS: {
                return TestUtil.createCredentials(properties, String.valueOf(realm) + "anon.", "", "");
            }
            case GUEST: {
                return TestUtil.createCredentials(properties, String.valueOf(realm) + "guest.", "guest@mylyn.eclipse.org", defaultPassword);
            }
            case USER: {
                return TestUtil.createCredentials(properties, realm, "tests@mylyn.eclipse.org", defaultPassword);
            }
            case ADMIN: {
                return TestUtil.createCredentials(properties, String.valueOf(realm) + "admin.", "admin@mylyn.eclipse.org", null);
            }
        }
        throw new AssertionFailedError("invalid privilege level");
    }

    private static Credentials createCredentials(Properties properties, String prefix, String defaultUsername, String defaultPassword) {
        String username = properties.getProperty(String.valueOf(prefix) + "user");
        String password = properties.getProperty(String.valueOf(prefix) + "pass");
        if (username == null) {
            username = defaultUsername;
        }
        if (password == null) {
            password = defaultPassword;
        }
        if (username == null || password == null) {
            throw new AssertionFailedError("username or password not found in <plug-in dir>/credentials.properties, make sure file is valid");
        }
        return new Credentials(username, password);
    }

    public static IViewPart openView(String id) throws PartInitException {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id);
    }

    public static class Credentials {
        public final String username;
        public final String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + " [username=" + this.username + ",password=" + this.password + "]";
        }
    }

    public static enum PrivilegeLevel {
        ANONYMOUS,
        GUEST,
        USER,
        ADMIN;

    }
}

