/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsStateUtil;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsTestUtil;
import org.eclipse.mylyn.internal.debug.ui.DebugUiPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BreakpointsStateUtilTest {
    private final IPath pluginStateDir = Platform.getStateLocation((Bundle)DebugUiPlugin.getDefault().getBundle());
    private final File pluginStateFile = this.pluginStateDir.append("storedBreakpoints.xml").toFile();
    private final IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
    private final BreakpointsStateUtil objectUnderTest = new BreakpointsStateUtil(this.pluginStateDir);
    private IBreakpoint breakpoint;

    @Before
    public void setUp() throws Exception {
        BreakpointsTestUtil.setManageBreakpointsPreference(true);
        BreakpointsTestUtil.createProject();
        this.deleteAllBreakpoints();
        this.breakpoint = BreakpointsTestUtil.createTestBreakpoint();
    }

    @After
    public void tearDown() throws IOException, CoreException {
        this.deleteAllBreakpoints();
        FileUtils.deleteDirectory((File)this.pluginStateDir.toFile());
        WorkspaceSetupHelper.clearWorkspace();
    }

    @Test
    public void testSaveState() throws Exception {
        this.breakpointManager.addBreakpoint(this.breakpoint);
        Assert.assertEquals((long)1L, (long)this.breakpointManager.getBreakpoints().length);
        this.objectUnderTest.saveState();
        Assert.assertTrue((boolean)this.pluginStateFile.exists());
        Document pluginStateDocument = this.getDocument(this.pluginStateFile);
        Document testDocument = this.getDocument(new File("testdata/breakpointFile.xml"));
        this.sortNodes(pluginStateDocument);
        this.sortNodes(testDocument);
        Assert.assertTrue((String)("Documents not equal:\n" + this.documentToString(pluginStateDocument) + "\n===\n" + this.documentToString(testDocument)), (boolean)pluginStateDocument.isEqualNode(testDocument));
    }

    private void sortNodes(Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<Node> childNodes = new ArrayList<Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            childNodes.add(child);
            this.sortNodes(child);
            ++i;
        }
        Collections.sort(childNodes, new Comparator<Node>(){

            @Override
            public int compare(Node a, Node b) {
                if (a.getAttributes() == null) {
                    if (b.getAttributes() == null) {
                        return 0;
                    }
                    return 1;
                }
                if (b.getAttributes() == null) {
                    return -1;
                }
                Node nameA = a.getAttributes().getNamedItem("name");
                Node nameB = b.getAttributes().getNamedItem("name");
                if (nameA == null) {
                    if (nameB == null) {
                        return 0;
                    }
                    return 1;
                }
                if (nameB == null) {
                    return -1;
                }
                return nameA.getNodeValue().compareTo(nameB.getNodeValue());
            }
        });
        for (Node child : childNodes) {
            node.removeChild(child);
        }
        for (Node child : childNodes) {
            node.appendChild(child);
        }
    }

    private String documentToString(Document docuemnt) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(docuemnt), new StreamResult(writer));
        return writer.toString();
    }

    @Test
    public void testSaveStateWithoutBreakpoint() throws CoreException {
        this.deleteAllBreakpoints();
        this.objectUnderTest.saveState();
        Assert.assertFalse((boolean)this.pluginStateFile.exists());
    }

    @Test
    public void testRestoreState() throws CoreException, IOException {
        FileUtils.copyFile((File)new File("testdata/breakpointFile.xml"), (File)this.pluginStateFile);
        this.objectUnderTest.restoreState();
        Assert.assertEquals((long)1L, (long)this.breakpointManager.getBreakpoints().length);
    }

    private void deleteAllBreakpoints() throws CoreException {
        IBreakpoint[] breakpoints = this.breakpointManager.getBreakpoints();
        this.breakpointManager.removeBreakpoints(breakpoints, true);
        Assert.assertEquals((long)0L, (long)this.breakpointManager.getBreakpoints().length);
    }

    private Document getDocument(File inputFile) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try (FileInputStream fileInputStream = new FileInputStream(inputFile);){
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fileInputStream);
            return document;
        }
    }
}

