/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsStructureBridge;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BreakpointsStructureBridgeTest {
    private final BreakpointsStructureBridge objectUnderTest = new BreakpointsStructureBridge();
    private IBreakpoint testBreakpoint;

    @Before
    public void setUp() throws Exception {
        BreakpointsTestUtil.setManageBreakpointsPreference(true);
        BreakpointsTestUtil.createProject();
        this.testBreakpoint = BreakpointsTestUtil.createTestBreakpoint();
    }

    @After
    public void tearDown() throws Exception {
        WorkspaceSetupHelper.clearWorkspace();
    }

    @Test
    public void testGetHandleIdentifier() {
        Assert.assertNull((Object)this.objectUnderTest.getHandleIdentifier(new Object()));
        Assert.assertEquals((Object)"breakpointmanager[default]", (Object)this.objectUnderTest.getHandleIdentifier((Object)DebugPlugin.getDefault().getBreakpointManager()));
        Assert.assertNotNull((Object)this.objectUnderTest.getHandleIdentifier((Object)this.testBreakpoint));
    }

    @Test
    public void testGenerateBreakpointId() {
        Assert.assertNull((Object)this.testBreakpoint.getMarker().getAttribute("org.eclipse.mylyn.debug.ui.breakpointId", null));
        this.objectUnderTest.getHandleIdentifier((Object)this.testBreakpoint);
        Assert.assertNotNull((Object)this.testBreakpoint.getMarker().getAttribute("org.eclipse.mylyn.debug.ui.breakpointId", null));
    }

    @Test
    public void testContentType() {
        Assert.assertEquals((Object)"breakpoint", (Object)this.objectUnderTest.getContentType("breakpointmanager[default]"));
        Assert.assertEquals((Object)"breakpoint", (Object)this.objectUnderTest.getContentType(this.objectUnderTest.getHandleIdentifier((Object)this.testBreakpoint)));
    }

    @Test
    public void testParentHandle() {
        Assert.assertEquals((Object)"breakpointmanager[default]", (Object)this.objectUnderTest.getParentHandle(this.objectUnderTest.getHandleIdentifier((Object)this.testBreakpoint)));
        Assert.assertNull((Object)this.objectUnderTest.getParentHandle("lalalalala"));
    }

    @Test
    public void testGetObject() throws CoreException {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpoint(this.testBreakpoint);
        Assert.assertNull((Object)this.objectUnderTest.getObjectForHandle("lalalala"));
        Assert.assertEquals((Object)breakpointManager, (Object)this.objectUnderTest.getObjectForHandle("breakpointmanager[default]"));
        Assert.assertEquals((Object)this.testBreakpoint, (Object)this.objectUnderTest.getObjectForHandle(this.objectUnderTest.getHandleIdentifier((Object)this.testBreakpoint)));
    }
}

