/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.sdk.util.AbstractContextTest;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class ContentSpecificContextTest
extends AbstractContextTest {
    public void testEventProcessing() {
        InteractionContext context = new InteractionContext("global-id", (IInteractionContextScaling)new InteractionContextScaling());
        context.setContentLimitedTo("java");
        ContextCorePlugin.getContextManager().addGlobalContext((IInteractionContext)context);
        ContextCore.getContextManager().processInteractionEvent(new InteractionEvent(InteractionEvent.Kind.PROPAGATION, "foo-kind", "h0", "<mock-origin>"));
        ContentSpecificContextTest.assertEquals((int)0, (int)context.getAllElements().size());
        ContextCorePlugin.getContextManager().processInteractionEvent(this.mockSelection("h1"), false, false);
        ContentSpecificContextTest.assertEquals((int)1, (int)context.getAllElements().size());
        ContextCorePlugin.getContextManager().removeGlobalContext((IInteractionContext)context);
    }

    public void testEventProcessingCompositeContext() {
        InteractionContext context1 = new InteractionContext("global-id-1", (IInteractionContextScaling)new InteractionContextScaling());
        InteractionContext context2 = new InteractionContext("global-id-2", (IInteractionContextScaling)new InteractionContextScaling());
        context1.setContentLimitedTo("java");
        context2.setContentLimitedTo("java");
        CompositeInteractionContext context = new CompositeInteractionContext((IInteractionContextScaling)new InteractionContextScaling());
        context.getContextMap().put(context1.getHandleIdentifier(), context1);
        context.getContextMap().put(context2.getHandleIdentifier(), context2);
        context.setContentLimitedTo("java");
        ContextCorePlugin.getContextManager().addGlobalContext((IInteractionContext)context);
        ContextCore.getContextManager().processInteractionEvent(new InteractionEvent(InteractionEvent.Kind.PROPAGATION, "foo-kind", "h0", "<mock-origin>"));
        ContentSpecificContextTest.assertEquals((int)0, (int)context.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)0, (int)context1.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)0, (int)context2.getAllElements().size());
        ContextCorePlugin.getContextManager().processInteractionEvent(this.mockSelection("h1"), false, false);
        ContentSpecificContextTest.assertEquals((int)1, (int)context.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)1, (int)context1.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)1, (int)context2.getAllElements().size());
        context.getContextMap().remove(context2.getHandleIdentifier());
        ContextCore.getContextManager().processInteractionEvent(new InteractionEvent(InteractionEvent.Kind.PROPAGATION, "foo-kind", "h0", "<mock-origin>"));
        ContentSpecificContextTest.assertEquals((int)1, (int)context.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)1, (int)context1.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)1, (int)context2.getAllElements().size());
        ContextCorePlugin.getContextManager().processInteractionEvent(this.mockSelection("h2"), false, false);
        ContentSpecificContextTest.assertEquals((int)2, (int)context.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)2, (int)context1.getAllElements().size());
        ContentSpecificContextTest.assertEquals((int)1, (int)context2.getAllElements().size());
        ContextCorePlugin.getContextManager().removeGlobalContext((IInteractionContext)context);
    }
}

