/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.actions.FocusOutlineAction;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.internal.java.ui.actions.FocusPackageExplorerAction;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class FocusViewActionTest
extends AbstractJavaContextTest {
    private IViewPart view;
    private FocusOutlineAction action;

    protected void setUp() throws Exception {
        super.setUp();
        this.view = UiTestUtil.openView((String)"org.eclipse.ui.views.ContentOutline");
        FocusViewActionTest.assertNotNull((Object)this.view);
        FocusViewActionTest.assertNotNull((Object)ContextUiPlugin.getDefault());
        FocusViewActionTest.assertNotNull((Object)JavaUiBridgePlugin.getDefault());
        this.action = new FocusOutlineAction();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPreservationOfContextPause() {
        FocusPackageExplorerAction action = new FocusPackageExplorerAction();
        ContextCore.getContextManager().setContextCapturePaused(true);
        action.update(true);
        FocusViewActionTest.assertTrue((boolean)ContextCore.getContextManager().isContextCapturePaused());
        ContextCore.getContextManager().setContextCapturePaused(false);
        action.update(false);
        FocusViewActionTest.assertFalse((boolean)ContextCore.getContextManager().isContextCapturePaused());
        action.update(true);
        FocusViewActionTest.assertFalse((boolean)ContextCore.getContextManager().isContextCapturePaused());
    }

    public void testContents() throws JavaModelException, PartInitException {
        IEditorReference[] refrences;
        IMethod m1 = this.type1.createMethod("void m1() { }", null, true, null);
        UiTestUtil.openView((String)"org.eclipse.ui.views.ContentOutline");
        JavaUI.openInEditor((IJavaElement)m1);
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        IEditorReference[] iEditorReferenceArray = refrences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = refrences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            if (reference.getTitle().equals("Type1.java")) {
                IEditorPart part = reference.getEditor(true);
                AbstractContextUiBridge bridge = ContextUi.getUiBridgeForEditor((IEditorPart)part);
                List outlineViewers = bridge.getContentOutlineViewers(part);
                for (TreeViewer viewer : outlineViewers) {
                    if (viewer == null || viewers.contains(viewer)) continue;
                    viewers.add(viewer);
                }
            }
            ++n2;
        }
        FocusViewActionTest.assertEquals((int)1, (int)viewers.size());
        TreeViewer viewer = (TreeViewer)viewers.get(0);
        FocusViewActionTest.assertEquals((int)3, (int)UiTestUtil.countItemsInTree((Tree)viewer.getTree()));
        this.action.updateInterestFilter(true, (StructuredViewer)viewer);
        FocusViewActionTest.assertEquals((int)0, (int)UiTestUtil.countItemsInTree((Tree)viewer.getTree()));
        StructuredSelection sm1 = new StructuredSelection((Object)m1);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)sm1);
        viewer.refresh();
        FocusViewActionTest.assertEquals((int)2, (int)UiTestUtil.countItemsInTree((Tree)viewer.getTree()));
    }
}

