/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.actions.AbstractInterestManipulationAction;
import org.eclipse.mylyn.internal.resources.ui.ResourceInteractionMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class InterestManipulationTest
extends AbstractJavaContextTest {
    private IInteractionElement method;
    private IInteractionElement clazz;
    private IInteractionElement cu;
    private IMethod javaMethod;
    private IType javaType;
    private ICompilationUnit javaCu;
    private IPackageFragment javaPackage;
    private IWorkbenchPart part;
    private ResourceInteractionMonitor resourceMonitor;

    protected void setUp() throws Exception {
        super.setUp();
        this.javaMethod = this.type1.createMethod("void testDecrement() { }", null, true, null);
        this.javaType = (IType)this.javaMethod.getParent();
        this.javaCu = (ICompilationUnit)this.javaType.getParent();
        this.javaPackage = (IPackageFragment)this.javaCu.getParent();
        this.part = UiTestUtil.openResourceNavigator();
        this.resourceMonitor = new ResourceInteractionMonitor();
    }

    protected void tearDown() throws Exception {
        this.monitor.dispose();
        super.tearDown();
    }

    public void testDecrementNonJavaProject() throws CoreException, InvocationTargetException, InterruptedException {
        IFile file = this.nonJavaProject.getProject().getFile("foo.txt");
        file.create(null, true, null);
        ResourceStructureBridge bridge = new ResourceStructureBridge();
        this.resourceMonitor.selectionChanged(this.part, (ISelection)new StructuredSelection((Object)file));
        IInteractionElement fileElement = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier((Object)file));
        IInteractionElement projectElement = ContextCore.getContextManager().getElement(new ResourceStructureBridge().getHandleIdentifier((Object)this.nonJavaProject.getProject()));
        InterestManipulationTest.assertTrue((boolean)fileElement.getInterest().isInteresting());
        InterestManipulationTest.assertTrue((boolean)projectElement.getInterest().isInteresting());
        InterestManipulationTest.assertTrue((boolean)ContextCorePlugin.getContextManager().manipulateInterestForElement(projectElement, false, false, false, "test"));
        projectElement = ContextCore.getContextManager().getElement(new ResourceStructureBridge().getHandleIdentifier((Object)this.nonJavaProject.getProject()));
        fileElement = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier((Object)file));
        InterestManipulationTest.assertFalse((boolean)projectElement.getInterest().isInteresting());
        InterestManipulationTest.assertFalse((boolean)fileElement.getInterest().isInteresting());
    }

    public void testDecrementAcrossBridges() throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor.selectionChanged(this.part, (ISelection)new StructuredSelection((Object)this.javaMethod));
        this.method = ContextCore.getContextManager().getElement(this.javaMethod.getHandleIdentifier());
        IFile file = this.project.getProject().getFile("foo.txt");
        file.create(null, true, null);
        ResourceStructureBridge bridge = new ResourceStructureBridge();
        this.resourceMonitor.selectionChanged(this.part, (ISelection)new StructuredSelection((Object)file));
        IInteractionElement fileElement = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier((Object)file));
        IInteractionElement projectElement = ContextCore.getContextManager().getElement(this.javaCu.getJavaProject().getHandleIdentifier());
        InterestManipulationTest.assertTrue((boolean)fileElement.getInterest().isInteresting());
        InterestManipulationTest.assertTrue((boolean)this.method.getInterest().isInteresting());
        InterestManipulationTest.assertTrue((boolean)ContextCorePlugin.getContextManager().manipulateInterestForElement(projectElement, false, false, false, "test"));
        fileElement = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier((Object)file));
        InterestManipulationTest.assertFalse((boolean)fileElement.getInterest().isInteresting());
    }

    public void testDecrementInterestOfCompilationUnit() throws JavaModelException {
        this.monitor.selectionChanged(this.part, (ISelection)new StructuredSelection((Object)this.javaMethod));
        this.monitor.selectionChanged(this.part, (ISelection)new StructuredSelection((Object)this.javaCu));
        this.method = ContextCore.getContextManager().getElement(this.javaMethod.getHandleIdentifier());
        this.clazz = ContextCore.getContextManager().getElement(this.javaType.getHandleIdentifier());
        this.cu = ContextCore.getContextManager().getElement(this.javaCu.getHandleIdentifier());
        IInteractionElement packageNode = ContextCore.getContextManager().getElement(this.javaPackage.getHandleIdentifier());
        InterestManipulationTest.assertTrue((boolean)this.method.getInterest().isInteresting());
        InterestManipulationTest.assertTrue((boolean)this.clazz.getInterest().isInteresting());
        InterestManipulationTest.assertTrue((boolean)this.cu.getInterest().isInteresting());
        InterestManipulationTest.assertTrue((boolean)ContextCorePlugin.getContextManager().manipulateInterestForElement(packageNode, false, false, false, "test"));
        this.method = ContextCore.getContextManager().getElement(this.javaMethod.getHandleIdentifier());
        this.clazz = ContextCore.getContextManager().getElement(this.javaType.getHandleIdentifier());
        this.cu = ContextCore.getContextManager().getElement(this.javaCu.getHandleIdentifier());
        packageNode = ContextCore.getContextManager().getElement(this.javaPackage.getHandleIdentifier());
        InterestManipulationTest.assertFalse((boolean)packageNode.getInterest().isInteresting());
        InterestManipulationTest.assertFalse((boolean)this.cu.getInterest().isInteresting());
        InterestManipulationTest.assertFalse((boolean)this.clazz.getInterest().isInteresting());
        InterestManipulationTest.assertFalse((boolean)this.method.getInterest().isInteresting());
    }

    public void testManipulation() throws JavaModelException {
        InterestManipulationAction action = new InterestManipulationAction();
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IMethod m1 = this.type1.createMethod("void m22() { }", null, true, null);
        StructuredSelection sm1 = new StructuredSelection((Object)m1);
        this.monitor.selectionChanged(part, (ISelection)sm1);
        IInteractionElement node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InterestManipulationTest.assertFalse((boolean)node.getInterest().isLandmark());
        InterestManipulationTest.assertNotNull((Object)ContextCore.getContextManager().getActiveElement());
        action.changeInterestForSelected(true);
        InterestManipulationTest.assertTrue((boolean)node.getInterest().isLandmark());
        action.changeInterestForSelected(true);
        InterestManipulationTest.assertEquals((Object)Float.valueOf(this.scaling.getForcedLandmark() + this.scaling.get(InteractionEvent.Kind.SELECTION)), (Object)Float.valueOf(node.getInterest().getValue()));
        action.changeInterestForSelected(false);
        node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InterestManipulationTest.assertFalse((boolean)node.getInterest().isLandmark());
        InterestManipulationTest.assertTrue((boolean)node.getInterest().isInteresting());
        action.changeInterestForSelected(false);
        InterestManipulationTest.assertFalse((boolean)node.getInterest().isInteresting());
        InterestManipulationTest.assertEquals((Object)Float.valueOf(node.getInterest().getValue()), (Object)Float.valueOf(-this.scaling.get(InteractionEvent.Kind.SELECTION)));
        action.changeInterestForSelected(false);
        InterestManipulationTest.assertEquals((Object)Float.valueOf(node.getInterest().getValue()), (Object)Float.valueOf(-this.scaling.get(InteractionEvent.Kind.SELECTION)));
    }

    class InterestManipulationAction
    extends AbstractInterestManipulationAction {
        InterestManipulationAction() {
        }

        protected boolean isIncrement() {
            return true;
        }

        public void changeInterestForSelected(boolean increment) {
            InterestManipulationTest.assertTrue((boolean)ContextCorePlugin.getContextManager().manipulateInterestForElement(ContextCore.getContextManager().getActiveElement(), increment, false, true, ""));
        }
    }
}

