/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.java.ui.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class JavaEditorManagerTest
extends AbstractJavaContextTest {
    private IWorkbenchPage page;
    private IViewPart view;

    protected void setUp() throws Exception {
        super.setUp();
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        JavaEditorManagerTest.assertNotNull((Object)this.page);
        this.view = PackageExplorerPart.openInActivePerspective();
        JavaEditorManagerTest.assertNotNull((Object)this.view);
        JavaEditorManagerTest.assertTrue((boolean)ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage"));
        ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.close.action.manage.warning", false);
        UiTestUtil.closeWelcomeView();
        UiTestUtil.closeAllEditors();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        UiTestUtil.closeAllEditors();
        ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.close.action.manage.warning", ContextUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.context.ui.close.action.manage.warning"));
    }

    public void testInterestCapturedForResourceOnFocus() throws CoreException, InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        ContextCore.getContextManager().setContextCapturePaused(true);
        IType typeA = this.project.createType(this.p1, "TypeAa.java", "public class TypeD{ }");
        IType typeB = this.project.createType(this.p1, "TypeBb.java", "public class TypeC{ }");
        IFile fileA = (IFile)typeA.getAdapter(IResource.class);
        IFile fileB = (IFile)typeB.getAdapter(IResource.class);
        AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge((Object)fileA);
        IInteractionElement elementA = ContextCore.getContextManager().getElement(structureBridge.getHandleIdentifier((Object)fileA));
        IInteractionElement elementB = ContextCore.getContextManager().getElement(structureBridge.getHandleIdentifier((Object)fileB));
        JavaEditorManagerTest.assertFalse((boolean)elementA.getInterest().isInteresting());
        JavaEditorManagerTest.assertFalse((boolean)elementB.getInterest().isInteresting());
        ContextCore.getContextManager().setContextCapturePaused(false);
        elementA = ContextCore.getContextManager().getElement(structureBridge.getHandleIdentifier((Object)fileA));
        JavaEditorManagerTest.assertFalse((boolean)elementA.getInterest().isInteresting());
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)fileA, (boolean)true);
        elementA = ContextCore.getContextManager().getElement(structureBridge.getHandleIdentifier((Object)fileA));
        float selectionFactor = ContextCore.getCommonContextScaling().get(InteractionEvent.Kind.SELECTION);
        JavaEditorManagerTest.assertTrue((boolean)elementA.getInterest().isInteresting());
        JavaEditorManagerTest.assertTrue((elementA.getInterest().getValue() <= selectionFactor ? 1 : 0) != 0);
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)fileB, (boolean)true);
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)fileA, (boolean)true);
        elementA = ContextCore.getContextManager().getElement(structureBridge.getHandleIdentifier((Object)fileA));
        JavaEditorManagerTest.assertTrue((elementA.getInterest().getValue() > 1.0f && elementA.getInterest().getValue() < 2.0f ? 1 : 0) != 0);
    }

    public void testEditorTrackerListenerRegistration() throws JavaModelException {
        ActiveFoldingEditorTracker tracker = JavaUiBridgePlugin.getDefault().getEditorTracker();
        JavaEditorManagerTest.assertTrue((boolean)tracker.getEditorListenerMap().isEmpty());
        AbstractContextUiBridge bridge = ContextUi.getUiBridge((String)"java");
        IMethod m1 = this.type1.createMethod("void m111() { }", null, true, null);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)m1));
        int numListeners = ContextCorePlugin.getContextManager().getListeners().size();
        IInteractionElement element = ContextCore.getContextManager().getElement(this.type1.getHandleIdentifier());
        bridge.open(element);
        JavaEditorManagerTest.assertEquals((int)(numListeners + 1), (int)ContextCorePlugin.getContextManager().getListeners().size());
        JavaEditorManagerTest.assertEquals((int)1, (int)this.page.getEditorReferences().length);
        JavaEditorManagerTest.assertEquals((int)1, (int)tracker.getEditorListenerMap().size());
        UiTestUtil.closeAllEditors();
        JavaEditorManagerTest.assertEquals((int)numListeners, (int)ContextCorePlugin.getContextManager().getListeners().size());
        JavaEditorManagerTest.assertEquals((int)0, (int)this.page.getEditorReferences().length);
        JavaEditorManagerTest.assertEquals((int)0, (int)tracker.getEditorListenerMap().size());
    }

    public void testAutoCloseWithDecay() throws JavaModelException, InvocationTargetException, InterruptedException {
        ContextUiPlugin.getEditorStateParticipant().closeAllEditors();
        JavaEditorManagerTest.assertEquals((int)0, (int)this.page.getEditorReferences().length);
        AbstractContextUiBridge bridge = ContextUi.getUiBridge((String)"java");
        IMethod m1 = this.type1.createMethod("void m111() { }", null, true, null);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)m1));
        IInteractionElement element = ContextCore.getContextManager().getElement(this.type1.getHandleIdentifier());
        bridge.open(element);
        IType typeA = this.project.createType(this.p1, "TypeA.java", "public class TypeA{ }");
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)typeA));
        IInteractionElement elementA = ContextCore.getContextManager().getElement(typeA.getHandleIdentifier());
        bridge.open(elementA);
        this.context.reset();
        JavaEditorManagerTest.assertEquals((int)2, (int)this.page.getEditorReferences().length);
        int i = 0;
        while ((float)i < 1.0f / this.scaling.getDecay() * 3.0f) {
            ContextCore.getContextManager().processInteractionEvent(this.mockSelection());
            ++i;
        }
        element = ContextCore.getContextManager().getElement(this.type1.getHandleIdentifier());
        elementA = ContextCore.getContextManager().getElement(typeA.getHandleIdentifier());
        JavaEditorManagerTest.assertFalse((boolean)element.getInterest().isInteresting());
        JavaEditorManagerTest.assertFalse((boolean)elementA.getInterest().isInteresting());
        IType typeB = this.project.createType(this.p1, "TypeB.java", "public class TypeB{ }");
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)typeB));
        IInteractionElement elementB = ContextCore.getContextManager().getElement(typeB.getHandleIdentifier());
        bridge.open(elementB);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)typeB));
        JavaEditorManagerTest.assertEquals((int)1, (int)this.page.getEditorReferences().length);
    }
}

