/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.java.ui.JavaStackTraceContextComputationStrategy;

public class JavaStackTraceContextComputationStrategyTest
extends TestCase {
    private InteractionContext context;
    private JavaStackTraceContextComputationStrategy stackTraceDetector;

    protected void setUp() throws Exception {
        this.context = new InteractionContext("test", (IInteractionContextScaling)new InteractionContextScaling());
        this.stackTraceDetector = new JavaStackTraceContextComputationStrategy();
    }

    public void testStackTrace() throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/taskDescription1.txt");
        List contextObjects = this.stackTraceDetector.computeElements(CommonTestUtil.read((File)file));
        JavaStackTraceContextComputationStrategyTest.assertFalse((boolean)contextObjects.isEmpty());
        JavaStackTraceContextComputationStrategyTest.assertTrue((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("java.lang.NullPointerException", null)));
        JavaStackTraceContextComputationStrategyTest.assertTrue((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider", "getAttachmentId")));
        JavaStackTraceContextComputationStrategyTest.assertTrue((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider", "getColumnText")));
        JavaStackTraceContextComputationStrategyTest.assertTrue((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("org.eclipse.jface.viewers.StructuredViewer$UpdateItemSafeRunnable", "run")));
    }

    public void testStackTracePopulatedWithoutEclipseErrorHeaderElements() throws IOException {
        File file = CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/taskDescription2.txt");
        List contextObjects = this.stackTraceDetector.computeElements(CommonTestUtil.read((File)file));
        JavaStackTraceContextComputationStrategyTest.assertFalse((boolean)contextObjects.isEmpty());
        JavaStackTraceContextComputationStrategyTest.assertFalse((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("Date", null)));
        JavaStackTraceContextComputationStrategyTest.assertFalse((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("Message", null)));
        JavaStackTraceContextComputationStrategyTest.assertFalse((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("Severity", null)));
        JavaStackTraceContextComputationStrategyTest.assertFalse((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("Product", null)));
        JavaStackTraceContextComputationStrategyTest.assertFalse((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("Plugin", null)));
        JavaStackTraceContextComputationStrategyTest.assertTrue((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("org.eclipse.swt.SWTException", null)));
        JavaStackTraceContextComputationStrategyTest.assertTrue((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("org.eclipse.swt.SWT", "error")));
        JavaStackTraceContextComputationStrategyTest.assertTrue((boolean)contextObjects.contains(new JavaStackTraceContextComputationStrategy.Element("org.eclipse.swt.graphics.Image", "getBounds")));
    }
}

