/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ResourceStructureMappingTest
extends AbstractJavaContextTest {
    protected void setUp() throws Exception {
        super.setUp();
        UiTestUtil.openResourceNavigator();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.getWorkingSet("TestWorkingSet");
        if (workingSet != null) {
            workingSetManager.removeWorkingSet(workingSet);
        }
    }

    public void testParentResourceMapping() throws CoreException {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IMethod m1 = this.type1.createMethod("public void m1() { }", null, true, null);
        this.monitor.selectionChanged(part, (ISelection)new StructuredSelection((Object)m1));
        IInteractionElement m1Node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        ResourceStructureMappingTest.assertTrue((boolean)m1Node.getInterest().isInteresting());
        IResource containingResource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(m1Node, true);
        ResourceStructureMappingTest.assertEquals((Object)m1.getCompilationUnit().getAdapter(IResource.class), (Object)containingResource);
    }

    public void testWorkingSetFiltering() throws CoreException {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.createWorkingSet("TestWorkingSet", new IAdaptable[]{this.project.getProject()});
        workingSet.setId("org.eclipse.jdt.ui.JavaWorkingSetPage");
        workingSetManager.addWorkingSet(workingSet);
        this.context.reset();
        ResourceStructureMappingTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
        AbstractContextStructureBridge workingSetBridge = ContextCore.getStructureBridge((Object)workingSet);
        ResourceStructureMappingTest.assertEquals((String)"resource", (String)workingSetBridge.getContentType());
        ResourceStructureMappingTest.assertTrue((boolean)workingSetBridge.canFilter((Object)workingSet));
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.monitor.selectionChanged(part, (ISelection)new StructuredSelection((Object)this.type1));
        IInteractionElement element = ContextCore.getContextManager().getElement(this.type1.getHandleIdentifier());
        ResourceStructureMappingTest.assertTrue((boolean)element.getInterest().isInteresting());
        ResourceStructureMappingTest.assertFalse((boolean)workingSetBridge.canFilter((Object)workingSet));
    }
}

