/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests.xml;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.context.sdk.util.search.ISearchPluginTest;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.pde.ui.XmlJavaRelationProvider;
import org.eclipse.mylyn.java.tests.search.ActiveSearchNotifier;
import org.eclipse.mylyn.java.tests.search.SearchPluginTestHelper;
import org.eclipse.mylyn.java.tests.xml.XmlTestActiveSearchListener;

public class XmlSearchPluginTest
extends TestCase
implements ISearchPluginTest {
    private IType type1;
    private IType type2;
    private IFile plugin1;
    private IFile plugin2;
    private IFile tocRefs;
    private IFile tocNoRefs;
    private IJavaProject jp1;
    private IJavaProject jp2;
    private static final String SOURCE_ID = "XMLSearchTest";
    private SearchPluginTestHelper helper;

    protected void setUp() throws Exception {
        WorkspaceSetupHelper.setupWorkspace();
        this.jp1 = WorkspaceSetupHelper.getProject1();
        this.jp2 = WorkspaceSetupHelper.getProject2();
        this.type1 = WorkspaceSetupHelper.getType((IJavaProject)this.jp1, (String)"org.eclipse.mylar.tests.project1.views.SampleView");
        this.type2 = WorkspaceSetupHelper.getType((IJavaProject)this.jp2, (String)"org.eclipse.mylar.tests.project2.builder.SampleBuilder.SampleResourceVisitor");
        this.plugin1 = WorkspaceSetupHelper.getFile((IJavaProject)this.jp1, (String)"plugin.xml");
        this.tocRefs = WorkspaceSetupHelper.getFile((IJavaProject)this.jp1, (String)"toc-refs.xml");
        this.tocNoRefs = WorkspaceSetupHelper.getFile((IJavaProject)this.jp1, (String)"toc-no-refs.xml");
        this.plugin2 = WorkspaceSetupHelper.getFile((IJavaProject)this.jp2, (String)"plugin.xml");
        InteractionContext t = WorkspaceSetupHelper.getContext();
        ContextCore.getContextManager().activateContext(t.getHandleIdentifier());
        this.helper = new SearchPluginTestHelper(this);
    }

    protected void tearDown() throws Exception {
        WorkspaceSetupHelper.clearDoiModel();
        ContextCore.getContextManager().deactivateContext(WorkspaceSetupHelper.getContext().getHandleIdentifier());
        XmlSearchPluginTest.assertFalse((boolean)ContextCore.getContextManager().isContextActive());
    }

    public void testXMLSearchDOS1() throws IOException, CoreException {
        int dos = 1;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, this.type1.getHandleIdentifier(), "resource", searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, this.tocRefs.getFullPath().toString(), "resource", searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, this.tocNoRefs.getFullPath().toString(), "resource", searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.plugin2.getFullPath().toString(), "plugin.xml", searchNode, dos, 0, false);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.plugin1.getFullPath().toString(), "plugin.xml", searchNode, dos, 3, false);
    }

    public void testXMLSearchDOS2() throws IOException, CoreException {
        int dos = 2;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type2.getHandleIdentifier(), "java", searchNode, dos, 0, false);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.plugin1.getFullPath().toString(), "plugin.xml", searchNode, dos, 3, false);
    }

    public void testXMLSearchDOS3() throws IOException, CoreException {
        int dos = 3;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.tocRefs.getFullPath().toString(), "resource", searchNode, dos, 3, false);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.tocNoRefs.getFullPath().toString(), "resource", searchNode, dos, 3, false);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 3, false);
        searchNode = notifier.getElement(this.type2.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 0, false);
    }

    public void testXMLSearchDOS4() throws IOException, CoreException {
        int dos = 4;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.tocRefs.getFullPath().toString(), "resource", searchNode, dos, 3, false);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.tocNoRefs.getFullPath().toString(), "resource", searchNode, dos, 3, false);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 3, false);
        searchNode = notifier.getElement(this.type2.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 0, false);
    }

    public List<?> search(int dos, IInteractionElement node) throws IOException, CoreException {
        if (node == null) {
            return null;
        }
        XmlJavaRelationProvider prov = new XmlJavaRelationProvider();
        IActiveSearchOperation o = prov.getSearchOperation(node, 0, dos);
        if (o == null) {
            return null;
        }
        XmlTestActiveSearchListener l = new XmlTestActiveSearchListener((AbstractRelationProvider)prov);
        SearchPluginTestHelper.search(o, (IActiveSearchListener)l);
        return l.getResults();
    }
}

