/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.core.INotificationService;
import org.eclipse.mylyn.commons.notifications.core.NotificationSink;
import org.eclipse.mylyn.commons.notifications.core.NotificationSinkEvent;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationAction;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationHandler;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationService
implements INotificationService {
    public void notify(List<? extends AbstractNotification> notifications) {
        if (!NotificationsPlugin.getDefault().getPreferenceStore().getBoolean("notifications.enabled")) {
            return;
        }
        HashMap<NotificationSink, ArrayList<AbstractNotification>> filtered = new HashMap<NotificationSink, ArrayList<AbstractNotification>>();
        for (AbstractNotification abstractNotification : notifications) {
            String id = abstractNotification.getEventId();
            NotificationHandler handler = NotificationsPlugin.getDefault().getModel().getNotificationHandler(id);
            if (handler == null) continue;
            List<NotificationAction> actions = handler.getActions();
            for (NotificationAction action : actions) {
                NotificationSink sink;
                if (!action.isSelected() || (sink = action.getSinkDescriptor().getSink()) == null) continue;
                ArrayList<AbstractNotification> list = (ArrayList<AbstractNotification>)filtered.get(sink);
                if (list == null) {
                    list = new ArrayList<AbstractNotification>();
                    filtered.put(sink, list);
                }
                list.add(abstractNotification);
            }
        }
        for (Map.Entry entry : filtered.entrySet()) {
            final NotificationSink sink = (NotificationSink)entry.getKey();
            final NotificationSinkEvent event = new NotificationSinkEvent(new ArrayList((Collection)entry.getValue()));
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.commons.notifications.ui", "Sink failed: " + sink.getClass(), e));
                }

                public void run() throws Exception {
                    sink.notify(event);
                }
            });
        }
    }
}

