/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.git.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.versions.core.Change;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ChangeType;
import org.eclipse.mylyn.versions.core.ScmCore;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class GetChangeSetDialog
extends FormDialog {
    private static final String FIND_REVIEW_ITEMS_DIALOG_TITLE = "Find Review Items";
    private static final String FIND_REVIEW_ITEMS_DIALOG_VALUE = "Review Item Info";
    private static final String FIND_REVIEW_ITEMS_DESCRIPTION_DIALOG_VALUE = "Review Item Components";
    private static final String COMMIT_INFO_HEADER_MSG = "Commit Information";
    private static final String COMMIT_COMPONENTS_HEADER_MSG = "Committed Components";
    private static final int DIALOG_COMBO_MAX_CHARACTERS = 80;
    private static final String GIT_NEWLINE = "\n";
    private static final int NUM_COMMIT_SHOWN = 10;
    private static final String MORE_ITEMS_LABEL = "<more items>";
    protected final IProject inputProject;
    private CCombo commitList = null;
    protected ChangeSet selectedChangeSet = null;
    Label messageText = null;
    Label idText = null;
    Label authorNameText = null;
    Label authorEmailText = null;
    Label dateText = null;
    Label repositoryNameText = null;
    org.eclipse.swt.widgets.List changeList = null;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd hh:mm:ss");
    private ScmConnector connector = null;
    private ScmRepository repository = null;
    private List<ChangeSet> changeSets = null;
    private final List<ChangeSet> filteredChangeSets = new ArrayList<ChangeSet>();
    private int currentChangeSetIndex;
    private int currentCommitListIndex;

    public GetChangeSetDialog(Shell aParentShell, IProject aInputProject) {
        super(aParentShell);
        this.setBlockOnOpen(true);
        this.inputProject = aInputProject;
    }

    protected void configureShell(Shell aShell) {
        super.configureShell(aShell);
        aShell.setText(FIND_REVIEW_ITEMS_DIALOG_TITLE);
    }

    protected void createFormContent(IManagedForm mform) {
        try {
            this.connector = ScmCore.getConnector((IResource)this.inputProject);
            this.repository = this.connector.getRepository((IResource)this.inputProject, (IProgressMonitor)new NullProgressMonitor());
            this.changeSets = this.connector.getChangeSets(this.repository, (IProgressMonitor)new NullProgressMonitor());
            this.currentChangeSetIndex = 0;
            this.currentCommitListIndex = 0;
            FormToolkit toolkit = mform.getToolkit();
            ScrolledForm sform = mform.getForm();
            sform.setExpandVertical(true);
            Composite composite = sform.getBody();
            composite.setLayout((Layout)new GridLayout(4, false));
            Label label = toolkit.createLabel(composite, "Available Commits: ");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.commitList = new CCombo(composite, 72);
            this.populateNextChangeSets();
            this.commitList.setTextLimit(80);
            this.commitList.setVisibleItemCount(10);
            this.commitList.select(0);
            this.selectedChangeSet = this.filteredChangeSets.get(0);
            GridData textGridData = new GridData(4, 4, true, false);
            textGridData.horizontalSpan = 3;
            this.commitList.setLayoutData((Object)textGridData);
            this.commitList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectedIndex = GetChangeSetDialog.this.commitList.getSelectionIndex();
                    if (GetChangeSetDialog.this.commitList.getItem(selectedIndex).equals(GetChangeSetDialog.MORE_ITEMS_LABEL)) {
                        GetChangeSetDialog.this.populateNextChangeSets();
                        GetChangeSetDialog.this.commitList.select(selectedIndex);
                        GetChangeSetDialog.this.selectedChangeSet = (ChangeSet)GetChangeSetDialog.this.filteredChangeSets.get(selectedIndex);
                    } else {
                        GetChangeSetDialog.this.selectedChangeSet = (ChangeSet)GetChangeSetDialog.this.filteredChangeSets.get(selectedIndex);
                    }
                    GetChangeSetDialog.this.refresh();
                }
            });
            this.createReviewItemDetails(toolkit, sform);
            this.createReviewItemComponents(toolkit, sform);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.git.ui", 0, e.toString(), (Throwable)e));
        }
    }

    protected void populateNextChangeSets() {
        ChangeSet updatedChangeSet = null;
        ChangeSet changeSet = null;
        String repoProject = null;
        if (this.currentCommitListIndex > 0) {
            this.commitList.remove(this.currentCommitListIndex);
        }
        while (this.currentChangeSetIndex < this.changeSets.size()) {
            changeSet = this.changeSets.get(this.currentChangeSetIndex);
            updatedChangeSet = this.updateChangeSet(changeSet);
            for (Change change : updatedChangeSet.getChanges()) {
                if (change.getTarget() != null) {
                    repoProject = change.getTarget().getProjectName();
                } else if (change.getBase() != null) {
                    repoProject = change.getBase().getProjectName();
                }
                if (repoProject == null || !repoProject.equals(this.inputProject.getName())) continue;
                String[] tokens = updatedChangeSet.getMessage().split(GIT_NEWLINE, 2);
                this.commitList.add(tokens[0].length() > 80 ? String.valueOf(tokens[0].substring(0, 77)) + "..." : tokens[0]);
                this.filteredChangeSets.add(updatedChangeSet);
                ++this.currentCommitListIndex;
                if (this.currentCommitListIndex % 10 != 0) break;
                this.commitList.add(MORE_ITEMS_LABEL);
                ++this.currentChangeSetIndex;
                return;
            }
            ++this.currentChangeSetIndex;
        }
    }

    private void createReviewItemDetails(FormToolkit aToolkit, final ScrolledForm aParent) {
        GridData textGridData = null;
        Section basicSection = aToolkit.createSection(aParent.getBody(), 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText(COMMIT_INFO_HEADER_MSG);
        basicSection.setDescription(FIND_REVIEW_ITEMS_DIALOG_VALUE);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                aParent.reflow(true);
                GetChangeSetDialog.this.getShell().setSize(GetChangeSetDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = aToolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)new GridLayout(4, false));
        basicSection.setClient((Control)basicSectionClient);
        Label titleLabel = aToolkit.createLabel(basicSectionClient, "Title: ", 64);
        titleLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.messageText = aToolkit.createLabel(basicSectionClient, this.selectedChangeSet.getMessage(), 0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.messageText.setLayoutData((Object)textGridData);
        Label idLabel = aToolkit.createLabel(basicSectionClient, "ID: ", 64);
        idLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.idText = aToolkit.createLabel(basicSectionClient, this.selectedChangeSet.getId(), 0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.idText.setLayoutData((Object)textGridData);
        Label authorNameLabel = aToolkit.createLabel(basicSectionClient, "Author Name: ", 64);
        authorNameLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.authorNameText = aToolkit.createLabel(basicSectionClient, this.selectedChangeSet.getAuthor().getName(), 0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.authorNameText.setLayoutData((Object)textGridData);
        Label authorEmailLabel = aToolkit.createLabel(basicSectionClient, "Author Email: ", 64);
        authorEmailLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.authorEmailText = aToolkit.createLabel(basicSectionClient, this.selectedChangeSet.getAuthor().getEmail(), 0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.authorEmailText.setLayoutData((Object)textGridData);
        Label dateLabel = aToolkit.createLabel(basicSectionClient, "Date: ", 64);
        dateLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        String dateStr = this.dateFormat.format(this.selectedChangeSet.getDate());
        this.dateText = aToolkit.createLabel(basicSectionClient, dateStr, 0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.dateText.setLayoutData((Object)textGridData);
        Label messageLabel = aToolkit.createLabel(basicSectionClient, "Repository: ", 64);
        messageLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.repositoryNameText = aToolkit.createLabel(basicSectionClient, this.selectedChangeSet.getRepository().getName(), 0);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.repositoryNameText.setLayoutData((Object)textGridData);
        basicSectionClient.layout();
    }

    private void createReviewItemComponents(FormToolkit aToolkit, final ScrolledForm aParent) {
        Section extraSection = aToolkit.createSection(aParent.getBody(), 450);
        GridData extraSectionGridData = new GridData(4, 4, true, true);
        extraSectionGridData.horizontalSpan = 4;
        extraSection.setLayoutData((Object)extraSectionGridData);
        extraSection.setText(COMMIT_COMPONENTS_HEADER_MSG);
        extraSection.setDescription(FIND_REVIEW_ITEMS_DESCRIPTION_DIALOG_VALUE);
        extraSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                aParent.reflow(true);
                GetChangeSetDialog.this.getShell().setSize(GetChangeSetDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite extraSectionClient = aToolkit.createComposite((Composite)extraSection);
        extraSectionClient.setLayout((Layout)new GridLayout(4, false));
        extraSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        extraSection.setClient((Control)extraSectionClient);
        this.changeList = new org.eclipse.swt.widgets.List(extraSectionClient, 768);
        for (Change change : this.selectedChangeSet.getChanges()) {
            this.changeList.add(this.getAdjustedPath(change));
        }
        GridData data = new GridData(4, 4, true, true);
        this.changeList.setLayoutData((Object)data);
    }

    private ChangeSet updateChangeSet(ChangeSet aSelectedChangeSet) {
        String changeSetId = aSelectedChangeSet.getId();
        ChangeSet updatedChangeSet = null;
        IFileRevision fileRevision = this.createFileRevision(changeSetId);
        try {
            updatedChangeSet = this.connector.getChangeSet(this.repository, fileRevision, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.git.ui", 0, e.toString(), (Throwable)e));
            return aSelectedChangeSet;
        }
        return updatedChangeSet;
    }

    private IFileRevision createFileRevision(final String changeSetId) {
        FileRevision fileRevision = new FileRevision(){

            public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public boolean isPropertyMissing() {
                return false;
            }

            public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public String getContentIdentifier() {
                return changeSetId;
            }

            public String getName() {
                return null;
            }
        };
        return fileRevision;
    }

    void refresh() {
        this.messageText.setText(this.selectedChangeSet.getMessage());
        this.idText.setText(this.selectedChangeSet.getId());
        this.dateText.setText(this.dateFormat.format(this.selectedChangeSet.getDate()));
        this.authorNameText.setText(this.selectedChangeSet.getAuthor().getName());
        this.authorEmailText.setText(this.selectedChangeSet.getAuthor().getEmail());
        this.repositoryNameText.setText(this.selectedChangeSet.getRepository().getUrl());
        this.changeList.removeAll();
        for (Change change : this.selectedChangeSet.getChanges()) {
            this.changeList.add(this.getAdjustedPath(change));
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public ChangeSet getChangeSet() {
        return this.selectedChangeSet;
    }

    private String getAdjustedPath(Change aChange) {
        if (aChange.getChangeType().equals((Object)ChangeType.DELETED)) {
            return "[-] " + aChange.getBase().getPath();
        }
        if (aChange.getChangeType().equals((Object)ChangeType.ADDED)) {
            return "[+] " + aChange.getTarget().getPath();
        }
        return "     " + aChange.getTarget().getPath();
    }
}

