/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.bugzilla.tests.AbstractBugzillaTest;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tests.util.TestFixture;

public class BugzillaRepositoryConnectorTestWithGuest
extends AbstractBugzillaTest {
    protected void setUp() throws Exception {
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        this.manager = TasksUiPlugin.getRepositoryManager();
        TestFixture.resetTaskListAndRepositories();
        this.client = BugzillaFixture.current().client(CommonTestUtil.PrivilegeLevel.GUEST);
        this.connector = BugzillaFixture.current().connector();
        this.repository = BugzillaFixture.current().repository();
        TasksUi.getRepositoryManager().addRepository(this.repository);
    }

    protected void tearDown() throws Exception {
        TestFixture.resetTaskList();
        this.manager.clearRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
    }

    public void testPrivateDescription() throws Exception {
        TaskAttribute isPrivate;
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test private comments";
            }

            public String getDescription() {
                return "The Description of the private comments task";
            }
        };
        this.repository.setProperty("bugzilla.insider.group", "true");
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaRepositoryConnectorTestWithGuest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTestWithGuest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTestWithGuest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTestWithGuest.assertNotNull((Object)taskData);
        TaskAttribute description = taskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey());
        TaskAttribute isPrivateAttribute = description.getAttribute("isprivate");
        BugzillaRepositoryConnectorTestWithGuest.assertEquals((String)"0", (String)isPrivateAttribute.getValue());
        TaskAttribute idAttribute = description.getAttribute("id");
        String value = idAttribute.getValue();
        TaskAttribute definedIsPrivate = description.getAttribute("defined_isprivate_" + value);
        if (definedIsPrivate == null) {
            definedIsPrivate = description.createAttribute("defined_isprivate_" + value);
        }
        if ((isPrivate = description.getAttribute("isprivate_" + value)) == null) {
            isPrivate = description.createAttribute("isprivate_" + value);
        }
        definedIsPrivate.setValue("1");
        isPrivate.setValue("1");
        model.attributeChanged(description);
        changed = new HashSet();
        changed.clear();
        changed.add(description);
        workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        workingCopy.save(changed, null);
        try {
            BugzillaFixture.current().submitTask(taskData, this.client);
        }
        catch (CoreException e) {
            BugzillaRepositoryConnectorTestWithGuest.assertTrue((e.getStatus().getMessage().indexOf("Sorry, but you are not allowed to (un)mark comments or attachments as private.") != -1 ? 1 : 0) != 0);
            return;
        }
        BugzillaRepositoryConnectorTestWithGuest.fail((String)"CoreException not found!");
    }
}

