/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class RepositoryReportFactoryTest
extends TestCase {
    TaskRepository repository;
    BugzillaClient client;
    BugzillaRepositoryConnector connector;

    protected void setUp() throws Exception {
        this.repository = BugzillaFixture.current().repository();
        this.client = BugzillaFixture.current().client();
        this.connector = BugzillaFixture.current().connector();
    }

    public void testInvalidCredentials() throws Exception {
        block2: {
            try {
                this.client.logout((IProgressMonitor)new NullProgressMonitor());
                this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("invalid", "invalid"), false);
                this.connector.getTaskData(this.repository, "1", (IProgressMonitor)new NullProgressMonitor());
                RepositoryReportFactoryTest.fail((String)"CoreException expected but not found");
            }
            catch (CoreException e) {
                if (e.getStatus().getMessage().startsWith("Unable to login")) break block2;
                throw e;
            }
        }
        this.repository.flushAuthenticationCredentials();
    }

    public void testBugNotFound() throws Exception {
        block2: {
            try {
                this.connector.getClientManager().repositoryAdded(this.repository);
                this.connector.getTaskData(this.repository, "-1", (IProgressMonitor)new NullProgressMonitor());
                RepositoryReportFactoryTest.fail((String)"Expected CoreException");
            }
            catch (CoreException e) {
                if (e.getStatus().getMessage().startsWith("Repository error from")) break block2;
                throw e;
            }
        }
    }

    public void testPostingAndReadingAttributes() throws Exception {
        List priorities;
        RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl());
        String priority = (String)priorities.get((priorities = repositoryConfiguration.getPriorities()).size() > 0 ? priorities.size() - 1 : 0);
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "testPostingAndReading() summary", "testPostingAndReading() description");
        data.getRoot().getMappedAttribute("task.common.component").setValue("ManualC2");
        data.getRoot().getMappedAttribute("task.common.priority").setValue(priority);
        data.getRoot().getMappedAttribute("task.common.severity").setValue("enhancement");
        data.getRoot().getMappedAttribute(BugzillaAttribute.REP_PLATFORM.getKey()).setValue("PC");
        data.getRoot().getMappedAttribute(BugzillaAttribute.OP_SYS.getKey()).setValue("Linux");
        data.getRoot().getMappedAttribute(BugzillaAttribute.VERSION.getKey()).setValue("R2.0");
        BugzillaFixture.current().submitTask(data, this.client);
        data = BugzillaFixture.current().getTask(data.getTaskId(), this.client);
        RepositoryReportFactoryTest.assertNotNull((Object)data);
        RepositoryReportFactoryTest.assertEquals((String)"ManualC2", (String)data.getRoot().getMappedAttribute("task.common.component").getValue());
        RepositoryReportFactoryTest.assertEquals((String)priority, (String)data.getRoot().getMappedAttribute("task.common.priority").getValue());
        RepositoryReportFactoryTest.assertEquals((String)"enhancement", (String)data.getRoot().getMappedAttribute("task.common.severity").getValue());
        RepositoryReportFactoryTest.assertEquals((String)"PC", (String)data.getRoot().getMappedAttribute(BugzillaAttribute.REP_PLATFORM.getKey()).getValue());
        RepositoryReportFactoryTest.assertEquals((String)"Linux", (String)data.getRoot().getMappedAttribute(BugzillaAttribute.OP_SYS.getKey()).getValue());
        RepositoryReportFactoryTest.assertEquals((String)"R2.0", (String)data.getRoot().getMappedAttribute(BugzillaAttribute.VERSION.getKey()).getValue());
        RepositoryReportFactoryTest.assertEquals((String)"R2.0", (String)data.getRoot().getMappedAttribute(BugzillaAttribute.VERSION.getKey()).getValue());
        TaskMapper mapper = new TaskMapper(data);
        RepositoryReportFactoryTest.assertEquals((String)"testPostingAndReading() summary", (String)mapper.getSummary());
        RepositoryReportFactoryTest.assertEquals((String)"testPostingAndReading() description", (String)mapper.getDescription());
        RepositoryReportFactoryTest.assertEquals((String)"ManualTest", (String)mapper.getProduct());
    }

    public void testDeltaTsTruncation() {
        String ts1 = "2006-07-06 03:22:08 0900";
        String ts1_truncated = "2006-07-06 03:22:08";
        RepositoryReportFactoryTest.assertEquals((String)ts1_truncated, (String)BugzillaClient.stripTimeZone((String)ts1));
        String ts2 = "2006-07-06 03:22:08";
        String ts2_truncated = "2006-07-06 03:22:08";
        RepositoryReportFactoryTest.assertEquals((String)ts2_truncated, (String)BugzillaClient.stripTimeZone((String)ts2));
        String ts3 = "2006-07-06 03:22:08 PST";
        String ts3_truncated = "2006-07-06 03:22:08";
        RepositoryReportFactoryTest.assertEquals((String)ts3_truncated, (String)BugzillaClient.stripTimeZone((String)ts3));
    }
}

