/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.xmlrpc.XmlRpcException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.AbstractBugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.CustomTransitionManager;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.service.BugzillaXmlRpcClient;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tests.util.TestFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaXmlRpcClientTest
extends TestCase {
    private static final String BUGZILLA_LE_4_0 = "<4.0";
    private static final String BUGZILLA_GE_4_0 = ">=4.0";
    private BugzillaXmlRpcClient bugzillaClient;
    private TaskRepository repository;
    private BugzillaRepositoryConnector connector;
    protected TaskRepositoryManager manager;
    private BugzillaClient client;
    private final Map<String, Map<String, ArrayList<String>>> fixtureTransitionsMap = new HashMap<String, Map<String, ArrayList<String>>>(){
        {
            this.put(BugzillaXmlRpcClientTest.BUGZILLA_LE_4_0, new HashMap<String, ArrayList<String>>(){
                {
                    this.put("NEW", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                        }
                    });
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("ASSIGNED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("REOPENED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("reopen");
                            this.add("close");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("close");
                        }
                    });
                    this.put("CLOSED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                        }
                    });
                }
            });
            this.put(BugzillaXmlRpcClientTest.BUGZILLA_GE_4_0, new HashMap<String, ArrayList<String>>(){
                {
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("CONFIRMED");
                            this.add("duplicate");
                            this.add("IN_PROGRESS");
                        }
                    });
                    this.put("IN_PROGRESS", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("CONFIRMED");
                        }
                    });
                    this.put("CONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("IN_PROGRESS");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("reopen");
                            this.add("CONFIRMED");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("CONFIRMED");
                        }
                    });
                }
            });
            this.put("Custom Workflow", new HashMap<String, ArrayList<String>>(){
                {
                    this.put("NEW", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("close");
                        }
                    });
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("ASSIGNED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("markNew");
                        }
                    });
                    this.put("REOPENED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                            this.add("reopen");
                            this.add("close");
                            this.add("verify");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("reopen");
                            this.add("close");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("close");
                        }
                    });
                    this.put("CLOSED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                        }
                    });
                }
            });
            this.put("Custom Workflow and Status", new HashMap<String, ArrayList<String>>(){
                {
                    this.put("NEW", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("close");
                            this.add("reopen");
                        }
                    });
                    this.put("UNCONFIRMED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                            this.add("close");
                        }
                    });
                    this.put("ASSIGNED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("markNew");
                            this.add("close");
                        }
                    });
                    this.put("REOPENED", new ArrayList<String>(){
                        {
                            this.add("resolve");
                            this.add("accept");
                            this.add("duplicate");
                            this.add("markNew");
                            this.add("reopen");
                            this.add("close");
                        }
                    });
                    this.put("RESOLVED", new ArrayList<String>(){
                        {
                            this.add("verify");
                            this.add("reopen");
                            this.add("close");
                        }
                    });
                    this.put("VERIFIED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("close");
                            this.add("MODIFIED");
                        }
                    });
                    this.put("CLOSED", new ArrayList<String>(){
                        {
                            this.add("reopen");
                            this.add("resolve");
                            this.add("duplicate");
                            this.add("verify");
                        }
                    });
                    this.put("ON_DEV", new ArrayList<String>(){
                        {
                            this.add("close");
                            this.add("POST");
                        }
                    });
                    this.put("POST", new ArrayList<String>(){
                        {
                            this.add("close");
                        }
                    });
                    this.put("MODIFIED", new ArrayList<String>(){
                        {
                            this.add("close");
                            this.add("ON_DEV");
                        }
                    });
                }
            });
        }
    };

    public void setUp() throws Exception {
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        this.manager = TasksUiPlugin.getRepositoryManager();
        TestFixture.resetTaskListAndRepositories();
        WebLocation webLocation = new WebLocation(String.valueOf(BugzillaFixture.current().getRepositoryUrl()) + "/xmlrpc.cgi");
        webLocation.setCredentials(AuthenticationType.REPOSITORY, "tests@mylyn.eclipse.org", "mylyntest");
        this.client = BugzillaFixture.current().client(CommonTestUtil.PrivilegeLevel.USER);
        this.repository = BugzillaFixture.current().repository();
        this.connector = BugzillaFixture.current().connector();
        this.bugzillaClient = new BugzillaXmlRpcClient((AbstractWebLocation)webLocation, this.client);
        this.bugzillaClient.setContentTypeCheckingEnabled(true);
        TasksUi.getRepositoryManager().addRepository(this.repository);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TestFixture.resetTaskList();
        this.manager.clearRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
    }

    protected TaskDataModel createModel(ITask task) throws CoreException {
        ITaskDataWorkingCopy taskDataState = this.getWorkingCopy(task);
        return new TaskDataModel(this.repository, task, taskDataState);
    }

    protected ITaskDataWorkingCopy getWorkingCopy(ITask task) throws CoreException {
        return TasksUiPlugin.getTaskDataManager().getWorkingCopy(task);
    }

    protected void submit(TaskDataModel model) {
        SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskJob((AbstractRepositoryConnector)this.connector, model.getTaskRepository(), model.getTask(), model.getTaskData(), model.getChangedOldAttributes());
        submitJob.schedule();
        try {
            submitJob.join();
        }
        catch (InterruptedException e) {
            BugzillaXmlRpcClientTest.fail((String)e.getMessage());
        }
    }

    protected ITask generateLocalTaskAndDownload(String id) throws CoreException {
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, id);
        TasksUiPlugin.getTaskList().addTask(task);
        TasksUiInternal.synchronizeTask((AbstractRepositoryConnector)this.connector, (ITask)task, (boolean)true, null);
        TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
        return task;
    }

    protected String taskExists() {
        String taskID = null;
        String queryUrlString = String.valueOf(this.repository.getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20XMLRPC%20getBugData&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=TestComponent&product=TestProduct";
        RepositoryQuery query = new RepositoryQuery(this.repository.getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(Integer.valueOf(taskData.getTaskId()), taskData);
            }
        };
        this.connector.performQuery(this.repository, (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        if (changedTaskData.size() > 0) {
            Set ks = changedTaskData.keySet();
            TreeSet sks = new TreeSet(ks);
            taskID = ((Integer)sks.last()).toString();
        }
        return taskID;
    }

    protected String createTask() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test XMLRPC getBugData";
            }

            public String getDescription() {
                return "The Description of the XMLRPC getBugData Bug";
            }
        };
        TaskAttribute flagA = null;
        TaskAttribute flagB = null;
        TaskAttribute flagC = null;
        TaskAttribute flagD = null;
        TaskAttribute stateA = null;
        TaskAttribute stateB = null;
        TaskAttribute stateC = null;
        TaskAttribute stateD = null;
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaXmlRpcClientTest.assertNotNull((Object)response);
        BugzillaXmlRpcClientTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaXmlRpcClientTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaXmlRpcClientTest.assertNotNull((Object)taskData);
        TaskAttribute attrAttachment = taskData.getAttributeMapper().createTaskAttachment(taskData);
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attrAttachment);
        String fileName = "test-attach-1.txt";
        File attachFile = new File(fileName);
        attachFile.createNewFile();
        attachFile.deleteOnExit();
        BufferedWriter write = new BufferedWriter(new FileWriter(attachFile));
        write.write("test file from " + System.currentTimeMillis());
        write.close();
        FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(attachFile);
        attachment.setContentType("text/plain");
        attachment.setDescription("Description");
        attachment.setName("My Attachment 1");
        try {
            this.client.postAttachment(taskData.getTaskId(), attachmentMapper.getComment(), (AbstractTaskAttachmentSource)attachment, attrAttachment, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            BugzillaXmlRpcClientTest.fail((String)"never reach this!");
        }
        taskData = BugzillaFixture.current().getTask(taskData.getTaskId(), this.client);
        BugzillaXmlRpcClientTest.assertNotNull((Object)taskData);
        TaskAttribute attachmentAttribute = (TaskAttribute)taskData.getAttributeMapper().getAttributesByType(taskData, "attachment").get(0);
        int flagCount = 0;
        int flagCountUnused = 0;
        TaskAttribute attachmentFlag1 = null;
        TaskAttribute attachmentFlag2 = null;
        for (TaskAttribute attribute : attachmentAttribute.getAttributes().values()) {
            if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
            ++flagCount;
            if (!attribute.getId().startsWith("task.common.kind.flag_type")) continue;
            ++flagCountUnused;
            TaskAttribute stateAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
            if (stateAttribute.getMetaData().getLabel().equals("AttachmentFlag1")) {
                attachmentFlag1 = attribute;
            }
            if (!stateAttribute.getMetaData().getLabel().equals("AttachmentFlag2")) continue;
            attachmentFlag2 = attribute;
        }
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)flagCount);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)flagCountUnused);
        BugzillaXmlRpcClientTest.assertNotNull(attachmentFlag1);
        BugzillaXmlRpcClientTest.assertNotNull(attachmentFlag2);
        TaskAttribute stateAttribute1 = taskData.getAttributeMapper().getAssoctiatedAttribute(attachmentFlag1);
        stateAttribute1.setValue("?");
        TaskAttribute requestee = attachmentFlag1.getAttribute("requestee");
        requestee.setValue("guest@mylyn.eclipse.org");
        this.client.postUpdateAttachment(attachmentAttribute, "update", null);
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaXmlRpcClientTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaXmlRpcClientTest.assertNotNull((Object)taskData);
        for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
            if (!taskAttribute.getId().startsWith("task.common.kind.flag")) continue;
            TaskAttribute state = taskAttribute.getAttribute("state");
            if (state.getMetaData().getLabel().equals("BugFlag1")) {
                flagA = taskAttribute;
                stateA = state;
                continue;
            }
            if (state.getMetaData().getLabel().equals("BugFlag2")) {
                flagB = taskAttribute;
                stateB = state;
                continue;
            }
            if (state.getMetaData().getLabel().equals("BugFlag3")) {
                flagC = taskAttribute;
                stateC = state;
                continue;
            }
            if (!state.getMetaData().getLabel().equals("BugFlag4")) continue;
            flagD = taskAttribute;
            stateD = state;
        }
        BugzillaXmlRpcClientTest.assertNotNull(flagA);
        BugzillaXmlRpcClientTest.assertNotNull(flagB);
        BugzillaXmlRpcClientTest.assertNotNull(flagC);
        BugzillaXmlRpcClientTest.assertNotNull(flagD);
        BugzillaXmlRpcClientTest.assertNotNull(stateA);
        BugzillaXmlRpcClientTest.assertNotNull(stateB);
        BugzillaXmlRpcClientTest.assertNotNull(stateC);
        BugzillaXmlRpcClientTest.assertNotNull(stateD);
        if (flagD != null) {
            TaskAttribute requesteeD = flagD.getAttribute("requestee");
            requesteeD.setValue("guest@mylyn.eclipse.org");
        }
        if (stateA != null) {
            stateA.setValue("+");
        }
        if (stateB != null) {
            stateB.setValue("?");
        }
        if (stateC != null) {
            stateC.setValue("?");
        }
        if (stateD != null) {
            stateD.setValue("?");
        }
        TaskAttribute cf_freetext = taskData.getRoot().getAttribute("cf_freetext");
        TaskAttribute cf_dropdown = taskData.getRoot().getAttribute("cf_dropdown");
        TaskAttribute cf_largetextbox = taskData.getRoot().getAttribute("cf_largetextbox");
        TaskAttribute cf_multiselect = taskData.getRoot().getAttribute("cf_multiselect");
        TaskAttribute cf_datetime = taskData.getRoot().getAttribute("cf_datetime");
        TaskAttribute cf_bugid = taskData.getRoot().getAttribute("cf_bugid");
        cf_freetext.setValue("Freetext");
        cf_dropdown.setValue("one");
        cf_largetextbox.setValue("large text box");
        cf_multiselect.setValue("Blue");
        cf_datetime.setValue("2012-01-01 00:00:00");
        cf_bugid.setValue("3");
        model.attributeChanged(cf_freetext);
        model.attributeChanged(cf_dropdown);
        model.attributeChanged(cf_largetextbox);
        model.attributeChanged(cf_multiselect);
        model.attributeChanged(cf_datetime);
        model.attributeChanged(cf_bugid);
        model.attributeChanged(flagA);
        model.attributeChanged(flagB);
        model.attributeChanged(flagC);
        model.attributeChanged(flagD);
        changed.clear();
        changed.add(flagA);
        changed.add(flagB);
        changed.add(flagC);
        changed.add(flagD);
        changed.add(cf_freetext);
        changed.add(cf_dropdown);
        changed.add(cf_largetextbox);
        changed.add(cf_multiselect);
        changed.add(cf_datetime);
        changed.add(cf_bugid);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        return taskId;
    }

    public void testGetVersion() throws Exception {
        if (BugzillaFixture.current().getDescription().equals("XML-RPC disabled")) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        String version = this.bugzillaClient.getVersion((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertEquals((String)BugzillaFixture.current().getVersion().toUpperCase(), (String)version.toUpperCase());
    }

    public void testUserInfo() throws Exception {
        if (BugzillaFixture.current().getDescription().equals("XML-RPC disabled")) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        int uID = this.bugzillaClient.login((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)uID);
        Object[] userList0 = this.bugzillaClient.getUserInfoFromIDs((IProgressMonitor)monitor, new Integer[]{1, 2});
        BugzillaXmlRpcClientTest.assertNotNull((Object)userList0);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)userList0.length);
        BugzillaXmlRpcClientTest.assertEquals((Object)1, ((HashMap)userList0[0]).get("id"));
        BugzillaXmlRpcClientTest.assertEquals((String)"admin@mylyn.eclipse.org", (String)((String)((HashMap)userList0[0]).get("email")));
        BugzillaXmlRpcClientTest.assertEquals((String)"admin@mylyn.eclipse.org", (String)((String)((HashMap)userList0[0]).get("name")));
        BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn Admin", (String)((String)((HashMap)userList0[0]).get("real_name")));
        BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList0[0]).get("can_login"));
        BugzillaXmlRpcClientTest.assertEquals((Object)2, ((HashMap)userList0[1]).get("id"));
        BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList0[1]).get("email")));
        BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList0[1]).get("name")));
        BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn Test", (String)((String)((HashMap)userList0[1]).get("real_name")));
        BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList0[1]).get("can_login"));
        Object[] userList1 = this.bugzillaClient.getUserInfoFromNames((IProgressMonitor)monitor, new String[]{"tests@mylyn.eclipse.org"});
        BugzillaXmlRpcClientTest.assertNotNull((Object)userList1);
        BugzillaXmlRpcClientTest.assertEquals((int)1, (int)userList1.length);
        BugzillaXmlRpcClientTest.assertEquals((Object)2, ((HashMap)userList1[0]).get("id"));
        BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList1[0]).get("email")));
        BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList1[0]).get("name")));
        BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn Test", (String)((String)((HashMap)userList1[0]).get("real_name")));
        BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList1[0]).get("can_login"));
        if (BugzillaFixture.current() != BugzillaFixture.BUGS_3_4) {
            Object[] userList2 = this.bugzillaClient.getUserInfoWithMatch((IProgressMonitor)monitor, new String[]{"est"});
            BugzillaXmlRpcClientTest.assertEquals((int)2, (int)userList2.length);
            BugzillaXmlRpcClientTest.assertEquals((Object)3, ((HashMap)userList2[0]).get("id"));
            BugzillaXmlRpcClientTest.assertEquals((String)"guest@mylyn.eclipse.org", (String)((String)((HashMap)userList2[0]).get("email")));
            BugzillaXmlRpcClientTest.assertEquals((String)"guest@mylyn.eclipse.org", (String)((String)((HashMap)userList2[0]).get("name")));
            BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn guest", (String)((String)((HashMap)userList2[0]).get("real_name")));
            BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList2[0]).get("can_login"));
            BugzillaXmlRpcClientTest.assertEquals((Object)2, ((HashMap)userList2[1]).get("id"));
            BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList2[1]).get("email")));
            BugzillaXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)((String)((HashMap)userList2[1]).get("name")));
            BugzillaXmlRpcClientTest.assertEquals((String)"Mylyn Test", (String)((String)((HashMap)userList2[1]).get("real_name")));
            BugzillaXmlRpcClientTest.assertEquals((Object)true, ((HashMap)userList2[1]).get("can_login"));
        }
    }

    public void testProductInfo() throws Exception {
        if (BugzillaFixture.current().getDescription().equals("XML-RPC disabled")) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        int uID = this.bugzillaClient.login((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)uID);
        Object[] selProductIDs = this.bugzillaClient.getSelectableProducts((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertNotNull((Object)selProductIDs);
        BugzillaXmlRpcClientTest.assertEquals((int)3, (int)selProductIDs.length);
        Object[] enterProductIDs = this.bugzillaClient.getEnterableProducts((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertNotNull((Object)enterProductIDs);
        BugzillaXmlRpcClientTest.assertEquals((int)3, (int)enterProductIDs.length);
        Object[] accessibleProductIDs = this.bugzillaClient.getAccessibleProducts((IProgressMonitor)monitor);
        BugzillaXmlRpcClientTest.assertNotNull((Object)accessibleProductIDs);
        BugzillaXmlRpcClientTest.assertEquals((int)3, (int)accessibleProductIDs.length);
        Object[] productDetails = this.bugzillaClient.getProducts((IProgressMonitor)monitor, (Object[])new Integer[]{1, 3});
        BugzillaXmlRpcClientTest.assertNotNull((Object)productDetails);
        BugzillaXmlRpcClientTest.assertEquals((int)2, (int)productDetails.length);
        BugzillaXmlRpcClientTest.assertEquals((Object)1, ((HashMap)productDetails[0]).get("id"));
        BugzillaXmlRpcClientTest.assertEquals((String)"This is a test product. This ought to be blown away and replaced with real stuff in a finished installation of bugzilla.", (String)((String)((HashMap)productDetails[0]).get("description")));
        BugzillaXmlRpcClientTest.assertEquals((Object)3, ((HashMap)productDetails[1]).get("id"));
        BugzillaXmlRpcClientTest.assertEquals((String)"Product for manual testing", (String)((String)((HashMap)productDetails[1]).get("description")));
    }

    public void testXmlRpcInstalled() throws Exception {
        int uID = -1;
        NullProgressMonitor monitor = new NullProgressMonitor();
        BugzillaFixture.current();
        if (BugzillaFixture.current().getDescription().equals("XML-RPC disabled")) {
            try {
                uID = this.bugzillaClient.login((IProgressMonitor)monitor);
                BugzillaXmlRpcClientTest.fail((String)"Never reach this! We should get an XmlRpcException");
            }
            catch (XmlRpcException e) {
                BugzillaXmlRpcClientTest.assertEquals((String)"The server returned an unexpected content type: 'text/html; charset=UTF-8'", (String)e.getMessage());
            }
        } else {
            uID = this.bugzillaClient.login((IProgressMonitor)monitor);
            BugzillaXmlRpcClientTest.assertEquals((int)2, (int)uID);
        }
    }

    public void testTransitionManagerWithXml() throws Exception {
        if (BugzillaFixture.current().getBugzillaVersion().isSmaller(BugzillaVersion.BUGZILLA_3_6)) {
            return;
        }
        if (BugzillaFixture.current().getDescription().equals("XML-RPC disabled")) {
            return;
        }
        CustomTransitionManager ctm = new CustomTransitionManager();
        ctm.parse((IProgressMonitor)new NullProgressMonitor(), this.bugzillaClient);
        ArrayList<String> transitions = new ArrayList<String>();
        Map<String, ArrayList<String>> expectTransitions = BugzillaFixture.current().getDescription().equals("Custom Workflow") ? this.fixtureTransitionsMap.get("Custom Workflow") : (BugzillaFixture.current().getDescription().equals("Custom Workflow and Status") ? this.fixtureTransitionsMap.get("Custom Workflow and Status") : (BugzillaFixture.current().getBugzillaVersion().isSmaller(BugzillaVersion.BUGZILLA_4_0) ? this.fixtureTransitionsMap.get(BUGZILLA_LE_4_0) : this.fixtureTransitionsMap.get(BUGZILLA_GE_4_0)));
        for (String start : expectTransitions.keySet()) {
            transitions.clear();
            ArrayList<String> expectedStateTransition = expectTransitions.get(start);
            for (AbstractBugzillaOperation s : ctm.getValidTransitions(start)) {
                String end = s.toString();
                if (expectedStateTransition.contains(end)) {
                    transitions.add(end);
                    continue;
                }
                BugzillaXmlRpcClientTest.fail((String)("The status " + start + " is not expected to transition to " + end.toString()));
            }
            BugzillaXmlRpcClientTest.assertEquals((String)("Missing transitions for " + start + ", only found " + transitions), (int)transitions.size(), (int)ctm.getValidTransitions(start).size());
        }
    }

    public void testXmlRpcBugGet() throws Exception {
        if (BugzillaFixture.current().getDescription().equals("XML-RPC disabled") || BugzillaFixture.current() == BugzillaFixture.BUGS_3_4) {
            return;
        }
        HashSet<String> taskIds = new HashSet<String>();
        String taskId = this.taskExists();
        if (taskId == null) {
            taskId = this.createTask();
        }
        taskIds.add(taskId);
        final HashMap results = new HashMap();
        final HashMap resultsXMLRPC = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                results.put(taskData.getTaskId(), taskData);
            }
        };
        TaskDataCollector collectorXMLRPC = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                resultsXMLRPC.put(taskData.getTaskId(), taskData);
            }
        };
        CoreException[] collectionException = new CoreException[1];
        Boolean[] updateConfig = new Boolean[1];
        class CollectorWrapper
        extends TaskDataCollector {
            private final IProgressMonitor monitor2;
            private final TaskDataCollector collector;
            private final /* synthetic */ Boolean[] val$updateConfig;
            private final /* synthetic */ CoreException[] val$collectionException;

            public void failed(String taskId, IStatus status) {
                this.collector.failed(taskId, status);
            }

            public CollectorWrapper(TaskDataCollector collector, IProgressMonitor monitor2, Boolean[] booleanArray, CoreException[] coreExceptionArray) {
                this.val$updateConfig = booleanArray;
                this.val$collectionException = coreExceptionArray;
                this.collector = collector;
                this.monitor2 = monitor2;
            }

            public void accept(TaskData taskData) {
                block4: {
                    try {
                        AbstractTaskDataHandler taskDataHandler = BugzillaXmlRpcClientTest.this.connector.getTaskDataHandler();
                        taskDataHandler.initializeTaskData(BugzillaXmlRpcClientTest.this.repository, taskData, null, (IProgressMonitor)new SubProgressMonitor(this.monitor2, 1));
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() == 1 && e.getMessage().contains("Update Config")) {
                            if (this.val$updateConfig[0] == null) {
                                this.val$updateConfig[0] = new Boolean(true);
                            }
                        }
                        if (this.val$collectionException[0] != null) break block4;
                        this.val$collectionException[0] = e;
                    }
                }
                this.collector.accept(taskData);
                this.monitor2.worked(1);
            }
        }
        CollectorWrapper collector2 = new CollectorWrapper(collector, (IProgressMonitor)new NullProgressMonitor(), updateConfig, collectionException);
        CollectorWrapper collector3 = new CollectorWrapper(collectorXMLRPC, (IProgressMonitor)new NullProgressMonitor(), updateConfig, collectionException);
        this.client.getTaskData(taskIds, (TaskDataCollector)collector2, (TaskAttributeMapper)new BugzillaAttributeMapper(this.repository, this.connector), (IProgressMonitor)new NullProgressMonitor());
        if (collectionException[0] != null) {
            throw collectionException[0];
        }
        this.bugzillaClient.getTaskData(taskIds, (TaskDataCollector)collector3, (TaskAttributeMapper)new BugzillaAttributeMapper(this.repository, this.connector), (IProgressMonitor)new NullProgressMonitor());
        if (collectionException[0] != null) {
            throw collectionException[0];
        }
        BugzillaXmlRpcClientTest.assertEquals((int)results.size(), (int)resultsXMLRPC.size());
        String div = "";
        for (String taskID : results.keySet()) {
            TaskData taskDataHTML = (TaskData)results.get(taskID);
            TaskData taskDataXMLRPC = (TaskData)resultsXMLRPC.get(taskID);
            BugzillaXmlRpcClientTest.assertNotNull((Object)taskDataHTML);
            BugzillaXmlRpcClientTest.assertNotNull((Object)taskDataXMLRPC);
            Map attributesHTML = taskDataHTML.getRoot().getAttributes();
            Map attributesXMLRPC = taskDataXMLRPC.getRoot().getAttributes();
            div = String.valueOf(div) + this.compareAttributes(attributesHTML, attributesXMLRPC, "", "Root-" + taskID + ": ");
        }
    }

    private String compareAttributes(Map<String, TaskAttribute> attributesHTML, Map<String, TaskAttribute> attributesXMLRPC, String div, String prefix) {
        for (String attributeNameHTML : attributesHTML.keySet()) {
            Map subAttribHTML;
            TaskAttribute attributeHTML = attributesHTML.get(attributeNameHTML);
            TaskAttribute attributeXMLRPC = attributesXMLRPC.get(attributeNameHTML);
            if (attributeXMLRPC == null) {
                div = String.valueOf(div) + prefix + attributeNameHTML + " not in XMLRPC\n";
                continue;
            }
            if (attributeHTML.getValues().size() > 1) {
                List i1 = attributeHTML.getValues();
                List i2 = attributeXMLRPC.getValues();
                if (i1.size() != i2.size()) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " has size " + i1.size() + " but got " + i2.size() + "\n";
                }
                for (String string : i1) {
                    if (i2.contains(string)) continue;
                    div = String.valueOf(div) + prefix + attributeNameHTML + " did not have " + string + "\n";
                }
            }
            if (attributeHTML.getValue().compareTo(attributeXMLRPC.getValue()) != 0) {
                div = String.valueOf(div) + prefix + attributeNameHTML + " value not equal HTML = '" + attributeHTML.getValue() + "' XMLRPC = '" + attributeXMLRPC.getValue() + "'\n";
            }
            TaskAttributeMetaData metaHTML = attributeHTML.getMetaData();
            TaskAttributeMetaData metaXMLRPC = attributeXMLRPC.getMetaData();
            if (metaHTML != null && metaXMLRPC == null) {
                div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData not in XMLRPC\n";
            }
            if (metaHTML != null && metaXMLRPC != null) {
                metaHTML.getKind();
                metaXMLRPC.getKind();
                if (metaHTML.getKind() != null && metaXMLRPC.getKind() == null) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData Kind not in XMLRPC\n";
                } else if (metaHTML.getKind() != null && metaHTML.getKind().compareTo(metaXMLRPC.getKind()) != 0) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " Meta Kind not equal HTML = '" + metaHTML.getKind() + "' XMLRPC = '" + metaXMLRPC.getKind() + "'\n";
                }
                if (metaHTML.getType() != null && metaXMLRPC.getType() == null) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData Type not in XMLRPC\n";
                } else if (metaHTML.getType() != null && metaHTML.getType().compareTo(metaXMLRPC.getType()) != 0) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " Meta Type not equal HTML = '" + metaHTML.getType() + "' XMLRPC = '" + metaXMLRPC.getType() + "'\n";
                }
                if (metaHTML.getLabel() != null && metaXMLRPC.getLabel() == null) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " MetaData Label not in XMLRPC\n";
                } else if (metaHTML.getLabel() != null && metaHTML.getLabel().compareTo(metaXMLRPC.getLabel()) != 0) {
                    div = String.valueOf(div) + prefix + attributeNameHTML + " Meta Label not equal HTML = '" + metaHTML.getLabel() + "' XMLRPC = '" + metaXMLRPC.getLabel() + "'\n";
                }
            }
            if ((subAttribHTML = attributeHTML.getAttributes()).isEmpty()) continue;
            Map subAttribXMLRPC = attributeXMLRPC.getAttributes();
            div = this.compareAttributes(subAttribHTML, subAttribXMLRPC, div, String.valueOf(prefix) + attributeNameHTML + ": ");
        }
        return div;
    }

    public void testUpdateProductInfo() throws Exception {
        if (BugzillaFixture.current().getDescription().equals("XML-RPC disabled") || BugzillaFixture.current() == BugzillaFixture.BUGS_3_4) {
            return;
        }
        RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl());
        for (String product : repositoryConfiguration.getProducts()) {
            repositoryConfiguration.setDefaultMilestone(product, null);
        }
        this.bugzillaClient.updateProductInfo((IProgressMonitor)new NullProgressMonitor(), repositoryConfiguration);
        for (String product : repositoryConfiguration.getProducts()) {
            if (product.equals("ManualTest") || product.equals("Scratch") || product.equals("TestProduct")) {
                BugzillaXmlRpcClientTest.assertEquals((String)"---", (String)repositoryConfiguration.getDefaultMilestones(product));
                continue;
            }
            BugzillaXmlRpcClientTest.fail((String)"never reach this");
        }
    }
}

