/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildPackage;
import org.eclipse.mylyn.builds.internal.core.IBuildLoader;
import org.eclipse.mylyn.builds.internal.core.util.BuildScheduler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildModel
extends EObjectImpl
implements IBuildModel {
    protected EList<IBuildServer> servers;
    protected EList<IBuildPlan> plans;
    protected EList<IBuild> builds;
    private BuildScheduler scheduler;
    private IBuildLoader loader;

    protected BuildModel() {
    }

    protected EClass eStaticClass() {
        return BuildPackage.Literals.BUILD_MODEL;
    }

    @Override
    public List<IBuildServer> getServers() {
        if (this.servers == null) {
            this.servers = new EObjectContainmentEList(IBuildServer.class, (InternalEObject)this, 0);
        }
        return this.servers;
    }

    @Override
    public List<IBuildPlan> getPlans() {
        if (this.plans == null) {
            this.plans = new EObjectContainmentEList(IBuildPlan.class, (InternalEObject)this, 1);
        }
        return this.plans;
    }

    @Override
    public List<IBuild> getBuilds() {
        if (this.builds == null) {
            this.builds = new EObjectContainmentEList(IBuild.class, (InternalEObject)this, 2);
        }
        return this.builds;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getServers()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getPlans()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getBuilds()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getServers();
            }
            case 1: {
                return this.getPlans();
            }
            case 2: {
                return this.getBuilds();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getServers().clear();
                this.getServers().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getPlans().clear();
                this.getPlans().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getBuilds().clear();
                this.getBuilds().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getServers().clear();
                return;
            }
            case 1: {
                this.getPlans().clear();
                return;
            }
            case 2: {
                this.getBuilds().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.servers != null && !this.servers.isEmpty();
            }
            case 1: {
                return this.plans != null && !this.plans.isEmpty();
            }
            case 2: {
                return this.builds != null && !this.builds.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void refresh(IOperationMonitor monitor) {
    }

    public IBuildPlan getPlanById(String id) {
        if (id != null) {
            for (IBuildPlan plan : this.getPlans()) {
                if (!id.equals(plan.getName())) continue;
                return plan;
            }
        }
        return null;
    }

    public List<IBuildPlan> getPlans(IBuildServer server) {
        ArrayList<IBuildPlan> result = new ArrayList<IBuildPlan>();
        for (IBuildPlan plan : this.getPlans()) {
            if (plan.getServer() != server) continue;
            result.add(plan);
        }
        return result;
    }

    public synchronized void setScheduler(BuildScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public synchronized BuildScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new BuildScheduler();
        }
        return this.scheduler;
    }

    public IBuildLoader getLoader() {
        return this.loader;
    }

    public void setLoader(IBuildLoader loader) {
        this.loader = loader;
    }
}

